/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.core.debugger;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.debug.core.PHPDebugPlugin;
import org.eclipse.php.debug.core.debugger.DebugParametersInitializersRegistry;
import org.eclipse.php.debug.core.debugger.parameters.IDebugParametersInitializer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PHPExecutableDebuggerInitializer {
    public static final String EXECUTABLE_LAUNCH = "executable_launch";
    private HashMap systemEnvironmentVariables = null;
    private ILaunch launch;

    public PHPExecutableDebuggerInitializer(ILaunch iLaunch) throws IOException {
        this.launch = iLaunch;
        iLaunch.setAttribute(EXECUTABLE_LAUNCH, "true");
        this.initializeSystemEnvironmentVariables();
    }

    public void initializeDebug(String string, String string2) {
        this.initializeDebug(string, string2, null);
    }

    public void initializeDebug(String string, String string2, Map map) {
        try {
            Path path = new Path(string);
            File file = new File(path.removeLastSegments(1).toString());
            String string3 = file.getAbsolutePath();
            String string4 = this.launch.getAttribute("PHPIniLocation");
            if (string4 != null && !string4.equals("")) {
                string3 = string4;
            }
            IDebugParametersInitializer iDebugParametersInitializer = DebugParametersInitializersRegistry.getBestMatchDebugParametersInitializer(this.launch);
            this.systemEnvironmentVariables.put("REQUEST_METHOD", "GET");
            this.systemEnvironmentVariables.put("SCRIPT_FILENAME", string2);
            this.systemEnvironmentVariables.put("SCRIPT_NAME", string2);
            this.systemEnvironmentVariables.put("PATH_TRANSLATED", string2);
            this.systemEnvironmentVariables.put("PATH_INFO", string2);
            this.systemEnvironmentVariables.put("QUERY_STRING", String.valueOf(iDebugParametersInitializer.generateQuery(this.launch)) + "&debug_host=127.0.0.1");
            this.systemEnvironmentVariables.put("REDIRECT_STATUS", "1");
            this.systemEnvironmentVariables.put("PHPRC", string3);
            if (map != null) {
                this.systemEnvironmentVariables.putAll(map);
            }
            String[] stringArray = this.mapAsArray(this.systemEnvironmentVariables);
            String[] stringArray2 = new String[]{string, "-c", string3, string2};
            Process process = Runtime.getRuntime().exec(stringArray2, stringArray, file);
            ProcessOutputReader processOutputReader = new ProcessOutputReader(process);
            new Thread(processOutputReader).start();
        }
        catch (Exception exception) {
            final Display display = Display.getDefault();
            display.asyncExec(new Runnable(){

                public void run() {
                    String string = exception.getLocalizedMessage();
                    string = string.replaceFirst(String.valueOf(exception.getClass().getName()) + ": ", "");
                    MessageDialog.openError((Shell)display.getActiveShell(), (String)"Error", (String)NLS.bind((String)"Error running PHP executable:\n\n{0}", (Object)string));
                }
            });
            DebugPlugin.log((Throwable)exception);
        }
    }

    private String[] mapAsArray(Map map) {
        String[] stringArray = new String[map.size()];
        Iterator iterator = map.entrySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            stringArray[n++] = entry.getKey() + "=" + entry.getValue();
        }
        return stringArray;
    }

    private void initializeSystemEnvironmentVariables() throws IOException {
        String string;
        Process process;
        ArrayList<String> arrayList = new ArrayList<String>();
        Runtime runtime = Runtime.getRuntime();
        String string2 = System.getProperty("os.name").toLowerCase();
        if (string2.indexOf("windows") > -1) {
            process = string2.indexOf("windows 9") > -1 ? runtime.exec("command.com /c set") : runtime.exec("cmd.exe /c set");
        } else if (string2.indexOf("linux") > -1) {
            process = runtime.exec("env");
        } else if (string2.indexOf("unix") > -1) {
            process = runtime.exec("/bin/env");
        } else if (string2.indexOf("sunos") > -1) {
            process = runtime.exec("/bin/env");
        } else if (string2.indexOf("mac") > -1) {
            try {
                process = runtime.exec("env");
            }
            catch (IOException iOException) {
                process = runtime.exec("setenv");
            }
        } else if (string2.indexOf("freebsd") > -1) {
            process = runtime.exec("set");
        } else {
            System.out.println("OS not known: " + string2);
            this.systemEnvironmentVariables = new HashMap(0);
            return;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((string = bufferedReader.readLine()) != null) {
            arrayList.add(string);
        }
        bufferedReader.close();
        this.systemEnvironmentVariables = new HashMap();
        int n = 0;
        while (n < arrayList.size()) {
            String[] stringArray = ((String)arrayList.get(n)).split("=");
            if (stringArray.length == 2) {
                this.systemEnvironmentVariables.put(stringArray[0], stringArray[1]);
            } else if (stringArray.length == 1) {
                this.systemEnvironmentVariables.put(stringArray[0], "");
            }
            ++n;
        }
    }

    private static class ProcessOutputReader
    implements Runnable {
        Process p;

        ProcessOutputReader(Process process) {
            this.p = process;
        }

        public void run() {
            try {
                byte[] byArray = new byte[1000];
                InputStream inputStream = this.p.getInputStream();
                int n = inputStream.read(byArray);
                while (n > 0) {
                    n = inputStream.read(byArray);
                }
                inputStream = this.p.getErrorStream();
                n = inputStream.read(byArray);
                while (n != -1) {
                    n = inputStream.read(byArray);
                }
            }
            catch (IOException iOException) {
                PHPDebugPlugin.log(iOException);
            }
        }
    }
}

