/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.Messages;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.internal.junit.wizards.JUnitWizard;
import org.eclipse.jdt.internal.junit.wizards.UpdateTestSuite;
import org.eclipse.jdt.internal.junit.wizards.WizardMessages;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.junit.wizards.NewTestSuiteWizardPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;

public class NewTestSuiteCreationWizard
extends JUnitWizard {
    private NewTestSuiteWizardPage fPage;

    public NewTestSuiteCreationWizard() {
        this.setWindowTitle(WizardMessages.Wizard_title_new_testsuite);
        this.initDialogSettings();
    }

    public void addPages() {
        super.addPages();
        this.fPage = new NewTestSuiteWizardPage();
        this.addPage((IWizardPage)this.fPage);
        this.fPage.init(this.getSelection());
    }

    public boolean performFinish() {
        String filename;
        IPackageFragment pack = this.fPage.getPackageFragment();
        ICompilationUnit cu = pack.getCompilationUnit(filename = String.valueOf(this.fPage.getTypeName()) + ".java");
        if (cu.exists()) {
            IType suiteType;
            IMethod suiteMethod;
            boolean saveUnsavedChanges;
            IEditorPart cu_ep = EditorUtility.isOpenInEditor((Object)cu);
            if (cu_ep != null && cu_ep.isDirty() && (saveUnsavedChanges = MessageDialog.openQuestion((Shell)this.fPage.getShell(), (String)WizardMessages.NewTestSuiteWiz_unsavedchangesDialog_title, (String)Messages.format(WizardMessages.NewTestSuiteWiz_unsavedchangesDialog_message, filename)))) {
                try {
                    this.getContainer().run(false, false, this.getRunnableSave(cu_ep));
                }
                catch (Exception e) {
                    JUnitPlugin.log(e);
                }
            }
            if ((suiteMethod = (suiteType = cu.getType(this.fPage.getTypeName())).getMethod("suite", new String[0])).exists()) {
                try {
                    ISourceRange range = suiteMethod.getSourceRange();
                    IBuffer buf = cu.getBuffer();
                    String originalContent = buf.getText(range.getOffset(), range.getLength());
                    if (UpdateTestSuite.getTestSuiteClassListRange(originalContent) == null) {
                        this.cannotUpdateSuiteError();
                        return false;
                    }
                }
                catch (JavaModelException e) {
                    JUnitPlugin.log(e);
                    return false;
                }
            }
        }
        if (this.finishPage(this.fPage.getRunnable())) {
            if (!this.fPage.hasUpdatedExistingClass()) {
                this.postCreatingType();
            }
            return true;
        }
        return false;
    }

    private void cannotUpdateSuiteError() {
        MessageDialog.openError((Shell)this.getShell(), (String)WizardMessages.NewTestSuiteWizPage_cannotUpdateDialog_title, (String)Messages.format(WizardMessages.NewTestSuiteWizPage_cannotUpdateDialog_message, new String[]{"//$JUnit-BEGIN$", "//$JUnit-END$"}));
    }

    protected void postCreatingType() {
        IType newClass = this.fPage.getCreatedType();
        if (newClass == null) {
            return;
        }
        ICompilationUnit cu = newClass.getCompilationUnit();
        IResource resource = cu.getResource();
        if (resource != null) {
            this.selectAndReveal(resource);
            this.openResource(resource);
        }
    }

    public NewTestSuiteWizardPage getPage() {
        return this.fPage;
    }

    protected void initializeDefaultPageImageDescriptor() {
        this.setDefaultPageImageDescriptor(JUnitPlugin.getImageDescriptor("wizban/newtest_wiz.png"));
    }

    public IRunnableWithProgress getRunnableSave(final IEditorPart cu_ep) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                cu_ep.doSave(monitor);
            }
        };
    }
}

