/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.io.IOException;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.IntermediateOutputStream;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.buf.WriteConvertor;

public final class C2BConverter {
    private IntermediateOutputStream ios;
    private WriteConvertor conv;
    private ByteChunk bb;
    private String enc;

    public C2BConverter(ByteChunk output, String encoding) throws IOException {
        this.bb = output;
        this.ios = new IntermediateOutputStream(output);
        this.conv = new WriteConvertor(this.ios, encoding);
        this.enc = encoding;
    }

    public C2BConverter(String encoding) throws IOException {
        this(new ByteChunk(1024), encoding);
    }

    public ByteChunk getByteChunk() {
        return this.bb;
    }

    public String getEncoding() {
        return this.enc;
    }

    public void setByteChunk(ByteChunk bb) {
        this.bb = bb;
        this.ios.setByteChunk(bb);
    }

    public final void recycle() {
        this.conv.recycle();
        this.bb.recycle();
    }

    public final void convert(char[] c, int off, int len) throws IOException {
        this.conv.write(c, off, len);
    }

    public final void convert(String s) throws IOException {
        this.conv.write(s);
    }

    public final void convert(char c) throws IOException {
        this.conv.write(c);
    }

    public final void convert(MessageBytes mb) throws IOException {
        int type = mb.getType();
        if (type == 2) {
            return;
        }
        ByteChunk orig = this.bb;
        this.setByteChunk(mb.getByteChunk());
        this.bb.recycle();
        this.bb.allocate(32, -1);
        if (type == 1) {
            this.convert(mb.getString());
        } else if (type == 3) {
            CharChunk charC = mb.getCharChunk();
            this.convert(charC.getBuffer(), charC.getOffset(), charC.getLength());
        } else {
            System.out.println("XXX unknowon type " + type);
        }
        this.flushBuffer();
        this.setByteChunk(orig);
    }

    public final void flushBuffer() throws IOException {
        this.conv.flush();
    }
}

