/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberResourceMappingContext;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.Update;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.SingleCommandOperation;
import org.eclipse.ui.IWorkbenchPart;

public class UpdateOperation
extends SingleCommandOperation {
    private CVSTag tag;

    public UpdateOperation(IWorkbenchPart part, IResource[] resources, Command.LocalOption[] options, CVSTag tag) {
        this(part, UpdateOperation.asResourceMappers(resources), options, tag);
    }

    public UpdateOperation(IWorkbenchPart part, ResourceMapping[] mappings, Command.LocalOption[] options, CVSTag tag) {
        super(part, mappings, options);
        this.tag = tag;
    }

    protected IStatus executeCommand(Session session, CVSTeamProvider provider, ICVSResource[] resources, boolean recurse, IProgressMonitor monitor) throws CVSException, InterruptedException {
        Command.LocalOption[] commandOptions = this.getLocalOptions(recurse);
        monitor.beginTask(null, 100);
        IStatus execute = this.getUpdateCommand().execute(session, Command.NO_GLOBAL_OPTIONS, commandOptions, resources, this.getCommandOutputListener(), Policy.subMonitorFor(monitor, 95));
        this.updateWorkspaceSubscriber(provider, resources, recurse, Policy.subMonitorFor(monitor, 5));
        monitor.done();
        return execute;
    }

    protected Command.LocalOption[] getLocalOptions(boolean recurse) {
        ArrayList<Command.LocalOption> localOptions = new ArrayList<Command.LocalOption>();
        if (this.tag != null) {
            localOptions.add(Update.makeTagOption((CVSTag)this.tag));
        }
        localOptions.addAll(Arrays.asList(super.getLocalOptions(recurse)));
        Command.LocalOption[] commandOptions = localOptions.toArray(new Command.LocalOption[localOptions.size()]);
        return commandOptions;
    }

    protected Update getUpdateCommand() {
        return Command.UPDATE;
    }

    protected String getTaskName() {
        return CVSUIMessages.UpdateOperation_taskName;
    }

    protected String getTaskName(CVSTeamProvider provider) {
        return NLS.bind((String)CVSUIMessages.UpdateOperation_0, (Object[])new String[]{provider.getProject().getName()});
    }

    protected ICommandOutputListener getCommandOutputListener() {
        return null;
    }

    protected boolean isReportableError(IStatus status) {
        return super.isReportableError(status) || status.getCode() == -26 || status.getCode() == -27 || status.getCode() == -28;
    }

    protected String getErrorMessage(IStatus[] failures, int totalOperations) {
        return CVSUIMessages.UpdateAction_update;
    }

    protected ResourceMappingContext getResourceMappingContext() {
        return SubscriberResourceMappingContext.createContext((Subscriber)CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber());
    }

    public CVSTag getTag() {
        return this.tag;
    }

    public void setTag(CVSTag tag) {
        this.tag = tag;
    }
}

