/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.patch;

import com.ibm.icu.text.MessageFormat;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.Splitter;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.internal.patch.Diff;
import org.eclipse.compare.internal.patch.DiffProject;
import org.eclipse.compare.internal.patch.Hunk;
import org.eclipse.compare.internal.patch.PatchMessages;
import org.eclipse.compare.internal.patch.PatchWizard;
import org.eclipse.compare.internal.patch.PreviewPatchLabelDecorator;
import org.eclipse.compare.internal.patch.WorkspacePatcher;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.model.WorkbenchViewerSorter;
import org.eclipse.ui.views.navigator.ResourceSorter;

class PreviewPatchPage
extends WizardPage {
    private PatchWizard fPatchWizard;
    private ContainerCheckedTreeViewer fTreeViewer;
    private Combo fStripPrefixSegments;
    private CompareViewerSwitchingPane fHunkViewer;
    private Button fIgnoreWhitespaceButton;
    private Button fReversePatchButton;
    private Text fFuzzField;
    private Button fMatchProject;
    private Object inputElement;
    private CompareConfiguration fCompareConfiguration;
    protected boolean pageRecalculate = true;
    protected static final String PREVIEWPATCHPAGE_NAME = "PreviewPatchPage";

    PreviewPatchPage(PatchWizard pw) {
        super(PREVIEWPATCHPAGE_NAME, PatchMessages.PreviewPatchPage_title, null);
        this.setMessage(PatchMessages.PreviewPatchPage_message);
        this.fPatchWizard = pw;
        this.fCompareConfiguration = new CompareConfiguration();
        this.fCompareConfiguration.setLeftEditable(false);
        this.fCompareConfiguration.setLeftLabel(PatchMessages.PreviewPatchPage_Left_title);
        this.fCompareConfiguration.setRightEditable(false);
        this.fCompareConfiguration.setRightLabel(PatchMessages.PreviewPatchPage_Right_title);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.buildTree();
            this.updateTree();
        }
        super.setVisible(visible);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.compare.patch_preview_wizard_page_context");
        this.setControl((Control)composite);
        this.initializeDialogUnits((Control)parent);
        this.buildPatchOptionsGroup(composite);
        Splitter splitter = new Splitter(composite, 512);
        splitter.setLayoutData(new GridData(1808));
        this.createTreeViewer(splitter);
        this.fHunkViewer = new CompareViewerSwitchingPane((Composite)splitter, 0x800800){

            protected Viewer getViewer(Viewer oldViewer, Object input) {
                return CompareUI.findContentViewer(oldViewer, (ICompareInput)input, (Composite)this, PreviewPatchPage.this.fCompareConfiguration);
            }
        };
        this.fHunkViewer.setLayoutData(new GridData(4, 4, true, true));
        this.fMatchProject = new Button(composite, 8);
        this.fMatchProject.setLayoutData((Object)new GridData(0x1000008, 1, false, false));
        this.fMatchProject.setText(PatchMessages.PreviewPatchPage_MatchProjects);
        this.fMatchProject.setEnabled(false);
        this.fMatchProject.setVisible(false);
        this.fMatchProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RetargetPatchDialog dialog = new RetargetPatchDialog(PreviewPatchPage.this.getShell(), PreviewPatchPage.this.fTreeViewer.getSelection());
                dialog.open();
                PreviewPatchPage.this.updateTree();
            }
        });
        this.buildTree();
        Dialog.applyDialogFont((Control)composite);
    }

    private void createTreeViewer(Splitter splitter) {
        this.fTreeViewer = new ContainerCheckedTreeViewer((Composite)splitter, 2048);
        this.fTreeViewer.setContentProvider((IContentProvider)new BaseWorkbenchContentProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), (ILabelDecorator)new PreviewPatchLabelDecorator()));
        this.fTreeViewer.setSorter((ViewerSorter)new WorkbenchViewerSorter());
        this.fTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                PreviewPatchPage.this.fTreeViewer.setSubtreeChecked(event.getElement(), event.getChecked());
                PreviewPatchPage.this.updateEnablements();
            }
        });
        this.fTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TreeSelection treeSel;
                Object res;
                ISelection selection = event.getSelection();
                if (selection instanceof TreeSelection && (res = (treeSel = (TreeSelection)selection).getFirstElement()) != null && (res instanceof DiffProject || res instanceof Diff)) {
                    if (PreviewPatchPage.this.fTreeViewer.getExpandedState(res)) {
                        PreviewPatchPage.this.fTreeViewer.collapseToLevel(res, 1);
                    } else {
                        PreviewPatchPage.this.fTreeViewer.expandToLevel(res, 1);
                    }
                }
            }
        });
        this.fTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                Object obj = sel.getFirstElement();
                if (obj instanceof Hunk) {
                    PreviewPatchPage.this.fHunkViewer.setInput(PreviewPatchPage.this.createInput((Hunk)obj));
                } else {
                    PreviewPatchPage.this.fHunkViewer.setInput(null);
                }
                PreviewPatchPage.this.fMatchProject.setEnabled(false);
                if (PreviewPatchPage.this.fPatchWizard.getPatcher().isWorkspacePatch() && obj instanceof DiffProject) {
                    PreviewPatchPage.this.fMatchProject.setEnabled(true);
                }
            }
        });
        this.fTreeViewer.setInput(null);
    }

    private void buildPatchOptionsGroup(Composite parent) {
        final WorkspacePatcher patcher = this.fPatchWizard.getPatcher();
        Group group = new Group(parent, 0);
        group.setText(PatchMessages.PreviewPatchPage_PatchOptions_title);
        GridLayout gl = new GridLayout();
        gl.numColumns = 4;
        group.setLayout((Layout)gl);
        group.setLayoutData((Object)new GridData(768));
        Composite pair = new Composite((Composite)group, 0);
        gl = new GridLayout();
        gl.numColumns = 2;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        pair.setLayout((Layout)gl);
        GridData gd = new GridData(256);
        pair.setLayoutData((Object)gd);
        Label l = new Label(pair, 0);
        l.setText(PatchMessages.PreviewPatchPage_IgnoreSegments_text);
        gd = new GridData(548);
        l.setLayoutData((Object)gd);
        this.fStripPrefixSegments = new Combo(pair, 76);
        int prefixCnt = patcher.getStripPrefixSegments();
        String prefix = Integer.toString(prefixCnt);
        this.fStripPrefixSegments.add(prefix);
        this.fStripPrefixSegments.setText(prefix);
        gd = new GridData(132);
        this.fStripPrefixSegments.setLayoutData((Object)gd);
        this.addSpacer((Composite)group);
        this.fReversePatchButton = new Button((Composite)group, 32);
        this.fReversePatchButton.setText(PatchMessages.PreviewPatchPage_ReversePatch_text);
        this.addSpacer((Composite)group);
        pair = new Composite((Composite)group, 0);
        gl = new GridLayout();
        gl.numColumns = 3;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        pair.setLayout((Layout)gl);
        gd = new GridData(256);
        pair.setLayoutData((Object)gd);
        l = new Label(pair, 0);
        l.setText(PatchMessages.PreviewPatchPage_FuzzFactor_text);
        l.setToolTipText(PatchMessages.PreviewPatchPage_FuzzFactor_tooltip);
        gd = new GridData(548);
        l.setLayoutData((Object)gd);
        this.fFuzzField = new Text(pair, 2048);
        this.fFuzzField.setText("2");
        gd = new GridData(132);
        gd.widthHint = 30;
        this.fFuzzField.setLayoutData((Object)gd);
        Button b = new Button(pair, 8);
        b.setText(PatchMessages.PreviewPatchPage_GuessFuzz_text);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int fuzz = PreviewPatchPage.this.guessFuzzFactor(patcher);
                if (fuzz >= 0) {
                    PreviewPatchPage.this.fFuzzField.setText(Integer.toString(fuzz));
                }
            }
        });
        gd = new GridData(4);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        Point minSize = b.computeSize(-1, -1, true);
        gd.widthHint = Math.max(widthHint, minSize.x);
        b.setLayoutData((Object)gd);
        this.addSpacer((Composite)group);
        this.fIgnoreWhitespaceButton = new Button((Composite)group, 32);
        this.fIgnoreWhitespaceButton.setText(PatchMessages.PreviewPatchPage_IgnoreWhitespace_text);
        this.addSpacer((Composite)group);
        if (this.fStripPrefixSegments != null) {
            this.fStripPrefixSegments.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (patcher.setStripPrefixSegments(PreviewPatchPage.this.getStripPrefixSegments())) {
                        PreviewPatchPage.this.updateTree();
                    }
                }
            });
        }
        this.fReversePatchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (patcher.setReversed(PreviewPatchPage.this.fReversePatchButton.getSelection())) {
                    PreviewPatchPage.this.updateTree();
                }
            }
        });
        this.fIgnoreWhitespaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (patcher.setIgnoreWhitespace(PreviewPatchPage.this.fIgnoreWhitespaceButton.getSelection())) {
                    PreviewPatchPage.this.updateTree();
                }
            }
        });
        this.fFuzzField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (patcher.setFuzz(PreviewPatchPage.this.getFuzzFactor())) {
                    PreviewPatchPage.this.updateTree();
                }
            }
        });
    }

    private int guessFuzzFactor(final WorkspacePatcher patcher) {
        final int strip = this.getStripPrefixSegments();
        final int[] result = new int[1];
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    result[0] = PreviewPatchPage.this.guess(patcher, monitor, strip);
                }
            });
            return result[0];
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int guess(WorkspacePatcher patcher, IProgressMonitor pm, int strip) {
        int n;
        Diff[] diffs = patcher.getDiffs();
        if (diffs == null) return -1;
        if (diffs.length <= 0) {
            return -1;
        }
        IFile[] files = new IFile[diffs.length];
        int work = 0;
        int i = 0;
        while (i < diffs.length) {
            Diff diff = diffs[i];
            if (diff != null && diff.getType() != 1) {
                IFile file;
                IPath p = diff.fOldPath;
                if (strip > 0 && strip < p.segmentCount()) {
                    p = p.removeFirstSegments(strip);
                }
                if ((file = this.existsInSelection(p)) != null) {
                    files[i] = file;
                    work += diff.fHunks.size();
                }
            }
            ++i;
        }
        int[] fuzzRef = new int[1];
        String format = PatchMessages.PreviewPatchPage_GuessFuzzProgress_format;
        pm.beginTask(PatchMessages.PreviewPatchPage_GuessFuzzProgress_text, work);
        try {
            int fuzz = 0;
            int i2 = 0;
            while (true) {
                if (i2 >= diffs.length) break;
                Diff d = diffs[i2];
                IFile file = files[i2];
                if (d != null && file != null) {
                    List lines = patcher.load(file, false);
                    String name = d.getPath().lastSegment();
                    Iterator iter = d.fHunks.iterator();
                    int shift = 0;
                    int hcnt = 1;
                    while (iter.hasNext()) {
                        pm.subTask(MessageFormat.format((String)format, (Object[])new String[]{name, Integer.toString(hcnt)}));
                        Hunk h = (Hunk)iter.next();
                        shift = patcher.calculateFuzz(h, lines, shift, pm, fuzzRef);
                        int f = fuzzRef[0];
                        if (f == -1) {
                            Object var20_23 = null;
                            pm.done();
                            return -1;
                        }
                        if (f > fuzz) {
                            fuzz = f;
                        }
                        pm.worked(1);
                        ++hcnt;
                    }
                }
                ++i2;
            }
            n = fuzz;
            Object var20_24 = null;
        }
        catch (Throwable throwable) {
            Object var20_25 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return n;
    }

    ICompareInput createInput(Hunk hunk) {
        String[] lines = hunk.fLines;
        StringBuffer left = new StringBuffer();
        StringBuffer right = new StringBuffer();
        int i = 0;
        while (i < lines.length) {
            String line = lines[i];
            String rest = line.substring(1);
            switch (line.charAt(0)) {
                case ' ': {
                    left.append(rest);
                    right.append(rest);
                    break;
                }
                case '-': {
                    left.append(rest);
                    break;
                }
                case '+': {
                    right.append(rest);
                }
            }
            ++i;
        }
        Diff diff = hunk.fParent;
        IPath path = diff.getPath();
        String type = path.getFileExtension();
        return new DiffNode(new HunkInput(type, left.toString()), new HunkInput(type, right.toString()));
    }

    private IFile existsInSelection(IPath path) {
        return this.fPatchWizard.getPatcher().existsInTarget(path);
    }

    private void buildTree() {
        this.inputElement = this.fPatchWizard.getPatcher();
        int length = 99;
        if (this.fStripPrefixSegments != null && this.pageRecalculate && (length = this.fPatchWizard.getPatcher().calculatePrefixSegmentCount()) != 99) {
            int k = 1;
            while (k < length) {
                this.fStripPrefixSegments.add(Integer.toString(k));
                ++k;
            }
            this.pageRecalculate = false;
        }
        this.fTreeViewer.setInput(this.inputElement);
    }

    private void updateTree() {
        if (this.fTreeViewer == null) {
            return;
        }
        int strip = this.getStripPrefixSegments();
        BaseWorkbenchContentProvider contentProvider = (BaseWorkbenchContentProvider)this.fTreeViewer.getContentProvider();
        Object[] projects = contentProvider.getElements(this.inputElement);
        ArrayList hunksToCheck = new ArrayList();
        int j = 0;
        while (j < projects.length) {
            if (projects[j] instanceof DiffProject) {
                DiffProject project = (DiffProject)projects[j];
                hunksToCheck.addAll(project.reset(this.fPatchWizard.getPatcher(), strip, this.getFuzzFactor()));
                Iterator iter = project.fDiffs.iterator();
                while (iter.hasNext()) {
                    Diff diff = (Diff)iter.next();
                    this.fTreeViewer.update((Object)diff, null);
                }
            } else if (projects[j] instanceof Diff) {
                Diff diff = (Diff)projects[j];
                hunksToCheck.addAll(diff.reset(this.fPatchWizard.getPatcher(), strip, this.getFuzzFactor()));
                this.fTreeViewer.update((Object)diff, null);
            }
            ++j;
        }
        this.fTreeViewer.refresh();
        this.fTreeViewer.setCheckedElements(hunksToCheck.toArray());
        this.updateEnablements();
    }

    private void addSpacer(Composite parent) {
        Label label = new Label(parent, 0);
        GridData gd = new GridData(768);
        gd.widthHint = 20;
        label.setLayoutData((Object)gd);
    }

    private int getStripPrefixSegments() {
        int stripPrefixSegments = 0;
        if (this.fStripPrefixSegments != null) {
            String s = this.fStripPrefixSegments.getText();
            try {
                stripPrefixSegments = Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return stripPrefixSegments;
    }

    private int getFuzzFactor() {
        int fuzzFactor = 0;
        if (this.fFuzzField != null) {
            String s = this.fFuzzField.getText();
            try {
                fuzzFactor = Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return fuzzFactor;
    }

    void updateEnablements() {
        boolean atLeastOneIsEnabled = false;
        if (this.fTreeViewer != null) {
            BaseWorkbenchContentProvider contentProvider = (BaseWorkbenchContentProvider)this.fTreeViewer.getContentProvider();
            Object[] projects = contentProvider.getElements(this.inputElement);
            int j = 0;
            while (j < projects.length) {
                if (projects[j] instanceof DiffProject) {
                    DiffProject project = (DiffProject)projects[j];
                    Object[] diffs = project.getChildren(project);
                    int i = 0;
                    while (i < diffs.length) {
                        Diff diff = (Diff)diffs[i];
                        atLeastOneIsEnabled = this.updateEnablement(atLeastOneIsEnabled, diff);
                        ++i;
                    }
                } else if (projects[j] instanceof Diff) {
                    Diff diff = (Diff)projects[j];
                    atLeastOneIsEnabled = this.updateEnablement(atLeastOneIsEnabled, diff);
                }
                ++j;
            }
        }
        this.fMatchProject.setVisible(this.fPatchWizard.getPatcher().isWorkspacePatch());
        this.setPageComplete(atLeastOneIsEnabled);
    }

    private boolean updateEnablement(boolean atLeastOneIsEnabled, Diff diff) {
        boolean checked = this.fTreeViewer.getChecked((Object)diff);
        diff.setEnabled(checked);
        if (checked) {
            Object[] hunkItems = diff.getChildren(diff);
            int h = 0;
            while (h < hunkItems.length) {
                Hunk hunk = (Hunk)hunkItems[h];
                checked = this.fTreeViewer.getChecked((Object)hunk);
                hunk.setEnabled(checked);
                if (checked) {
                    boolean projectExists = true;
                    DiffProject project = (DiffProject)diff.getParent(null);
                    if (project != null) {
                        projectExists = project.getProject().exists();
                    }
                    if (projectExists) {
                        atLeastOneIsEnabled = true;
                    }
                }
                ++h;
            }
        }
        return atLeastOneIsEnabled;
    }

    static class HunkInput
    implements ITypedElement,
    IEncodedStreamContentAccessor {
        static final String UTF_16 = "UTF-16";
        String fContent;
        String fType;

        HunkInput(String type, String s) {
            this.fType = type;
            this.fContent = s;
        }

        public Image getImage() {
            return null;
        }

        public String getName() {
            return PatchMessages.PreviewPatchPage_NoName_text;
        }

        public String getType() {
            return this.fType;
        }

        public InputStream getContents() {
            return new ByteArrayInputStream(Utilities.getBytes(this.fContent, UTF_16));
        }

        public String getCharset() {
            return UTF_16;
        }
    }

    class RetargetPatchContentProvider
    extends BaseWorkbenchContentProvider {
        boolean showClosedProjects = false;

        RetargetPatchContentProvider() {
        }

        public Object[] getChildren(Object element) {
            if (element instanceof IWorkspace) {
                Object[] allProjects = ((IWorkspace)element).getRoot().getProjects();
                if (this.showClosedProjects) {
                    return allProjects;
                }
                ArrayList<Object> accessibleProjects = new ArrayList<Object>();
                int i = 0;
                while (i < allProjects.length) {
                    if (allProjects[i].isOpen()) {
                        accessibleProjects.add(allProjects[i]);
                    }
                    ++i;
                }
                return accessibleProjects.toArray();
            }
            if (element instanceof IProject) {
                return new Object[0];
            }
            return super.getChildren(element);
        }
    }

    class RetargetPatchDialog
    extends Dialog {
        protected TreeViewer rpTreeViewer;
        protected DiffProject rpSelectedProject;
        protected IProject rpTargetProject;

        public RetargetPatchDialog(Shell shell, ISelection selection) {
            super(shell);
            this.setShellStyle(this.getShellStyle() | 0x10);
            if (selection instanceof IStructuredSelection) {
                this.rpSelectedProject = (DiffProject)((IStructuredSelection)selection).getFirstElement();
            }
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            this.initializeDialogUnits((Control)parent);
            this.getShell().setText(PatchMessages.PreviewPatchPage_RetargetPatch);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            composite.setLayout((Layout)layout);
            GridData data = new GridData(4, 4, true, true);
            composite.setLayoutData((Object)data);
            Label label = new Label(composite, 16448);
            label.setText(NLS.bind((String)PatchMessages.PreviewPatchPage_SelectProject, (Object)this.rpSelectedProject.getName()));
            GridData data2 = new GridData(4, 1, true, false);
            label.setLayoutData((Object)data2);
            this.rpTreeViewer = new TreeViewer(composite, 2048);
            GridData gd = new GridData(4, 4, true, true);
            gd.widthHint = 0;
            gd.heightHint = 0;
            this.rpTreeViewer.getTree().setLayoutData((Object)gd);
            this.rpTreeViewer.setContentProvider((IContentProvider)new RetargetPatchContentProvider());
            this.rpTreeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
            this.rpTreeViewer.setSorter((ViewerSorter)new ResourceSorter(1));
            this.rpTreeViewer.setInput((Object)ResourcesPlugin.getWorkspace());
            this.rpTreeViewer.setSelection((ISelection)new StructuredSelection((Object)this.rpSelectedProject.getProject()));
            this.setupListeners();
            Dialog.applyDialogFont((Control)composite);
            return parent;
        }

        protected void okPressed() {
            this.rpSelectedProject.setProject(this.rpTargetProject);
            super.okPressed();
        }

        void setupListeners() {
            this.rpTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(this){
                final /* synthetic */ RetargetPatchDialog this$1;
                {
                    this.this$1 = retargetPatchDialog;
                }

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection s = (IStructuredSelection)event.getSelection();
                    Object obj = s.getFirstElement();
                    if (obj instanceof IProject) {
                        this.this$1.rpTargetProject = (IProject)obj;
                    }
                }
            });
            this.rpTreeViewer.addDoubleClickListener(new IDoubleClickListener(this){
                final /* synthetic */ RetargetPatchDialog this$1;
                {
                    this.this$1 = retargetPatchDialog;
                }

                public void doubleClick(DoubleClickEvent event) {
                    ISelection s = event.getSelection();
                    if (s instanceof IStructuredSelection) {
                        Object item = ((IStructuredSelection)s).getFirstElement();
                        if (this.this$1.rpTreeViewer.getExpandedState(item)) {
                            this.this$1.rpTreeViewer.collapseToLevel(item, 1);
                        } else {
                            this.this$1.rpTreeViewer.expandToLevel(item, 1);
                        }
                    }
                }
            });
        }

        protected Point getInitialSize() {
            Point size = super.getInitialSize();
            size.x = this.convertWidthInCharsToPixels(75);
            size.y += this.convertHeightInCharsToPixels(20);
            return size;
        }
    }
}

