/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.reorg.RefactoringModifications;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.DeleteArguments;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;

public class DeleteModifications
extends RefactoringModifications {
    private List fDelete = new ArrayList();
    private List fPackagesToDelete = new ArrayList();

    public void delete(IResource resource) {
        this.fDelete.add(resource);
    }

    public void delete(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            this.delete(resources[i]);
            ++i;
        }
    }

    public void delete(IJavaElement[] elements) throws CoreException {
        int i = 0;
        while (i < elements.length) {
            this.delete(elements[i]);
            ++i;
        }
    }

    public void delete(IJavaElement element) throws CoreException {
        switch (element.getElementType()) {
            case 1: {
                return;
            }
            case 2: {
                this.fDelete.add(element);
                if (element.getResource() != null) {
                    this.getResourceModifications().addDelete(element.getResource());
                }
                return;
            }
            case 3: {
                this.fDelete.add(element);
                IResource resource = element.getResource();
                if (resource != null) {
                    this.getResourceModifications().addDelete(resource);
                }
                return;
            }
            case 4: {
                this.fDelete.add(element);
                this.fPackagesToDelete.add(element);
                return;
            }
            case 5: {
                this.fDelete.add(element);
                IType[] types = ((ICompilationUnit)element).getTypes();
                this.fDelete.addAll(Arrays.asList(types));
                if (element.getResource() != null) {
                    this.getResourceModifications().addDelete(element.getResource());
                }
                return;
            }
            case 7: {
                this.fDelete.add(element);
                IType type = (IType)element;
                ICompilationUnit unit = type.getCompilationUnit();
                if (type.getDeclaringType() == null && unit.getElementName().endsWith(type.getElementName()) && unit.getTypes().length == 1) {
                    this.fDelete.add(unit);
                    if (unit.getResource() != null) {
                        this.getResourceModifications().addDelete(unit.getResource());
                    }
                }
                return;
            }
        }
        this.fDelete.add(element);
    }

    public void postProcess() throws CoreException {
        Iterator iter = this.fPackagesToDelete.iterator();
        while (iter.hasNext()) {
            IPackageFragment pack = (IPackageFragment)iter.next();
            this.handlePackageFragmentDelete(pack);
        }
    }

    public void buildDelta(IResourceChangeDescriptionFactory deltaFactory) {
        Iterator iter = this.fDelete.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof IResource)) continue;
            deltaFactory.delete((IResource)element);
        }
        this.getResourceModifications().buildDelta(deltaFactory);
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, RefactoringProcessor owner, String[] natures, SharableParticipants shared) {
        ArrayList<Object> result = new ArrayList<Object>();
        Iterator iter = this.fDelete.iterator();
        while (iter.hasNext()) {
            result.addAll(Arrays.asList(ParticipantManager.loadDeleteParticipants((RefactoringStatus)status, (RefactoringProcessor)owner, iter.next(), (DeleteArguments)new DeleteArguments(), (String[])natures, (SharableParticipants)shared)));
        }
        result.addAll(Arrays.asList(this.getResourceModifications().getParticipants(status, owner, natures, shared)));
        return result.toArray(new RefactoringParticipant[result.size()]);
    }

    private void handlePackageFragmentDelete(IPackageFragment pack) throws CoreException {
        block11: {
            IResource[] members;
            block10: {
                IContainer container = (IContainer)pack.getResource();
                if (container == null) {
                    return;
                }
                members = container.members();
                if (pack.isDefaultPackage() || !this.canRemoveCompletely(pack)) break block10;
                boolean parentIsMarked = false;
                IPackageFragment parent = JavaElementUtil.getParentSubpackage(pack);
                parentIsMarked = parent == null ? false : this.fPackagesToDelete.contains(parent);
                if (parentIsMarked) {
                    if (!this.canRemoveCompletely(parent)) {
                        this.getResourceModifications().addDelete((IResource)container);
                    }
                } else {
                    this.getResourceModifications().addDelete((IResource)container);
                }
                break block11;
            }
            int m = 0;
            while (m < members.length) {
                block13: {
                    IPackageFragment frag;
                    IResource member;
                    block12: {
                        member = members[m];
                        if (!(member instanceof IFile)) break block12;
                        IFile file = (IFile)member;
                        if ("class".equals(file.getFileExtension()) && file.isDerived() || pack.isDefaultPackage() && !JavaCore.isJavaLikeFileName((String)file.getName())) break block13;
                        this.getResourceModifications().addDelete(member);
                    }
                    if (!pack.isDefaultPackage() && member instanceof IFolder && (frag = (IPackageFragment)JavaCore.create((IResource)member)) == null) {
                        this.getResourceModifications().addDelete(member);
                    }
                }
                ++m;
            }
        }
    }

    private boolean canRemoveCompletely(IPackageFragment pack) throws JavaModelException {
        IPackageFragment[] subPackages = JavaElementUtil.getPackageAndSubpackages(pack);
        int i = 0;
        while (i < subPackages.length) {
            if (!subPackages[i].equals(pack) && !this.fPackagesToDelete.contains(subPackages[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

