/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.filters;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.navigator.INavigatorContentService;

public class CustomizationTab
extends Composite {
    protected static final int MARGIN = 3;
    protected static final int TABLE_HEIGHT = 20;
    protected static final int TABLE_WIDTH = 140;
    protected static final int LABEL_HEIGHT = 15;
    protected static final int LABEL_WIDTH = 150;
    private FontMetrics fontMetrics;
    private Table table;
    private final INavigatorContentService contentService;
    private CheckboxTableViewer tableViewer;

    protected CustomizationTab(Composite parent, INavigatorContentService aContentService) {
        super(parent, 16);
        this.initializeDialogUnits();
        this.contentService = aContentService;
    }

    protected Table getTable() {
        return this.table;
    }

    protected void addSelectionChangedListener(ISelectionChangedListener selectionListener) {
        if (this.tableViewer != null) {
            this.tableViewer.addSelectionChangedListener(selectionListener);
        }
    }

    protected void createControl() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = Dialog.convertVerticalDLUsToPixels((FontMetrics)this.getFontMetrics(), (int)3);
        layout.marginWidth = Dialog.convertHorizontalDLUsToPixels((FontMetrics)this.getFontMetrics(), (int)3);
        layout.verticalSpacing = Dialog.convertVerticalDLUsToPixels((FontMetrics)this.getFontMetrics(), (int)4);
        layout.horizontalSpacing = Dialog.convertHorizontalDLUsToPixels((FontMetrics)this.getFontMetrics(), (int)4);
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        this.table = new Table((Composite)this, 67632);
        this.layoutTable(this.table);
        this.tableViewer = new CheckboxTableViewer(this.getTable());
    }

    protected void createInstructionsLabel(String labelText) {
        Label extensionsInstructionLabel = new Label((Composite)this, 65);
        GridData gridData = new GridData(784);
        gridData.horizontalIndent = Dialog.convertHorizontalDLUsToPixels((FontMetrics)this.getFontMetrics(), (int)2);
        gridData.widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)this.getFontMetrics(), (int)150);
        extensionsInstructionLabel.setLayoutData((Object)gridData);
        extensionsInstructionLabel.setText(labelText);
    }

    private void layoutTable(Table aTable) {
        GridLayout tableLayout = new GridLayout();
        tableLayout.marginHeight = 0;
        tableLayout.marginWidth = 0;
        tableLayout.verticalSpacing = 0;
        tableLayout.horizontalSpacing = 0;
        tableLayout.numColumns = 2;
        GridData tableGridData = new GridData(1808);
        tableGridData.widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)this.getFontMetrics(), (int)140);
        tableGridData.heightHint = Dialog.convertVerticalDLUsToPixels((FontMetrics)this.getFontMetrics(), (int)20);
        aTable.setLayout((Layout)tableLayout);
        aTable.setLayoutData((Object)tableGridData);
    }

    private void initializeDialogUnits() {
        GC gc = new GC((Drawable)this);
        gc.setFont(JFaceResources.getDialogFont());
        this.fontMetrics = gc.getFontMetrics();
        gc.dispose();
    }

    protected final FontMetrics getFontMetrics() {
        return this.fontMetrics;
    }

    protected final INavigatorContentService getContentService() {
        return this.contentService;
    }

    protected final CheckboxTableViewer getTableViewer() {
        return this.tableViewer;
    }
}

