/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.presentations;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.intro.impl.IntroPlugin;
import org.eclipse.ui.internal.intro.impl.Messages;
import org.eclipse.ui.internal.intro.impl.html.HTMLElement;
import org.eclipse.ui.internal.intro.impl.html.IntroHTMLGenerator;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroPage;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroPartImplementation;
import org.eclipse.ui.internal.intro.impl.model.History;
import org.eclipse.ui.internal.intro.impl.model.IntroContentProvider;
import org.eclipse.ui.internal.intro.impl.model.IntroHomePage;
import org.eclipse.ui.internal.intro.impl.model.IntroModelRoot;
import org.eclipse.ui.internal.intro.impl.model.loader.ContentProviderManager;
import org.eclipse.ui.internal.intro.impl.model.loader.IntroContentParser;
import org.eclipse.ui.internal.intro.impl.model.util.ModelUtil;
import org.eclipse.ui.internal.intro.impl.presentations.BrowserIntroPartLocationListener;
import org.eclipse.ui.internal.intro.impl.util.Log;
import org.eclipse.ui.internal.intro.impl.util.Util;
import org.eclipse.ui.intro.config.IIntroContentProvider;
import org.eclipse.ui.intro.config.IIntroContentProviderSite;
import org.eclipse.ui.intro.config.IIntroXHTMLContentProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BrowserIntroPartImplementation
extends AbstractIntroPartImplementation
implements IPropertyListener,
IIntroContentProviderSite {
    protected Browser browser = null;
    private IntroHTMLGenerator htmlGenerator = null;
    protected BrowserIntroPartLocationListener urlListener = new BrowserIntroPartLocationListener(this);

    protected void updateNavigationActionsState() {
        if (this.getModel().isDynamic()) {
            this.forwardAction.setEnabled(this.history.canNavigateForward());
            this.backAction.setEnabled(this.history.canNavigateBackward());
            return;
        }
        this.forwardAction.setEnabled(this.browser.isForwardEnabled());
        this.backAction.setEnabled(this.browser.isBackEnabled());
    }

    public void createPartControl(Composite parent) {
        long start = 0L;
        if (Log.logPerformance) {
            start = System.currentTimeMillis();
        }
        this.browser = new Browser(parent, 0);
        this.browser.addLocationListener((LocationListener)this.urlListener);
        this.browser.addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent event) {
            }

            public void completed(ProgressEvent event) {
                BrowserIntroPartImplementation.this.urlListener.flagEndOfNavigation();
                BrowserIntroPartImplementation.this.urlListener.flagEndOfFrameNavigation();
                BrowserIntroPartImplementation.this.urlListener.flagRemovedTempUrl();
                if (!BrowserIntroPartImplementation.this.getModel().isDynamic()) {
                    BrowserIntroPartImplementation.this.updateNavigationActionsState();
                }
            }
        });
        this.browser.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                event.doit = IntroPlugin.getDefault().isDebugging();
            }
        });
        if (Log.logPerformance) {
            Util.logPerformanceTime("creating a new Browser() took:", start);
        }
        this.addToolBarActions();
        if (!this.getModel().hasValidConfig()) {
            this.browser.setText(Messages.Browser_invalidConfig);
            return;
        }
        if (this.getModel().isDynamic()) {
            this.handleDynamicIntro();
        } else {
            this.handleStaticIntro();
        }
    }

    private void handleDynamicIntro() {
        IntroHomePage homePage = this.getModel().getHomePage();
        String cachedPage = this.getCachedCurrentPage();
        if (cachedPage != null) {
            if (History.isURL(cachedPage)) {
                boolean success = this.browser.setUrl(cachedPage);
                if (!success) {
                    Log.error("Unable to set the following ULR in browser: " + cachedPage, null);
                    return;
                }
                this.history.updateHistory(cachedPage);
            } else {
                this.getModel().setCurrentPageId(cachedPage, false);
                this.history.updateHistory(this.getModel().getCurrentPage());
            }
        } else {
            this.history.updateHistory(homePage);
        }
        this.getModel().addPropertyListener(this);
    }

    private boolean generateDynamicContentForPage(AbstractIntroPage page) {
        String printHtml;
        String content = null;
        if (page.isXHTMLPage()) {
            content = this.generateXHTMLPage(page, this);
        } else {
            HTMLElement html = this.getHTMLGenerator().generateHTMLforPage(page, this);
            if (html != null) {
                IntroModelRoot root = this.getModel();
                if (root != null) {
                    Map props;
                    Map map = props = root.getTheme() != null ? root.getTheme().getProperties() : null;
                    if (props != null) {
                        String value = (String)props.get("standardSupport");
                        String doctype = null;
                        if ("strict".equalsIgnoreCase(value)) {
                            doctype = this.generateDoctype(true);
                        } else if ("loose".equalsIgnoreCase(value)) {
                            doctype = this.generateDoctype(false);
                        }
                        if (doctype != null) {
                            content = String.valueOf(doctype) + html.toString();
                        }
                    }
                }
                if (content == null) {
                    content = html.toString();
                }
            }
        }
        if (content == null) {
            Log.error("Error generating HTML content for page", null);
            return false;
        }
        boolean success = false;
        if (this.browser != null) {
            long start = 0L;
            if (Log.logPerformance) {
                start = System.currentTimeMillis();
            }
            success = this.browser.setText(content);
            if (Log.logPerformance) {
                Util.logPerformanceTime("setText() on the browser took:", start);
            }
            if (!success) {
                Log.error("Unable to set HTML on the browser", null);
            }
        }
        if (IntroPlugin.getDefault().isDebugging() && (printHtml = Platform.getDebugOption((String)"org.eclipse.ui.intro/trace/printHTML")) != null && printHtml.equalsIgnoreCase("true")) {
            System.out.println(content);
        }
        return success;
    }

    public String generateXHTMLPage(AbstractIntroPage page, IIntroContentProviderSite site) {
        Document dom = page.getResolvedDocument();
        NodeList nodes = dom.getElementsByTagNameNS("*", "contentProvider");
        Node[] contentProviderElements = ModelUtil.getArray(nodes);
        this.resolveDynamicContent(page, site);
        String content = IntroContentParser.convertToString(dom);
        this.reinjectDynamicContent(dom, contentProviderElements);
        return content;
    }

    private String generateDoctype(boolean strict) {
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        if (strict) {
            writer.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\"");
            writer.println("\t\t\t\"http://www.w3.org/TR/html4/strict.dtd\">");
        } else {
            writer.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"");
            writer.println("\t\t\t\"http://www.w3.org/TR/html4/loose.dtd\">");
        }
        writer.close();
        return swriter.toString();
    }

    private Document resolveDynamicContent(AbstractIntroPage page, IIntroContentProviderSite site) {
        Document dom = page.getResolvedDocument();
        NodeList contentProviders = dom.getElementsByTagNameNS("*", "contentProvider");
        Node[] nodes = ModelUtil.getArray(contentProviders);
        int i = 0;
        while (i < nodes.length) {
            Element contentProviderElement = (Element)nodes[i];
            IntroContentProvider provider = new IntroContentProvider(contentProviderElement, page.getBundle());
            provider.setParent(page);
            IIntroXHTMLContentProvider providerClass = (IIntroXHTMLContentProvider)ContentProviderManager.getInst().getContentProvider(provider);
            if (providerClass == null) {
                providerClass = (IIntroXHTMLContentProvider)ContentProviderManager.getInst().createContentProvider(provider, site);
            }
            if (providerClass != null) {
                Properties att = new Properties();
                att.setProperty("id", provider.getId());
                Element contentDiv = ModelUtil.createElement(dom, ModelUtil.TAG_DIV, att);
                providerClass.createContent(provider.getId(), contentDiv);
                contentProviderElement.getParentNode().replaceChild(contentDiv, contentProviderElement);
            }
            ++i;
        }
        return dom;
    }

    private void reinjectDynamicContent(Document dom, Node[] contentProviderElements) {
        int i = 0;
        while (i < contentProviderElements.length) {
            Element contentProviderElement = (Element)contentProviderElements[i];
            Element contentProviderDiv = ModelUtil.getElementById(dom, contentProviderElement.getAttribute("id"), ModelUtil.TAG_DIV);
            contentProviderDiv.getParentNode().replaceChild(contentProviderElement, contentProviderDiv);
            ++i;
        }
    }

    private IntroHTMLGenerator getHTMLGenerator() {
        if (this.htmlGenerator == null) {
            this.htmlGenerator = new IntroHTMLGenerator();
        }
        return this.htmlGenerator;
    }

    protected void addToolBarActions() {
        IActionBars actionBars = this.getIntroPart().getIntroSite().getActionBars();
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        actionBars.setGlobalActionHandler(ActionFactory.FORWARD.getId(), (IAction)this.forwardAction);
        actionBars.setGlobalActionHandler(ActionFactory.BACK.getId(), (IAction)this.backAction);
        toolBarManager.add((IContributionItem)new Separator("additions"));
        toolBarManager.add((IAction)this.homeAction);
        toolBarManager.add((IAction)this.backAction);
        toolBarManager.add((IAction)this.forwardAction);
        toolBarManager.update(true);
        actionBars.updateActionBars();
        this.updateNavigationActionsState();
    }

    public void dynamicStandbyStateChanged(boolean standby, boolean isStandbyPartNeeded) {
        if (isStandbyPartNeeded) {
            return;
        }
        if (this.history.currentLocationIsUrl()) {
            return;
        }
        IntroHomePage homePage = this.getModel().getHomePage();
        IntroHomePage standbyPage = this.getModel().getStandbyPage();
        if (standbyPage == null) {
            standbyPage = homePage;
        }
        if (standby) {
            this.generateDynamicContentForPage(standbyPage);
        } else {
            if (this.getModel().getCurrentPage().equals(standbyPage.getId())) {
                this.getModel().setCurrentPageId(this.getModel().getHomePage().getId());
            }
            this.generateDynamicContentForPage(this.getModel().getCurrentPage());
        }
    }

    public void propertyChanged(Object source, int propId) {
        if (propId == 1) {
            String pageId = this.getModel().getCurrentPageId();
            if (pageId == null || pageId.equals("")) {
                return;
            }
            this.updateContent();
        }
    }

    public void setFocus() {
        this.browser.setFocus();
    }

    public void dispose() {
        this.browser.dispose();
    }

    protected void updateContent() {
        this.generateDynamicContentForPage(this.getModel().getCurrentPage());
    }

    public void reflow(IIntroContentProvider provider, boolean incremental) {
        this.updateContent();
    }

    protected void saveCurrentPage(IMemento memento) {
        if (memento == null) {
            return;
        }
        if (this.browser != null && this.browser.getUrl() != null && this.browser.getUrl().length() > 0 && !this.browser.getUrl().equals("about:blank") && !this.browser.getUrl().equals("file:///")) {
            String currentURL = this.browser.getUrl();
            if (currentURL != null) {
                memento.putString("currentPage", currentURL);
            }
        } else {
            super.saveCurrentPage(memento);
        }
    }

    public boolean navigateBackward() {
        boolean success = false;
        if (this.getModel().isDynamic()) {
            if (this.history.canNavigateBackward()) {
                this.history.navigateHistoryBackward();
                this.urlListener.flagStartOfNavigation();
                if (this.history.currentLocationIsUrl()) {
                    success = this.browser.setUrl(this.history.getCurrentLocationAsUrl());
                } else {
                    AbstractIntroPage page = this.history.getCurrentLocationAsPage();
                    success = this.generateDynamicContentForPage(page);
                    this.getModel().setCurrentPageId(page.getId(), false);
                }
            } else {
                success = false;
            }
            this.updateNavigationActionsState();
        } else {
            success = this.browser.back();
        }
        return success;
    }

    public boolean navigateForward() {
        boolean success = false;
        if (this.getModel().isDynamic()) {
            if (this.history.canNavigateForward()) {
                this.history.navigateHistoryForward();
                this.urlListener.flagStartOfNavigation();
                if (this.history.currentLocationIsUrl()) {
                    success = this.browser.setUrl(this.history.getCurrentLocationAsUrl());
                } else {
                    AbstractIntroPage page = this.history.getCurrentLocationAsPage();
                    success = this.generateDynamicContentForPage(page);
                    this.getModel().setCurrentPageId(page.getId(), false);
                }
            } else {
                success = false;
            }
            this.updateNavigationActionsState();
        } else {
            success = this.browser.forward();
        }
        return success;
    }

    public boolean navigateHome() {
        IntroHomePage rootPage = this.getModel().getHomePage();
        boolean success = false;
        if (this.getModel().isDynamic()) {
            if (this.history.currentLocationIsUrl()) {
                this.generateDynamicContentForPage(rootPage);
            }
            success = this.getModel().setCurrentPageId(rootPage.getId());
            this.updateHistory(rootPage);
        } else {
            String location = rootPage.getUrl();
            success = this.browser.setUrl(location);
            this.updateHistory(location);
        }
        return success;
    }

    protected void handleRegistryChanged(IRegistryChangeEvent event) {
        if (this.getModel().isDynamic()) {
            this.htmlGenerator = null;
            this.getModel().addPropertyListener(this);
            this.getModel().firePropertyChange(1);
        }
    }

    protected void doStandbyStateChanged(boolean standby, boolean isStandbyPartNeeded) {
        if (isStandbyPartNeeded | standby) {
            this.homeAction.setEnabled(false);
            this.forwardAction.setEnabled(false);
            this.backAction.setEnabled(false);
        } else {
            this.homeAction.setEnabled(true);
            this.updateNavigationActionsState();
        }
        if (this.getModel().isDynamic()) {
            this.dynamicStandbyStateChanged(standby, isStandbyPartNeeded);
        } else {
            this.staticStandbyStateChanged(standby);
        }
    }

    private void handleStaticIntro() {
        String url = this.getCachedCurrentPage();
        if (!History.isURL(url)) {
            url = this.getModel().getHomePage().getUrl();
        }
        if (url == null) {
            Log.error("Url is null; no content to display in browser", null);
            return;
        }
        boolean success = this.browser.setUrl(url);
        if (!success) {
            Log.error("Unable to set the following ULR in browser: " + url, null);
            return;
        }
    }

    public void staticStandbyStateChanged(boolean standby) {
        IntroHomePage homePage = this.getModel().getHomePage();
        IntroHomePage standbyPage = this.getModel().getStandbyPage();
        if (standbyPage == null) {
            standbyPage = homePage;
        }
        if (standby) {
            this.browser.setUrl(standbyPage.getUrl());
        } else {
            this.browser.setUrl(homePage.getUrl());
        }
    }

    public Browser getBrowser() {
        return this.browser;
    }
}

