/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.elements.adapters.AsynchronousDebugLabelAdapter;
import org.eclipse.debug.internal.ui.viewers.AsynchronousRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.AsynchronousViewer;
import org.eclipse.debug.internal.ui.viewers.ChildrenRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.LabelRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.ModelNode;
import org.eclipse.debug.internal.ui.viewers.provisional.AsynchronousContentAdapter;
import org.eclipse.debug.internal.ui.viewers.provisional.IAsynchronousContentAdapter;
import org.eclipse.debug.internal.ui.viewers.provisional.IAsynchronousLabelAdapter;
import org.eclipse.debug.internal.ui.viewers.provisional.IAsynchronousRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.provisional.IModelProxyFactoryAdapter;
import org.eclipse.debug.internal.ui.viewers.provisional.IPresentationContext;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;

public abstract class AsynchronousModel {
    private ModelNode fRoot;
    private Map fElementToNodes = new HashMap();
    private Map fModelProxies = new HashMap();
    private AsynchronousViewer fViewer;
    private boolean fDisposed = false;
    public static boolean DEBUG_MODEL = false;
    protected IAsynchronousContentAdapter fEmptyContentAdapter = new EmptyContentAdapter();
    private List fPendingUpdates = new ArrayList();
    private List fViewerUpdates = new ArrayList();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        DEBUG_MODEL = DebugUIPlugin.DEBUG && "true".equals(Platform.getDebugOption((String)"org.eclipse.debug.ui/debug/viewers/model"));
    }

    public AsynchronousModel(AsynchronousViewer viewer) {
        this.fViewer = viewer;
        if (DEBUG_MODEL) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("MODEL CREATED for: ");
            buffer.append((Object)this.fViewer);
            buffer.append(" (");
            buffer.append(this);
            buffer.append(")");
            DebugUIPlugin.debug(buffer.toString());
        }
    }

    public void init(Object root) {
        if (root != null) {
            this.fRoot = new ModelNode(null, root);
            this.mapElement(root, this.fRoot);
        }
    }

    protected AsynchronousViewer getViewer() {
        return this.fViewer;
    }

    public synchronized void dispose() {
        if (DEBUG_MODEL) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("MODEL DISPOSED for: ");
            buffer.append((Object)this.fViewer);
            buffer.append(" (");
            buffer.append(this);
            buffer.append(")");
            DebugUIPlugin.debug(buffer.toString());
        }
        this.fDisposed = true;
        this.cancelPendingUpdates();
        this.disposeAllModelProxies();
        ModelNode rootNode = this.getRootNode();
        if (rootNode != null) {
            rootNode.dispose();
        }
        this.fElementToNodes.clear();
    }

    public synchronized boolean isDisposed() {
        return this.fDisposed;
    }

    protected synchronized void cancelPendingUpdates() {
        Iterator updates = this.fPendingUpdates.iterator();
        while (updates.hasNext()) {
            IAsynchronousRequestMonitor update = (IAsynchronousRequestMonitor)updates.next();
            updates.remove();
            update.setCanceled(true);
        }
        this.fPendingUpdates.clear();
    }

    public synchronized void installModelProxy(Object element) {
        IModelProxy proxy;
        IModelProxyFactoryAdapter modelProxyFactory;
        if (!this.fModelProxies.containsKey(element) && (modelProxyFactory = this.getModelProxyFactoryAdapter(element)) != null && (proxy = modelProxyFactory.createModelProxy(element, this.getPresentationContext())) != null) {
            this.fModelProxies.put(element, proxy);
            Job job = new Job("Model Proxy installed notification job"){

                protected IStatus run(IProgressMonitor monitor) {
                    if (!monitor.isCanceled()) {
                        proxy.init(AsynchronousModel.this.getPresentationContext());
                        AsynchronousModel.this.getViewer().modelProxyAdded(proxy);
                        proxy.installed();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    protected synchronized void disposeModelProxy(Object element) {
        IModelProxy proxy = (IModelProxy)this.fModelProxies.remove(element);
        if (proxy != null) {
            this.getViewer().modelProxyRemoved(proxy);
            proxy.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeAllModelProxies() {
        Map map = this.fModelProxies;
        synchronized (map) {
            Iterator updatePolicies = this.fModelProxies.values().iterator();
            while (updatePolicies.hasNext()) {
                IModelProxy proxy = (IModelProxy)updatePolicies.next();
                this.getViewer().modelProxyRemoved(proxy);
                proxy.dispose();
            }
            this.fModelProxies.clear();
        }
    }

    protected IPresentationContext getPresentationContext() {
        return this.fViewer.getPresentationContext();
    }

    protected IModelProxyFactoryAdapter getModelProxyFactoryAdapter(Object element) {
        IModelProxyFactoryAdapter adapter = null;
        if (element instanceof IModelProxyFactoryAdapter) {
            adapter = (IModelProxyFactoryAdapter)element;
        } else if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.internal.ui.viewers.provisional.IModelProxyFactoryAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            adapter = (IModelProxyFactoryAdapter)adaptable.getAdapter((Class)clazz);
        }
        return adapter;
    }

    protected synchronized void mapElement(Object element, ModelNode node) {
        ModelNode[] nodes = this.getNodes(element);
        node.remap(element);
        if (nodes == null) {
            this.fElementToNodes.put(element, new ModelNode[]{node});
        } else {
            int i = 0;
            while (i < nodes.length) {
                if (nodes[i] == node) {
                    return;
                }
                ++i;
            }
            ModelNode[] old = nodes;
            ModelNode[] newNodes = new ModelNode[old.length + 1];
            System.arraycopy(old, 0, newNodes, 0, old.length);
            newNodes[old.length] = node;
            this.fElementToNodes.put(element, newNodes);
        }
        this.installModelProxy(element);
    }

    protected synchronized void unmapNode(ModelNode node) {
        Object element = node.getElement();
        ModelNode[] nodes = (ModelNode[])this.fElementToNodes.get(element);
        if (nodes == null) {
            return;
        }
        if (nodes.length == 1) {
            this.fElementToNodes.remove(element);
            this.disposeModelProxy(element);
        } else {
            int i = 0;
            while (i < nodes.length) {
                ModelNode node2 = nodes[i];
                if (node2 == node) {
                    ModelNode[] newNodes = new ModelNode[nodes.length - 1];
                    System.arraycopy(nodes, 0, newNodes, 0, i);
                    if (i < newNodes.length) {
                        System.arraycopy(nodes, i + 1, newNodes, i, newNodes.length - i);
                    }
                    this.fElementToNodes.put(element, newNodes);
                }
                ++i;
            }
        }
    }

    public synchronized ModelNode[] getNodes(Object element) {
        return (ModelNode[])this.fElementToNodes.get(element);
    }

    public ModelNode getRootNode() {
        return this.fRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestScheduled(IAsynchronousRequestMonitor update) {
        AsynchronousRequestMonitor absUpdate = (AsynchronousRequestMonitor)update;
        List list = this.fPendingUpdates;
        synchronized (list) {
            ListIterator updates = this.fPendingUpdates.listIterator();
            while (updates.hasNext()) {
                AsynchronousRequestMonitor pendingUpdate = (AsynchronousRequestMonitor)updates.next();
                if (!absUpdate.contains(pendingUpdate)) continue;
                updates.remove();
                pendingUpdate.setCanceled(true);
            }
            this.fPendingUpdates.add(update);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestComplete(IAsynchronousRequestMonitor update) {
        List list = this.fPendingUpdates;
        synchronized (list) {
            this.fPendingUpdates.remove(update);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void viewerUpdateScheduled(IAsynchronousRequestMonitor update) {
        List list = this.fPendingUpdates;
        synchronized (list) {
            this.fViewerUpdates.add(update);
        }
    }

    protected Object[] filter(Object parent, Object[] elements) {
        ViewerFilter[] filters = this.getViewer().getFilters();
        if (filters != null) {
            ArrayList<Object> filtered = new ArrayList<Object>(elements.length);
            int i = 0;
            while (i < elements.length) {
                boolean add = true;
                int j = 0;
                while (j < filters.length) {
                    add = filters[j].select((Viewer)this.getViewer(), parent, elements[i]);
                    if (!add) break;
                    ++j;
                }
                if (add) {
                    filtered.add(elements[i]);
                }
                ++i;
            }
            return filtered.toArray();
        }
        return elements;
    }

    protected void updateLabel(ModelNode node) {
        Object element = node.getElement();
        IAsynchronousLabelAdapter adapter = this.getLabelAdapter(element);
        if (adapter != null) {
            LabelRequestMonitor labelUpdate = new LabelRequestMonitor(node, this);
            this.requestScheduled(labelUpdate);
            adapter.retrieveLabel(element, this.getPresentationContext(), labelUpdate);
        }
    }

    protected IAsynchronousLabelAdapter getLabelAdapter(Object element) {
        IAsynchronousLabelAdapter adapter = null;
        if (element instanceof IAsynchronousLabelAdapter) {
            adapter = (IAsynchronousLabelAdapter)element;
        } else if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.debug.internal.ui.viewers.provisional.IAsynchronousLabelAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            adapter = (IAsynchronousLabelAdapter)adaptable.getAdapter((Class)clazz);
        }
        if (adapter == null) {
            return new AsynchronousDebugLabelAdapter();
        }
        return adapter;
    }

    protected IAsynchronousContentAdapter getContentAdapter(Object element) {
        IAsynchronousContentAdapter adapter = null;
        if (element instanceof IAsynchronousContentAdapter) {
            adapter = (IAsynchronousContentAdapter)element;
        } else if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.debug.internal.ui.viewers.provisional.IAsynchronousContentAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            adapter = (IAsynchronousContentAdapter)adaptable.getAdapter((Class)clazz);
        }
        return adapter;
    }

    public void updateChildren(ModelNode parent) {
        Object element = parent.getElement();
        IAsynchronousContentAdapter adapter = this.getContentAdapter(element);
        if (adapter == null) {
            adapter = this.fEmptyContentAdapter;
        }
        if (adapter != null) {
            ChildrenRequestMonitor update = new ChildrenRequestMonitor(parent, this);
            this.requestScheduled(update);
            adapter.retrieveChildren(element, this.getPresentationContext(), update);
        }
    }

    protected void preservingSelection(Runnable update) {
        this.getViewer().preservingSelection(update);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void viewerUpdateComplete(IAsynchronousRequestMonitor monitor) {
        List list = this.fPendingUpdates;
        synchronized (list) {
            this.fViewerUpdates.remove(monitor);
        }
        this.getViewer().updateComplete(monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestCanceled(AsynchronousRequestMonitor monitor) {
        List list = this.fPendingUpdates;
        synchronized (list) {
            this.fPendingUpdates.remove(monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasPendingUpdates() {
        List list = this.fViewerUpdates;
        synchronized (list) {
            return !this.fPendingUpdates.isEmpty() || !this.fViewerUpdates.isEmpty();
        }
    }

    protected abstract void add(ModelNode var1, Object var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setChildren(final ModelNode parentNode, List kids) {
        Object[] children = this.filter(parentNode.getElement(), kids.toArray());
        final AsynchronousViewer viewer = this.getViewer();
        ViewerSorter sorter = viewer.getSorter();
        if (sorter != null) {
            sorter.sort((Viewer)viewer, children);
        }
        ModelNode[] prevKids = null;
        ModelNode[] newChildren = null;
        ModelNode[] unmap = null;
        AsynchronousModel asynchronousModel = this;
        synchronized (asynchronousModel) {
            if (this.isDisposed()) {
                return;
            }
            prevKids = parentNode.getChildrenNodes();
            if (prevKids == null) {
                newChildren = new ModelNode[children.length];
                int i = 0;
                while (i < children.length) {
                    ModelNode node = new ModelNode(parentNode, children[i]);
                    this.mapElement(children[i], node);
                    newChildren[i] = node;
                    ++i;
                }
                parentNode.setChildren(newChildren);
            } else {
                newChildren = new ModelNode[children.length];
                unmap = new ModelNode[prevKids.length];
                int i = 0;
                while (i < prevKids.length) {
                    unmap[i] = prevKids[i];
                    ++i;
                }
                i = 0;
                while (i < children.length) {
                    Object child = children[i];
                    boolean found = false;
                    int j = 0;
                    while (j < prevKids.length) {
                        ModelNode prevKid = prevKids[j];
                        if (prevKid != null && child.equals(prevKid.getElement())) {
                            newChildren[i] = prevKid;
                            prevKids[j] = null;
                            found = true;
                            break;
                        }
                        ++j;
                    }
                    if (!found) {
                        newChildren[i] = new ModelNode(parentNode, child);
                        this.mapElement(child, newChildren[i]);
                    }
                    ++i;
                }
                i = 0;
                while (i < prevKids.length) {
                    ModelNode kid = prevKids[i];
                    if (kid != null) {
                        kid.dispose();
                        this.unmapNode(kid);
                    }
                    ++i;
                }
                parentNode.setChildren(newChildren);
            }
            if (DEBUG_MODEL) {
                DebugUIPlugin.debug("CHILDREN CHANGED: " + parentNode);
                DebugUIPlugin.debug(this.toString());
            }
        }
        final ModelNode[] finalUnmap = unmap;
        this.preservingSelection(new Runnable(){

            public void run() {
                if (finalUnmap != null) {
                    int i = 0;
                    while (i < finalUnmap.length) {
                        viewer.unmapNode(finalUnmap[i]);
                        ++i;
                    }
                }
                viewer.nodeChildrenChanged(parentNode);
            }
        });
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.fRoot != null) {
            buf.append("ROOT: ");
            this.append(buf, this.fRoot, 0);
        } else {
            buf.append("ROOT: null");
        }
        return buf.toString();
    }

    private void append(StringBuffer buf, ModelNode node, int level) {
        int i = 0;
        while (i < level) {
            buf.append('\t');
            ++i;
        }
        buf.append(node);
        buf.append('\n');
        ModelNode[] childrenNodes = node.getChildrenNodes();
        if (childrenNodes != null) {
            int i2 = 0;
            while (i2 < childrenNodes.length) {
                this.append(buf, childrenNodes[i2], level + 1);
                ++i2;
            }
        }
    }

    class EmptyContentAdapter
    extends AsynchronousContentAdapter {
        EmptyContentAdapter() {
        }

        protected Object[] getChildren(Object parent, IPresentationContext context) throws CoreException {
            return EMPTY;
        }

        protected boolean hasChildren(Object element, IPresentationContext context) throws CoreException {
            return false;
        }

        protected boolean supportsPartId(String id) {
            return true;
        }
    }
}

