/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.debug.internal.ui.actions.context.AbstractRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.AsynchronousModel;
import org.eclipse.debug.internal.ui.viewers.AsynchronousSchedulingRuleFactory;
import org.eclipse.debug.internal.ui.viewers.ModelNode;
import org.eclipse.ui.progress.WorkbenchJob;

public abstract class AsynchronousRequestMonitor
extends AbstractRequestMonitor {
    private ModelNode fNode;
    private AsynchronousModel fModel;
    private boolean fDone = false;
    protected WorkbenchJob fViewerUpdateJob = new WorkbenchJob("Asynchronous viewer update"){

        public IStatus runInUIThread(IProgressMonitor monitor) {
            AsynchronousRequestMonitor.this.getModel().viewerUpdateScheduled(AsynchronousRequestMonitor.this);
            if (AsynchronousRequestMonitor.this.fDone) {
                AsynchronousRequestMonitor.this.getModel().requestComplete(AsynchronousRequestMonitor.this);
            }
            if (!AsynchronousRequestMonitor.this.isCanceled() && !AsynchronousRequestMonitor.this.getNode().isDisposed()) {
                IStatus status = AsynchronousRequestMonitor.this.getStatus();
                if (status != null && !status.isOK()) {
                    AsynchronousRequestMonitor.this.getModel().getViewer().handlePresentationFailure(AsynchronousRequestMonitor.this, status);
                } else {
                    AsynchronousRequestMonitor.this.performUpdate();
                }
            }
            AsynchronousRequestMonitor.this.getModel().viewerUpdateComplete(AsynchronousRequestMonitor.this);
            return Status.OK_STATUS;
        }
    };

    public AsynchronousRequestMonitor(ModelNode node, AsynchronousModel model) {
        this.fNode = node;
        this.fModel = model;
        this.fViewerUpdateJob.setRule(this.getUpdateSchedulingRule());
        this.fViewerUpdateJob.setSystem(true);
    }

    protected ISchedulingRule getUpdateSchedulingRule() {
        return AsynchronousSchedulingRuleFactory.getDefault().newSerialPerObjectRule((Object)this.getModel().getViewer());
    }

    protected AsynchronousModel getModel() {
        return this.fModel;
    }

    protected ModelNode getNode() {
        return this.fNode;
    }

    protected boolean contains(ModelNode node) {
        if (node == this.getNode()) {
            return true;
        }
        ModelNode parentNode = this.getNode().getParentNode();
        while (parentNode != null) {
            if (parentNode.equals(this.getNode())) {
                return true;
            }
            parentNode = parentNode.getParentNode();
        }
        return false;
    }

    public void setCanceled(boolean value) {
        super.setCanceled(value);
        if (value) {
            this.getModel().requestCanceled(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void done() {
        AsynchronousRequestMonitor asynchronousRequestMonitor = this;
        synchronized (asynchronousRequestMonitor) {
            this.fDone = true;
        }
        this.scheduleViewerUpdate(0L);
    }

    protected synchronized boolean isDone() {
        return this.fDone;
    }

    protected void scheduleViewerUpdate(long ms) {
        if (!this.isCanceled()) {
            this.fViewerUpdateJob.schedule(ms);
        }
    }

    protected abstract void performUpdate();

    protected abstract boolean contains(AsynchronousRequestMonitor var1);
}

