/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.browser;

import java.net.URL;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.internal.browser.ImageResource;
import org.eclipse.ui.internal.browser.Messages;
import org.eclipse.ui.internal.browser.Trace;

public class WebBrowserEditorInput
implements IEditorInput,
IPersistableElement,
IElementFactory {
    private static final String ELEMENT_FACTORY_ID = "org.eclipse.ui.browser.elementFactory";
    private static final String MEMENTO_URL = "url";
    private static final String MEMENTO_STYLE = "style";
    private static final String MEMENTO_ID = "id";
    private URL url;
    private int style;
    private String id = null;
    private String name;
    private String tooltip;

    public WebBrowserEditorInput() {
        this(null);
    }

    public WebBrowserEditorInput(URL url) {
        this(url, 0);
    }

    public WebBrowserEditorInput(URL url, int style) {
        this.url = url;
        this.style = style;
    }

    public WebBrowserEditorInput(URL url, int style, String browserId) {
        this.url = url;
        this.style = style;
        this.id = browserId;
    }

    public WebBrowserEditorInput(URL url, boolean b) {
        this(url);
    }

    public void setName(String n) {
        this.name = n;
    }

    public void setToolTipText(String t) {
        this.tooltip = t;
    }

    public boolean canReplaceInput(WebBrowserEditorInput input) {
        Trace.trace(Trace.FINEST, "canReplaceInput " + this + " " + input);
        if (input.isStatusbarVisible() != this.isStatusbarVisible()) {
            return false;
        }
        if (this.id != null) {
            String bid = input.getBrowserId();
            return this.id.equals(bid);
        }
        return false;
    }

    public IAdaptable createElement(IMemento memento) {
        URL url2 = null;
        int newStyle = 0;
        try {
            newStyle = memento.getInteger(MEMENTO_STYLE);
            if (newStyle != 0) {
                this.url = new URL(memento.getString(MEMENTO_URL));
            }
        }
        catch (Exception exception) {}
        String id2 = null;
        try {
            id2 = memento.getString(MEMENTO_ID);
            if (id2 != null && id2.length() < 1) {
                id2 = null;
            }
        }
        catch (Exception exception) {}
        return new WebBrowserEditorInput(url2, newStyle, id2);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WebBrowserEditorInput)) {
            return false;
        }
        WebBrowserEditorInput other = (WebBrowserEditorInput)obj;
        if (this.url != null && !this.url.equals(obj)) {
            return false;
        }
        return this.canReplaceInput(other);
    }

    public boolean exists() {
        return (this.style & 0x10) == 0;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public String getFactoryId() {
        return ELEMENT_FACTORY_ID;
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageResource.getImageDescriptor("internalBrowser");
    }

    protected boolean isNameLocked() {
        return this.name != null;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return Messages.viewWebBrowserTitle;
    }

    public IPersistableElement getPersistable() {
        if ((this.style & 0x10) == 0) {
            return null;
        }
        return this;
    }

    public String getToolTipText() {
        if (this.tooltip != null) {
            return this.tooltip;
        }
        if (this.url != null) {
            return this.url.toExternalForm();
        }
        return Messages.viewWebBrowserTitle;
    }

    public URL getURL() {
        return this.url;
    }

    public String getBrowserId() {
        return this.id;
    }

    public boolean isStatusbarVisible() {
        return (this.style & 8) != 0;
    }

    public boolean isLocationBarLocal() {
        return (this.style & 2) != 0;
    }

    public boolean isToolbarLocal() {
        return (this.style & 4) != 0;
    }

    public void saveState(IMemento memento) {
        if ((this.style & 0x10) != 0 && this.url != null) {
            memento.putString(MEMENTO_URL, this.url.toExternalForm());
        }
        memento.putInteger(MEMENTO_STYLE, this.style);
        if (this.id != null) {
            memento.putString(MEMENTO_ID, this.id);
        }
    }

    public String toString() {
        return "WebBrowserEditorInput[" + this.url + " " + this.style + " " + this.id + "]";
    }
}

