/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.preferences.includepath;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.php.core.project.IIncludePathContainer;
import org.eclipse.php.core.project.IIncludePathEntry;
import org.eclipse.php.ui.preferences.includepath.IPListElement;

public class IPUserLibraryElement {
    private String fName;
    private List fChildren;
    private boolean fIsSystemLibrary;

    public IPUserLibraryElement(String string, IIncludePathContainer iIncludePathContainer, IProject iProject) {
        this.fName = string;
        this.fChildren = new ArrayList();
        if (iIncludePathContainer != null) {
            IIncludePathEntry[] iIncludePathEntryArray = iIncludePathContainer.getIncludePathEntries();
            IPListElement[] iPListElementArray = new IPListElement[iIncludePathEntryArray.length];
            int n = 0;
            while (n < iPListElementArray.length) {
                IIncludePathEntry iIncludePathEntry = iIncludePathEntryArray[n];
                IPListElement iPListElement = IPListElement.createFromExisting(this, iIncludePathEntry, iProject);
                this.fChildren.add(iPListElement);
                ++n;
            }
            this.fIsSystemLibrary = iIncludePathContainer.getKind() == 2;
        } else {
            this.fIsSystemLibrary = false;
        }
    }

    public IPUserLibraryElement(String string, boolean bl, IPListElement[] iPListElementArray) {
        this.fName = string;
        this.fChildren = new ArrayList();
        if (iPListElementArray != null) {
            int n = 0;
            while (n < iPListElementArray.length) {
                this.fChildren.add(iPListElementArray[n]);
                ++n;
            }
        }
        this.fIsSystemLibrary = bl;
    }

    public IPListElement[] getChildren() {
        return this.fChildren.toArray(new IPListElement[this.fChildren.size()]);
    }

    public String getName() {
        return this.fName;
    }

    public IPath getPath() {
        return new Path("org.eclipse.php.USER_LIBRARY").append(this.fName);
    }

    public boolean isSystemLibrary() {
        return this.fIsSystemLibrary;
    }

    public void add(IPListElement iPListElement) {
        if (!this.fChildren.contains(iPListElement)) {
            this.fChildren.add(iPListElement);
        }
    }

    private List moveUp(List list, List list2) {
        int n = list.size();
        ArrayList arrayList = new ArrayList(n);
        Object e = null;
        int n2 = 0;
        while (n2 < n) {
            Object e2 = list.get(n2);
            if (list2.contains(e2)) {
                arrayList.add(e2);
            } else {
                if (e != null) {
                    arrayList.add(e);
                }
                e = e2;
            }
            ++n2;
        }
        if (e != null) {
            arrayList.add(e);
        }
        return arrayList;
    }

    public void moveUp(List list) {
        if (list.size() > 0) {
            this.fChildren = this.moveUp(this.fChildren, list);
        }
    }

    public void moveDown(List list) {
        if (list.size() > 0) {
            Collections.reverse(this.fChildren);
            this.fChildren = this.moveUp(this.fChildren, list);
            Collections.reverse(this.fChildren);
        }
    }

    public void remove(IPListElement iPListElement) {
        this.fChildren.remove(iPListElement);
    }

    public void replace(IPListElement iPListElement, IPListElement iPListElement2) {
        if (this.fChildren.contains(iPListElement2)) {
            this.fChildren.remove(iPListElement);
        } else {
            int n = this.fChildren.indexOf(iPListElement);
            if (n != -1) {
                this.fChildren.set(n, iPListElement2);
            } else {
                this.fChildren.add(iPListElement2);
            }
        }
    }

    public IIncludePathContainer getUpdatedContainer() {
        return new UpdatedIncludePathContainer();
    }

    public boolean hasChanges(IIncludePathContainer iIncludePathContainer) {
        if (iIncludePathContainer == null || iIncludePathContainer.getKind() == 2 != this.fIsSystemLibrary) {
            return true;
        }
        IIncludePathEntry[] iIncludePathEntryArray = iIncludePathContainer.getIncludePathEntries();
        if (this.fChildren.size() != iIncludePathEntryArray.length) {
            return true;
        }
        int n = 0;
        while (n < iIncludePathEntryArray.length) {
            IPListElement iPListElement = (IPListElement)this.fChildren.get(n);
            if (!iPListElement.getIncludePathEntry().equals(iIncludePathEntryArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private class UpdatedIncludePathContainer
    implements IIncludePathContainer {
        private UpdatedIncludePathContainer() {
        }

        public IIncludePathEntry[] getIncludePathEntries() {
            IPListElement[] iPListElementArray = IPUserLibraryElement.this.getChildren();
            IIncludePathEntry[] iIncludePathEntryArray = new IIncludePathEntry[iPListElementArray.length];
            int n = 0;
            while (n < iIncludePathEntryArray.length) {
                iIncludePathEntryArray[n] = iPListElementArray[n].getIncludePathEntry();
                ++n;
            }
            return iIncludePathEntryArray;
        }

        public String getDescription() {
            return IPUserLibraryElement.this.getName();
        }

        public int getKind() {
            return IPUserLibraryElement.this.isSystemLibrary() ? 2 : 1;
        }

        public IPath getPath() {
            return IPUserLibraryElement.this.getPath();
        }
    }
}

