/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.treecontent;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.php.core.phpModel.parser.PHPIncludePathModel;
import org.eclipse.php.core.phpModel.parser.PHPIncludePathModelManager;
import org.eclipse.php.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.core.phpModel.parser.PhpModelProxy;
import org.eclipse.php.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.core.project.options.IPhpProjectOptionChangeListener;
import org.eclipse.php.core.project.options.PHPProjectOptions;
import org.eclipse.php.core.project.options.includepath.IncludePathVariableManager;
import org.eclipse.php.ui.PHPUiPlugin;
import org.eclipse.php.ui.treecontent.IPHPTreeContentProvider;
import org.eclipse.php.ui.treecontent.PHPTreeNode;
import org.eclipse.php.ui.util.PHPPluginImages;
import org.eclipse.swt.graphics.Image;

public class IncludePathTreeContent
implements IPHPTreeContentProvider {
    public static final String ID_INCLUDES_NODE = "org.eclipse.php.ui.treecontent.IncludesNode";
    TreeViewer treeViewer;
    HashMap projects = new HashMap();
    ElementTree includePathTree = new ElementTree();
    static final String INCLUDE_MODEL_MANAGER_ID = "CompositeIncludePathModel";
    static final IPath INCLUDE_MODELS_PATH_ROOT = new Path("\u0000IncludePaths");

    Object[] getPathChildren(IPath iPath) {
        Object object;
        IPath iPath2 = iPath.uptoSegment(2);
        if (!this.includePathTree.includes(iPath2)) {
            return NO_CHILDREN;
        }
        Object object2 = this.includePathTree.getElementData(iPath2);
        if (!(object2 instanceof PHPIncludePathModel)) {
            return NO_CHILDREN;
        }
        PHPIncludePathModel pHPIncludePathModel = (PHPIncludePathModel)this.includePathTree.getElementData(iPath2);
        IPath iPath3 = IncludePathTreeContent.getIncludeModelLocation(pHPIncludePathModel);
        PHPFileData[] pHPFileDataArray = pHPIncludePathModel.getFileDatas();
        int n = 0;
        while (n < pHPFileDataArray.length) {
            Path path;
            IPath iPath4;
            object = pHPFileDataArray[n].getName();
            if (((String)object).startsWith(iPath3.toOSString()) && !this.includePathTree.includes(iPath4 = iPath2.append((path = new Path((String)object)).removeFirstSegments(iPath3.segmentCount())))) {
                IPath iPath5 = iPath4.removeLastSegments(1);
                while (iPath5.segmentCount() > iPath2.segmentCount() && !this.includePathTree.includes(iPath5)) {
                    iPath5 = iPath5.removeLastSegments(1);
                }
                IPath iPath6 = iPath5.append(iPath4.segment(iPath5.segmentCount()));
                while (iPath6.segmentCount() < iPath4.segmentCount()) {
                    this.includePathTree.createElement(iPath6, (Object)((Workspace)ResourcesPlugin.getWorkspace()).newResource(iPath6, 2));
                    iPath6 = iPath6.append(iPath4.segment(iPath6.segmentCount()));
                }
                this.includePathTree.createElement(iPath4, (Object)pHPFileDataArray[n]);
            }
            ++n;
        }
        IPath[] iPathArray = this.includePathTree.getChildren(iPath);
        object = new ArrayList(iPathArray.length);
        int n2 = 0;
        while (n2 < iPathArray.length) {
            ((ArrayList)object).add(this.includePathTree.getElementData(iPathArray[n2]));
            ++n2;
        }
        return ((ArrayList)object).toArray();
    }

    static IPath getIncludeModelLocation(PHPIncludePathModel pHPIncludePathModel) {
        if (pHPIncludePathModel.getType() == 2) {
            return IncludePathVariableManager.instance().getIncludePathVariable(pHPIncludePathModel.getID());
        }
        if (pHPIncludePathModel.getType() == 0) {
            Path path = new Path(pHPIncludePathModel.getID());
            return path.removeFirstSegments(path.segmentCount() - 1).setDevice("");
        }
        return new Path(pHPIncludePathModel.getID());
    }

    public Object[] getChildren(Object object) {
        if (object instanceof IProject) {
            IProject iProject = (IProject)object;
            PHPProjectOptions pHPProjectOptions = PHPProjectOptions.forProject((IProject)iProject);
            if (pHPProjectOptions != null) {
                Object[] objectArray = new Object[]{this.getTreeNode(iProject)};
                return objectArray;
            }
        } else {
            if (object instanceof PHPTreeNode && ID_INCLUDES_NODE.equals(((PHPTreeNode)object).getId())) {
                PHPTreeNode pHPTreeNode = (PHPTreeNode)object;
                PHPProjectModel pHPProjectModel = PHPWorkspaceModelManager.getInstance().getModelForProject((IProject)pHPTreeNode.getData(), true);
                PHPIncludePathModelManager pHPIncludePathModelManager = (PHPIncludePathModelManager)pHPProjectModel.getModel(INCLUDE_MODEL_MANAGER_ID);
                if (pHPIncludePathModelManager == null) {
                    return new Object[0];
                }
                return pHPIncludePathModelManager.listModels();
            }
            if (object instanceof PHPIncludePathModel) {
                IPath iPath;
                PHPIncludePathModel pHPIncludePathModel = (PHPIncludePathModel)object;
                if (!this.includePathTree.includes(INCLUDE_MODELS_PATH_ROOT)) {
                    this.includePathTree.createElement(INCLUDE_MODELS_PATH_ROOT, (Object)INCLUDE_MODELS_PATH_ROOT.segment(1));
                }
                if (!this.includePathTree.includes(iPath = INCLUDE_MODELS_PATH_ROOT.append(IncludeModelPathRootConverter.to(pHPIncludePathModel)))) {
                    this.includePathTree.createElement(iPath, (Object)pHPIncludePathModel);
                }
                return this.getPathChildren(iPath);
            }
            if (object instanceof IResource) {
                IPath iPath = ((IResource)object).getFullPath();
                if (this.includePathTree.includes(((IResource)object).getFullPath())) {
                    return this.getPathChildren(iPath);
                }
            } else if (object instanceof PhpModelProxy) {
                PhpModelProxy phpModelProxy = (PhpModelProxy)object;
                return phpModelProxy.getPHPFilesData(null);
            }
        }
        return NO_CHILDREN;
    }

    IncludesNode getTreeNode(IProject iProject) {
        Object[] objectArray;
        IncludesNode includesNode = (IncludesNode)this.projects.get(iProject);
        if (includesNode == null) {
            objectArray = PHPUiPlugin.getImageDescriptorRegistry().get(PHPPluginImages.DESC_OBJS_LIBRARY);
            includesNode = new IncludesNode("Include Paths", (Image)objectArray, ID_INCLUDES_NODE, iProject, null);
            this.projects.put(iProject, includesNode);
            PHPProjectOptions pHPProjectOptions = PHPProjectOptions.forProject((IProject)iProject);
            pHPProjectOptions.addOptionChangeListener("org.eclipse.php.core.includePath", (IPhpProjectOptionChangeListener)includesNode);
        }
        if ((objectArray = this.getChildren(includesNode)).length > 0) {
            int n = 0;
            while (n < objectArray.length) {
                this.getChildren(objectArray[n]);
                ++n;
            }
        }
        return includesNode;
    }

    public Object getParent(Object object) {
        block9: {
            IPath iPath;
            block10: {
                block8: {
                    if (this.includePathTree == null) {
                        return null;
                    }
                    if (!(object instanceof PHPFileData)) break block8;
                    PHPFileData pHPFileData = (PHPFileData)object;
                    String string = pHPFileData.getName();
                    Path path = new Path(string);
                    if (!this.includePathTree.includes(INCLUDE_MODELS_PATH_ROOT)) {
                        return null;
                    }
                    IPath[] iPathArray = this.includePathTree.getChildren(INCLUDE_MODELS_PATH_ROOT);
                    int n = 0;
                    while (n < iPathArray.length) {
                        IPath iPath2;
                        IPath iPath3 = IncludePathTreeContent.getIncludeModelLocation((PHPIncludePathModel)this.includePathTree.getElementData(iPathArray[n]));
                        if (string.startsWith(iPath3.toOSString()) && this.includePathTree.includes(iPath2 = iPathArray[n].append(path.removeFirstSegments(iPath3.segmentCount())))) {
                            IPath iPath4 = iPath2.removeLastSegments(1);
                            return this.includePathTree.getElementData(iPath4);
                        }
                        ++n;
                    }
                    break block9;
                }
                if (!(object instanceof IFolder)) break block10;
                IFolder iFolder = (IFolder)object;
                IPath iPath5 = iFolder.getFullPath();
                if (this.includePathTree.includes(iPath5)) {
                    return this.includePathTree.getElementData(iPath5.removeLastSegments(1));
                }
                break block9;
            }
            if (!(object instanceof PHPIncludePathModel) || !this.includePathTree.includes(iPath = INCLUDE_MODELS_PATH_ROOT.append(IncludeModelPathRootConverter.to((PHPIncludePathModel)object)))) break block9;
            Iterator iterator = this.projects.values().iterator();
            while (iterator.hasNext()) {
                IncludesNode includesNode = (IncludesNode)iterator.next();
                Object[] objectArray = this.getChildren(includesNode);
                int n = 0;
                while (n < objectArray.length) {
                    if (objectArray[n] == object) {
                        return includesNode;
                    }
                    ++n;
                }
            }
        }
        return null;
    }

    public boolean hasChildren(Object object) {
        return false;
    }

    public Object[] getElements(Object object) {
        return this.getChildren(object);
    }

    public void dispose() {
        Iterator iterator = this.projects.keySet().iterator();
        while (iterator.hasNext()) {
            IProject iProject = (IProject)iterator.next();
            IncludesNode includesNode = (IncludesNode)this.projects.get(iProject);
            PHPProjectOptions pHPProjectOptions = PHPProjectOptions.forProject((IProject)iProject);
            pHPProjectOptions.removeOptionChangeListener("org.eclipse.php.core.includePath", (IPhpProjectOptionChangeListener)includesNode);
        }
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        if (viewer instanceof TreeViewer) {
            this.treeViewer = (TreeViewer)viewer;
        }
    }

    public Image getImage(Object object) {
        if (object instanceof PHPTreeNode) {
            PHPTreeNode pHPTreeNode = (PHPTreeNode)object;
            return pHPTreeNode.getImage();
        }
        return null;
    }

    public String getText(Object object) {
        if (object instanceof PHPTreeNode) {
            PHPTreeNode pHPTreeNode = (PHPTreeNode)object;
            return pHPTreeNode.getText();
        }
        if (object instanceof PHPIncludePathModel) {
            PHPIncludePathModel pHPIncludePathModel = (PHPIncludePathModel)object;
            String string = pHPIncludePathModel.getID();
            IPath iPath = IncludePathVariableManager.instance().getIncludePathVariable(pHPIncludePathModel.getID());
            if (iPath != null) {
                return String.valueOf(string) + " (" + IncludePathVariableManager.instance().getIncludePathVariable(pHPIncludePathModel.getID()).toOSString() + ")";
            }
            return string;
        }
        if (object instanceof PhpModelProxy) {
            PhpModelProxy phpModelProxy = (PhpModelProxy)object;
            return phpModelProxy.getID();
        }
        if (object instanceof PHPFileData) {
            PHPFileData pHPFileData = (PHPFileData)object;
            IPath[] iPathArray = this.includePathTree.getChildren(this.includePathTree.getRoot());
            int n = 0;
            while (n < iPathArray.length) {
                PHPIncludePathModel pHPIncludePathModel = (PHPIncludePathModel)this.includePathTree.getElementData(iPathArray[n]);
                IPath iPath = IncludePathTreeContent.getIncludeModelLocation(pHPIncludePathModel);
                if (pHPFileData.getName().startsWith(iPath.toOSString())) {
                    return new Path(pHPFileData.getName()).lastSegment();
                }
                ++n;
            }
        }
        return null;
    }

    public void addListener(ILabelProviderListener iLabelProviderListener) {
    }

    public boolean isLabelProperty(Object object, String string) {
        return false;
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
    }

    static class IncludeModelPathRootConverter {
        IncludeModelPathRootConverter() {
        }

        public static String to(PHPIncludePathModel pHPIncludePathModel) {
            return String.valueOf(pHPIncludePathModel.getID().replace('/', '?').replace(File.separatorChar, '!').replace(':', ';'));
        }

        static PHPIncludePathModel from(String string, IProject[] iProjectArray) {
            String string2 = string.replace('?', '/').replace('!', File.separatorChar).replace(';', ':');
            int n = 0;
            while (n < iProjectArray.length) {
                PHPProjectModel pHPProjectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(iProjectArray[n]);
                Assert.isNotNull((Object)pHPProjectModel);
                PHPIncludePathModelManager pHPIncludePathModelManager = (PHPIncludePathModelManager)pHPProjectModel.getModel(IncludePathTreeContent.INCLUDE_MODEL_MANAGER_ID);
                Assert.isNotNull((Object)pHPIncludePathModelManager);
                PHPIncludePathModel pHPIncludePathModel = pHPIncludePathModelManager.getModel(string2);
                if (pHPIncludePathModel != null) {
                    return pHPIncludePathModel;
                }
                ++n;
            }
            return null;
        }

        public static PHPIncludePathModel from(String string, IProject iProject) {
            return IncludeModelPathRootConverter.from(string, new IProject[]{iProject});
        }

        public static PHPIncludePathModel from(String string) {
            return IncludeModelPathRootConverter.from(string, ResourcesPlugin.getWorkspace().getRoot().getProjects());
        }
    }

    class IncludesNode
    extends PHPTreeNode
    implements IPhpProjectOptionChangeListener {
        IncludesNode(String string, Image image, String string2, Object object, Object[] objectArray) {
            super(string, image, string2, object, objectArray);
        }

        public void notifyOptionChanged(Object object, Object object2) {
            IncludePathTreeContent.this.treeViewer.getControl().getDisplay().asyncExec(new Runnable(this){
                final /* synthetic */ IncludesNode this$1;
                {
                    this.this$1 = includesNode;
                }

                public void run() {
                    IncludesNode.access$0((IncludesNode)this.this$1).treeViewer.refresh((Object)this.this$1);
                }
            });
        }

        static /* synthetic */ IncludePathTreeContent access$0(IncludesNode includesNode) {
            return includesNode.IncludePathTreeContent.this;
        }
    }
}

