/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.wizard.page;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.ServerWorkingCopy;
import org.eclipse.wst.server.core.util.SocketUtil;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ProgressUtil;
import org.eclipse.wst.server.ui.internal.SWTUtil;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.viewers.ServerTypeComposite;
import org.eclipse.wst.server.ui.internal.wizard.page.ElementCreationCache;

public class NewManualServerComposite
extends Composite {
    protected IWizardHandle2 wizard;
    protected ServerTypeComposite serverTypeComposite;
    protected Label runtimeLabel;
    protected Combo runtimeCombo;
    protected Button runtimeButton;
    protected IRuntime[] runtimes;
    protected IRuntime newRuntime;
    protected IRuntime runtime;
    protected IServerWorkingCopy server;
    protected ServerSelectionListener listener;
    protected String host;
    protected IModuleType moduleType;
    protected ElementCreationCache cache = new ElementCreationCache();

    public NewManualServerComposite(Composite parent, IWizardHandle2 wizard, IModuleType moduleType, ServerSelectionListener listener) {
        super(parent, 0);
        this.wizard = wizard;
        this.listener = listener;
        this.moduleType = moduleType;
        this.createControl();
        wizard.setMessage("", 3);
    }

    protected void createControl() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.horizontalSpacing = SWTUtil.convertHorizontalDLUsToPixels(this, 4);
        layout.verticalSpacing = SWTUtil.convertVerticalDLUsToPixels(this, 4);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.setFont(this.getParent().getFont());
        IWorkbenchHelpSystem whs = PlatformUI.getWorkbench().getHelpSystem();
        whs.setHelp((Control)this, "org.eclipse.wst.server.ui.swns0000");
        this.serverTypeComposite = new ServerTypeComposite(this, 0, this.moduleType, new ServerTypeComposite.ServerTypeSelectionListener(){

            public void serverTypeSelected(IServerType type2) {
                NewManualServerComposite.this.handleTypeSelection(type2);
            }
        });
        this.serverTypeComposite.setIncludeIncompatibleVersions(true);
        GridData data = new GridData(1808);
        data.horizontalSpan = 3;
        this.serverTypeComposite.setLayoutData(data);
        whs.setHelp((Control)this.serverTypeComposite, "org.eclipse.wst.server.ui.swns0006");
        this.runtimeLabel = new Label((Composite)this, 0);
        this.runtimeLabel.setText(Messages.wizNewServerRuntime);
        this.runtimeCombo = new Combo((Composite)this, 8);
        this.runtimeCombo.setLayoutData((Object)new GridData(768));
        this.runtimeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    NewManualServerComposite.this.setRuntime(NewManualServerComposite.this.runtimes[NewManualServerComposite.this.runtimeCombo.getSelectionIndex()]);
                }
                catch (Exception exception) {}
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.runtimeButton = SWTUtil.createButton(this, Messages.installedRuntimes);
        this.runtimeButton.setLayoutData((Object)new GridData(128));
        this.runtimeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NewManualServerComposite.this.showPreferencePage()) {
                    NewManualServerComposite.this.runtime = null;
                    IServerType serverType = NewManualServerComposite.this.serverTypeComposite.getSelectedServerType();
                    NewManualServerComposite.this.updateRuntimeCombo(serverType);
                }
            }
        });
        Dialog.applyDialogFont((Control)this);
    }

    protected boolean showPreferencePage() {
        String id = "org.eclipse.wst.server.ui.preferencePage";
        String id2 = "org.eclipse.wst.server.ui.runtime.preferencePage";
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)id2, (String[])new String[]{id, id2}, null);
        return dialog.open() == 0;
    }

    public void setHost(String host) {
        this.host = host;
        if (this.serverTypeComposite == null) {
            return;
        }
        boolean changed = false;
        changed = host == null ? this.serverTypeComposite.setHost(true) : (SocketUtil.isLocalhost((String)host) ? this.serverTypeComposite.setHost(true) : this.serverTypeComposite.setHost(false));
        if (changed) {
            this.handleTypeSelection(this.serverTypeComposite.getSelectedServerType());
        } else if (this.server != null) {
            this.server.setHost(host);
            ServerUtil.setServerDefaultName((IServerWorkingCopy)this.server);
        }
    }

    protected void loadServerImpl(final IServerType serverType) {
        this.server = null;
        if (serverType == null) {
            return;
        }
        final boolean isLocalhost = SocketUtil.isLocalhost((String)this.host);
        this.server = this.cache.getCachedServer(serverType, isLocalhost);
        if (this.server != null) {
            this.server.setHost(this.host);
            ServerUtil.setServerDefaultName((IServerWorkingCopy)this.server);
            this.runtime = this.server.getRuntime();
            this.listener.runtimeSelected(this.runtime);
            return;
        }
        final CoreException[] ce = new CoreException[1];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) {
                try {
                    try {
                        monitor = ProgressUtil.getMonitorFor(monitor);
                        int ticks = 200;
                        monitor.beginTask(NLS.bind((String)Messages.loadingTask, (Object)serverType.getName()), ticks);
                        NewManualServerComposite.this.server = NewManualServerComposite.this.cache.getServer(serverType, isLocalhost, ProgressUtil.getSubMonitorFor(monitor, 200));
                        if (NewManualServerComposite.this.server != null) {
                            NewManualServerComposite.this.server.setHost(NewManualServerComposite.this.host);
                            ServerUtil.setServerDefaultName((IServerWorkingCopy)NewManualServerComposite.this.server);
                            if (serverType.hasRuntime() && NewManualServerComposite.this.server.getRuntime() == null) {
                                NewManualServerComposite.this.runtime = null;
                                NewManualServerComposite.this.updateRuntimes(serverType);
                                NewManualServerComposite.this.setRuntime(NewManualServerComposite.this.getDefaultRuntime());
                                if (NewManualServerComposite.this.server.getServerType().hasServerConfiguration() && !NewManualServerComposite.this.runtime.getLocation().isEmpty()) {
                                    ((ServerWorkingCopy)NewManualServerComposite.this.server).importRuntimeConfiguration(NewManualServerComposite.this.runtime, null);
                                }
                            }
                            ((ServerWorkingCopy)NewManualServerComposite.this.server).setDefaults(monitor);
                        }
                    }
                    catch (CoreException cex) {
                        ce[0] = cex;
                        NewManualServerComposite.this.cache.clearCachedServer(serverType, isLocalhost);
                    }
                    catch (Throwable t) {
                        Trace.trace(Trace.SEVERE, "Error creating element", t);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_6 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_7 = null;
                }
                monitor.done();
            }
        };
        try {
            this.wizard.run(true, false, runnable);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error with runnable", e);
        }
        if (ce[0] != null) {
            this.server = null;
            this.runtime = null;
            this.wizard.setMessage(ce[0].getLocalizedMessage(), 3);
        } else if (this.server == null) {
            this.wizard.setMessage(Messages.wizErrorServerCreationError, 3);
        }
    }

    protected IRuntime getDefaultRuntime() {
        if (this.runtimes == null || this.runtimes.length == 0) {
            return null;
        }
        if (this.runtimes != null) {
            int size = this.runtimes.length;
            int i = 0;
            while (i < size) {
                if (!this.runtimes[i].isStub()) {
                    return this.runtimes[i];
                }
                ++i;
            }
        }
        return this.runtimes[0];
    }

    protected void updateRuntimes(IServerType serverType) {
        if (serverType == null) {
            return;
        }
        IRuntimeType runtimeType = serverType.getRuntimeType();
        this.runtimes = ServerUIPlugin.getRuntimes(runtimeType);
        this.newRuntime = null;
        if (this.server != null && this.runtimes != null) {
            ArrayList<IRuntime> runtimes2 = new ArrayList<IRuntime>();
            int size = this.runtimes.length;
            int i = 0;
            while (i < size) {
                IRuntime runtime2 = this.runtimes[i];
                if (!SocketUtil.isLocalhost((String)this.server.getHost()) || !runtime2.isStub()) {
                    runtimes2.add(runtime2);
                }
                ++i;
            }
            this.runtimes = new IRuntime[runtimes2.size()];
            runtimes2.toArray(this.runtimes);
            if (this.runtimes.length > 0) {
                return;
            }
        }
        try {
            IRuntimeWorkingCopy runtimeWC = runtimeType.createRuntime(null, null);
            ServerUtil.setRuntimeDefaultName((IRuntimeWorkingCopy)runtimeWC);
            this.runtimes = new IRuntime[1];
            this.runtimes[0] = runtimeWC;
            this.newRuntime = runtimeWC;
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Couldn't create runtime", e);
        }
    }

    protected void updateRuntimeCombo(IServerType serverType) {
        if (serverType == null || !serverType.hasRuntime() || this.server == null) {
            if (this.runtimeLabel != null) {
                this.runtimeLabel.setEnabled(false);
                this.runtimeCombo.setItems(new String[0]);
                this.runtimeCombo.setEnabled(false);
                this.runtimeLabel.setVisible(false);
                this.runtimeCombo.setVisible(false);
                this.runtimeButton.setEnabled(false);
                this.runtimeButton.setVisible(false);
            }
            this.runtimes = new IRuntime[0];
            this.setRuntime(null);
            return;
        }
        this.updateRuntimes(serverType);
        int size = this.runtimes.length;
        String[] items = new String[size];
        int i = 0;
        while (i < size) {
            items[i] = this.runtimes[i].equals(this.newRuntime) ? Messages.wizNewServerRuntimeCreate : this.runtimes[i].getName();
            ++i;
        }
        if (this.runtime == null) {
            this.setRuntime(this.getDefaultRuntime());
        }
        if (this.runtimeCombo != null) {
            IRuntimeType runtimeType;
            this.runtimeCombo.setItems(items);
            if (this.runtimes.length > 0) {
                int sel = -1;
                int i2 = 0;
                while (i2 < size) {
                    if (this.runtimes[i2].equals(this.runtime)) {
                        sel = i2;
                    }
                    ++i2;
                }
                if (sel < 0) {
                    sel = 0;
                    this.setRuntime(this.runtimes[0]);
                }
                this.runtimeCombo.select(sel);
            }
            boolean showRuntime = ServerUIPlugin.getRuntimes(runtimeType = serverType.getRuntimeType()).length >= 1;
            this.runtimeCombo.setEnabled(showRuntime);
            this.runtimeLabel.setEnabled(showRuntime);
            this.runtimeButton.setEnabled(showRuntime);
            this.runtimeLabel.setVisible(showRuntime);
            this.runtimeCombo.setVisible(showRuntime);
            this.runtimeButton.setVisible(showRuntime);
        }
    }

    protected void setRuntime(IRuntime runtime2) {
        this.runtime = runtime2;
        if (this.server != null) {
            this.server.setRuntime(this.runtime);
        }
        this.listener.runtimeSelected(this.runtime);
    }

    protected void handleTypeSelection(IServerType serverType) {
        IRuntimeType runtimeType;
        boolean wrong = false;
        if (serverType != null && this.moduleType != null && !ServerUtil.isSupportedModule((IModuleType[])(runtimeType = serverType.getRuntimeType()).getModuleTypes(), (IModuleType)this.moduleType)) {
            serverType = null;
            wrong = true;
        }
        if (wrong) {
            this.server = null;
            this.runtime = null;
            this.wizard.setMessage(NLS.bind((String)Messages.errorVersionLevel, (Object[])new Object[]{this.moduleType.getName(), this.moduleType.getVersion()}), 3);
        } else if (serverType == null) {
            this.server = null;
            this.runtime = null;
            this.wizard.setMessage("", 3);
        } else {
            this.wizard.setMessage(null, 0);
            this.loadServerImpl(serverType);
        }
        this.updateRuntimeCombo(serverType);
        this.listener.serverSelected((IServerAttributes)this.server);
        this.wizard.update();
    }

    public void setVisible(boolean visible) {
        Control[] c;
        super.setVisible(visible);
        if (visible) {
            this.handleTypeSelection(null);
        }
        if ((c = this.getChildren()) != null) {
            int size = c.length;
            int i = 0;
            while (i < size) {
                if (c[i] != null && c[i] instanceof ServerTypeComposite) {
                    c[i].setVisible(visible);
                }
                ++i;
            }
        }
        if (visible) {
            this.handleTypeSelection(this.serverTypeComposite.getSelectedServerType());
        }
    }

    public void refresh() {
        this.serverTypeComposite.refresh();
    }

    public IRuntime getRuntime() {
        return this.runtime;
    }

    public IServerWorkingCopy getServer() {
        return this.server;
    }

    public static interface IWizardHandle2 {
        public void run(boolean var1, boolean var2, IRunnableWithProgress var3) throws InterruptedException, InvocationTargetException;

        public void update();

        public void setMessage(String var1, int var2);
    }

    public static interface ServerSelectionListener {
        public void serverSelected(IServerAttributes var1);

        public void runtimeSelected(IRuntime var1);
    }
}

