/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.context;

import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IInternalDebugUIConstants;
import org.eclipse.debug.internal.ui.actions.context.AbstractDebugContextActionDelegate;
import org.eclipse.debug.internal.ui.actions.context.ToggleStepFiltersAction;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class ToggleStepFiltersActionDelegate
extends AbstractDebugContextActionDelegate
implements IPropertyChangeListener,
IViewActionDelegate {
    public ToggleStepFiltersActionDelegate() {
        this.setAction(new ToggleStepFiltersAction());
    }

    public void init(IAction action) {
        super.init(action);
        this.getWindowAction().setChecked(this.isUseStepFilters());
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    private boolean isUseStepFilters() {
        return DebugUIPlugin.getDefault().getStepFilterManager().isUseStepFilters();
    }

    private IPreferenceStore getPreferenceStore() {
        return DebugUIPlugin.getDefault().getPreferenceStore();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(IInternalDebugUIConstants.PREF_USE_STEP_FILTERS)) {
            Object newValue = event.getNewValue();
            if (newValue instanceof Boolean) {
                this.getWindowAction().setChecked(((Boolean)newValue).booleanValue());
            } else if (newValue instanceof String) {
                this.getWindowAction().setChecked(Boolean.valueOf((String)newValue).booleanValue());
            }
        }
    }

    public void dispose() {
        this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void run(IAction action) {
        DebugUITools.setUseStepFilters(action.isChecked());
    }

    public void init(IViewPart view) {
        this.init(view.getSite().getWorkbenchWindow());
    }
}

