/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.preferences;

import com.ibm.icu.text.MessageFormat;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.IInternalDebugUIConstants;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupFilter;
import org.eclipse.debug.internal.ui.launchConfigurations.PerspectiveManager;
import org.eclipse.debug.internal.ui.preferences.DebugPreferencesMessages;
import org.eclipse.debug.internal.ui.preferences.IDebugPreferenceConstants;
import org.eclipse.debug.internal.ui.preferences.LaunchConfigurationTreeContentProviderNoChildren;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ActivityManagerEvent;
import org.eclipse.ui.activities.IActivityManagerListener;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.model.WorkbenchViewerSorter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PerspectivePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IDebugPreferenceConstants,
IActivityManagerListener {
    private static final String DEBUG_LAUNCH_GROUP = "org.eclipse.debug.ui.launchGroup.debug";
    private static final String LAST_SELECTED_CONFIGTYPE = "last_selected";
    private static final int LABEL_WIDTH_HINT = 450;
    private Composite fPerspectiveComp = null;
    private HashMap fTypeInformationMapping = null;
    private String[] fPerspectiveLabels = null;
    private HashMap fPerspectiveIds = null;
    private Composite fComboPlaceHolder = null;
    private TreeViewer fViewer = null;
    private Tree fTree = null;
    private ILaunchManager fLManager = DebugPlugin.getDefault().getLaunchManager();
    private LaunchConfigurationManager fLCM = DebugUIPlugin.getDefault().getLaunchConfigurationManager();
    private PerspectiveManager fPmanager = DebugUIPlugin.getDefault().getPerspectiveManager();
    private RadioGroupFieldEditor perspec = null;
    private RadioGroupFieldEditor suspend = null;
    private ILaunchConfigurationType fCurrentType = null;
    private SelectionAdapter fSelectionAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source instanceof Combo) {
                Combo combo = (Combo)source;
                HashMap map = (HashMap)PerspectivePreferencePage.this.fTypeInformationMapping.get(PerspectivePreferencePage.this.fCurrentType);
                if (map == null) {
                    map = new HashMap();
                }
                map.put(combo.getData(), PerspectivePreferencePage.this.fPerspectiveIds.get(combo.getText()));
                PerspectivePreferencePage.this.fTypeInformationMapping.put(PerspectivePreferencePage.this.fCurrentType, map);
            }
        }
    };

    public PerspectivePreferencePage() {
        IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
        this.setPreferenceStore(store);
        this.setTitle(DebugPreferencesMessages.PerspectivePreferencePage_6);
        this.setDescription(DebugPreferencesMessages.PerspectivePreferencePage_0);
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        this.perspec.store();
        this.suspend.store();
        Iterator iter = this.fTypeInformationMapping.keySet().iterator();
        while (iter.hasNext()) {
            ILaunchConfigurationType typekey = (ILaunchConfigurationType)iter.next();
            HashMap map = (HashMap)this.fTypeInformationMapping.get(typekey);
            Iterator iter2 = map.keySet().iterator();
            while (iter2.hasNext()) {
                String modekey = (String)iter2.next();
                String perspective = (String)map.get(modekey);
                if (perspective != null) {
                    if (perspective.equals(DebugPreferencesMessages.PerspectivePreferencePage_4)) {
                        perspective = "perspective_none";
                    }
                } else {
                    perspective = "perspective_none";
                }
                this.fPmanager.setLaunchPerspective(typekey, modekey, perspective);
            }
        }
        if (this.fCurrentType != null) {
            store.setValue(LAST_SELECTED_CONFIGTYPE, this.fCurrentType.getName());
        }
        DebugUIPlugin.getDefault().savePluginPreferences();
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
    }

    private void restoreState() {
        String xml = this.getPreferenceStore().getString(IInternalDebugUIConstants.PREF_LAUNCH_PERSPECTIVES);
        this.setDefaultPerspectives();
        if (xml != null && xml.length() > 0) {
            try {
                Element root = null;
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                parser.setErrorHandler(new DefaultHandler());
                StringReader reader = new StringReader(xml);
                InputSource source = new InputSource(reader);
                root = parser.parse(source).getDocumentElement();
                NodeList list = root.getChildNodes();
                int length = list.getLength();
                int i = 0;
                while (i < length) {
                    Element element;
                    String nodeName;
                    Node node = list.item(i);
                    short nt = node.getNodeType();
                    if (nt == 1 && (nodeName = (element = (Element)node).getNodeName()).equalsIgnoreCase("launchPerspective")) {
                        String type = element.getAttribute("configurationType");
                        ILaunchConfigurationType typeobj = this.fLManager.getLaunchConfigurationType(type);
                        String mode = element.getAttribute("mode");
                        if (typeobj != null) {
                            String perspective = this.fPmanager.getLaunchPerspective(typeobj, mode);
                            HashMap<String, String> map = (HashMap<String, String>)this.fTypeInformationMapping.get(typeobj);
                            if (map == null) {
                                map = new HashMap<String, String>();
                            }
                            map.put(mode, perspective != null ? perspective : "perspective_none");
                            this.fTypeInformationMapping.put(typeobj, map);
                        }
                    }
                    ++i;
                }
            }
            catch (ParserConfigurationException e) {
                DebugUIPlugin.log(e);
            }
            catch (SAXException e) {
                DebugUIPlugin.log(e);
            }
            catch (IOException e) {
                DebugUIPlugin.log(e);
            }
        }
        this.perspec.load();
        this.suspend.load();
        TreeItem item = this.findLastSelected(this.getPreferenceStore().getString(LAST_SELECTED_CONFIGTYPE));
        if (item != null) {
            this.fTree.setSelection(new TreeItem[]{item});
        } else if (this.fTree.getItemCount() > 0) {
            this.fTree.setSelection(new TreeItem[]{this.fTree.getItem(0)});
        }
        this.fCurrentType = (ILaunchConfigurationType)((IStructuredSelection)this.fViewer.getSelection()).getFirstElement();
        this.buildComboBoxes(this.fCurrentType);
    }

    private void setDefaultPerspectives() {
        ILaunchConfigurationType[] types = this.fLManager.getLaunchConfigurationTypes();
        ArrayList modes = null;
        HashMap<String, String> map = null;
        int i = 0;
        while (i < types.length) {
            modes = new ArrayList(types[i].getSupportedModes());
            map = new HashMap<String, String>();
            int j = 0;
            while (j < modes.size()) {
                String mode;
                String persp = this.fPmanager.getDefaultLaunchPerspective(types[i], mode = (String)modes.get(j));
                map.put(mode, persp != null ? persp : "perspective_none");
                ++j;
            }
            this.fTypeInformationMapping.put(types[i], map);
            ++i;
        }
    }

    private TreeItem findLastSelected(String last) {
        TreeItem[] selection = this.fTree.getItems();
        int i = 0;
        while (i < selection.length) {
            if (selection[i].getText().equals(last)) {
                return selection[i];
            }
            ++i;
        }
        return null;
    }

    private void buildComboBoxes(ILaunchConfigurationType type) {
        HashMap launchmodes = (HashMap)this.fTypeInformationMapping.get(type);
        if (this.fComboPlaceHolder != null) {
            this.fComboPlaceHolder.dispose();
        }
        Font font = this.fPerspectiveComp.getFont();
        this.fComboPlaceHolder = new Composite(this.fPerspectiveComp, 0);
        this.fComboPlaceHolder.setLayout((Layout)new GridLayout(2, false));
        this.fComboPlaceHolder.setLayoutData((Object)new GridData(1808));
        this.fComboPlaceHolder.setFont(font);
        Label label = new Label(this.fComboPlaceHolder, 0);
        label.setText(DebugPreferencesMessages.PerspectivePreferencePage_2);
        label.setFont(font);
        GridData gd = null;
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        if (launchmodes != null) {
            Iterator iter = launchmodes.keySet().iterator();
            while (iter.hasNext()) {
                IPerspectiveDescriptor desc;
                String modekey = (String)iter.next();
                String persp = (String)launchmodes.get(modekey);
                label = new Label(this.fComboPlaceHolder, 0);
                label.setFont(font);
                gd = new GridData(1);
                label.setLayoutData((Object)gd);
                ILaunchMode mode = this.fLManager.getLaunchMode(modekey);
                String clabel = mode.getLabel();
                if (clabel.equals(DebugPreferencesMessages.PerspectivePreferencePage_7)) {
                    clabel = DebugPreferencesMessages.PerspectivePreferencePage_8;
                }
                label.setText(MessageFormat.format((String)DebugPreferencesMessages.PerspectivePreferencePage_3, (Object[])new String[]{clabel}));
                Combo combo = new Combo(this.fComboPlaceHolder, 8);
                combo.setFont(font);
                combo.setItems(this.fPerspectiveLabels);
                combo.setData((Object)modekey);
                gd = new GridData(1);
                combo.setLayoutData((Object)gd);
                persp = persp.equals("perspective_none") ? DebugPreferencesMessages.PerspectivePreferencePage_4 : ((desc = PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(persp)) != null ? desc.getLabel() : DebugPreferencesMessages.PerspectivePreferencePage_4);
                combo.setText(persp);
                combo.addSelectionListener((SelectionListener)this.fSelectionAdapter);
            }
        }
        this.fPerspectiveComp.layout();
    }

    private void handleLaunchConfigurationSelectionChanged(SelectionChangedEvent event) {
        ILaunchConfigurationType type = (ILaunchConfigurationType)((IStructuredSelection)event.getSelection()).getFirstElement();
        if (type != null && !type.equals(this.fCurrentType)) {
            this.fCurrentType = type;
            this.buildComboBoxes(this.fCurrentType);
        }
    }

    private void getPerspectiveLabels() {
        IPerspectiveRegistry registry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor[] descriptors = this.filterIds(registry.getPerspectives());
        this.fPerspectiveLabels = new String[descriptors.length + 1];
        this.fPerspectiveLabels[0] = DebugPreferencesMessages.PerspectivePreferencePage_4;
        this.fPerspectiveIds = new HashMap();
        int i = 0;
        while (i < descriptors.length) {
            this.fPerspectiveLabels[i + 1] = descriptors[i].getLabel();
            this.fPerspectiveIds.put(descriptors[i].getLabel(), descriptors[i].getId());
            ++i;
        }
    }

    private IPerspectiveDescriptor[] filterIds(IPerspectiveDescriptor[] ids) {
        ArrayList<IPerspectiveDescriptor> list = new ArrayList<IPerspectiveDescriptor>();
        int i = 0;
        while (i < ids.length) {
            if (!WorkbenchActivityHelper.filterItem((Object)ids[i])) {
                list.add(ids[i]);
            }
            ++i;
        }
        return list.toArray(new IPerspectiveDescriptor[list.size()]);
    }

    protected void createSpacer(Composite composite, int columnSpan) {
        Label label = new Label(composite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = columnSpan;
        label.setLayoutData((Object)gd);
    }

    protected void performDefaults() {
        this.perspec.loadDefault();
        this.suspend.loadDefault();
        this.setDefaultPerspectives();
        this.buildComboBoxes(this.fCurrentType);
        super.performDefaults();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IDebugHelpContextIds.PERSPECTIVE_PREFERENCE_PAGE);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.createSpacer(composite, 1);
        this.perspec = new RadioGroupFieldEditor(IInternalDebugUIConstants.PREF_SWITCH_TO_PERSPECTIVE, DebugPreferencesMessages.LaunchingPreferencePage_11, 3, (String[][])new String[][]{{DebugPreferencesMessages.LaunchingPreferencePage_12, "always"}, {DebugPreferencesMessages.LaunchingPreferencePage_13, "never"}, {DebugPreferencesMessages.LaunchingPreferencePage_14, "prompt"}}, composite, true);
        this.perspec.setPreferenceName(IInternalDebugUIConstants.PREF_SWITCH_TO_PERSPECTIVE);
        this.perspec.setPreferenceStore(this.getPreferenceStore());
        this.suspend = new RadioGroupFieldEditor(IInternalDebugUIConstants.PREF_SWITCH_PERSPECTIVE_ON_SUSPEND, DebugPreferencesMessages.DebugPreferencePage_21, 3, (String[][])new String[][]{{DebugPreferencesMessages.DebugPreferencePage_22, "always"}, {DebugPreferencesMessages.DebugPreferencePage_23, "never"}, {DebugPreferencesMessages.DebugPreferencePage_24, "prompt"}}, composite, true);
        this.suspend.setPreferenceName(IInternalDebugUIConstants.PREF_SWITCH_PERSPECTIVE_ON_SUSPEND);
        this.suspend.setPreferenceStore(this.getPreferenceStore());
        this.createSpacer(composite, 1);
        Label lbl = new Label(composite, 16448);
        lbl.setLayoutData((Object)new GridData(768));
        ((GridData)lbl.getLayoutData()).widthHint = 450;
        lbl.setText(MessageFormat.format((String)DebugPreferencesMessages.PerspectivePreferencePage_5, null));
        Composite comp = new Composite(composite, 4);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(1808));
        Composite treeComp = new Composite(comp, 0);
        treeComp.setLayout((Layout)new GridLayout(1, true));
        treeComp.setLayoutData((Object)new GridData(1808));
        Label label = new Label(treeComp, 0);
        label.setText(DebugPreferencesMessages.PerspectivePreferencePage_1);
        this.fTree = new Tree(treeComp, 2820);
        this.fTree.setLayoutData((Object)new GridData(1808));
        this.fViewer = new TreeViewer(this.fTree);
        this.fViewer.setLabelProvider((IBaseLabelProvider)DebugUITools.newDebugModelPresentation());
        this.fViewer.setSorter((ViewerSorter)new WorkbenchViewerSorter());
        this.fViewer.setContentProvider((IContentProvider)new LaunchConfigurationTreeContentProviderNoChildren(null, parent.getShell()));
        this.fViewer.addFilter((ViewerFilter)new LaunchGroupFilter(this.fLCM.getLaunchGroup(DEBUG_LAUNCH_GROUP)));
        this.fViewer.setInput((Object)this.fLManager.getLaunchConfigurationTypes());
        this.fViewer.expandAll();
        this.fViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PerspectivePreferencePage.this.handleLaunchConfigurationSelectionChanged(event);
            }
        });
        this.fPerspectiveComp = new Composite(comp, 0);
        this.fPerspectiveComp.setLayout((Layout)new GridLayout(1, true));
        this.fPerspectiveComp.setLayoutData((Object)new GridData(1808));
        this.fTypeInformationMapping = new HashMap();
        this.getPerspectiveLabels();
        this.restoreState();
        PlatformUI.getWorkbench().getActivitySupport().getActivityManager().addActivityManagerListener((IActivityManagerListener)this);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    public void activityManagerChanged(ActivityManagerEvent activityManagerEvent) {
        if (!this.fTree.isDisposed()) {
            this.fViewer.refresh();
            this.getPerspectiveLabels();
            this.restoreState();
        }
    }

    public void dispose() {
        PlatformUI.getWorkbench().getActivitySupport().getActivityManager().removeActivityManagerListener((IActivityManagerListener)this);
        super.dispose();
    }
}

