/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.wst.sse.ui.internal.Logger;

public class BasicSearchQuery
implements ISearchQuery {
    public static final String ATTR_OCCURRENCES_MARKER = "occurrences_marker";
    private static int LINE_LENGTH_LIMIT = 200;
    private IFile fFile = null;
    private List fMatches = null;

    public BasicSearchQuery(IFile file) {
        this.fFile = file;
        this.fMatches = new ArrayList();
    }

    public void addMatch(IDocument document, int matchStart, int matchEnd) {
        try {
            int lineNumber = document.getLineOfOffset(matchStart);
            int lineStart = document.getLineOffset(lineNumber);
            int lineLength = document.getLineLength(lineNumber);
            String searchResultString = document.get().substring(lineStart, lineStart + lineLength).trim();
            IMarker marker = this.createSearchMarker(matchStart, matchEnd, lineNumber, searchResultString);
            this.addMatch(new Match((Object)marker, 2, matchStart, matchStart + matchEnd));
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
    }

    private void addMatch(Match match) {
        if (match != null) {
            this.fMatches.add(match);
        }
    }

    public boolean canRerun() {
        return false;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public void clearMatches() {
        this.fMatches.clear();
    }

    protected IMarker createSearchMarker(int matchStart, int matchEnd, int lineNumber, String searchResultString) {
        IMarker marker = null;
        try {
            if (this.getFile() != null) {
                marker = this.getFile().createMarker("org.eclipse.search.searchmarker");
                HashMap<String, Boolean> attributes = new HashMap<String, Boolean>(6);
                MarkerUtilities.setCharStart(attributes, (int)matchStart);
                MarkerUtilities.setCharEnd(attributes, (int)matchEnd);
                MarkerUtilities.setLineNumber(attributes, (int)lineNumber);
                if (searchResultString.length() > LINE_LENGTH_LIMIT) {
                    searchResultString = String.valueOf(searchResultString.substring(0, LINE_LENGTH_LIMIT)) + "...";
                }
                MarkerUtilities.setMessage(attributes, (String)searchResultString);
                attributes.put(ATTR_OCCURRENCES_MARKER, new Boolean(true));
                marker.setAttributes(attributes);
            }
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        return marker;
    }

    private void deleteOccurrencesMarkers() {
        final ArrayList<IMarker> removals = new ArrayList<IMarker>();
        try {
            IMarker[] searchMarkers = this.fFile.findMarkers("org.eclipse.search.searchmarker", false, 0);
            int i = 0;
            while (i < searchMarkers.length) {
                Object o = searchMarkers[i].getAttribute(ATTR_OCCURRENCES_MARKER);
                if (o != null && ((Boolean)o).booleanValue()) {
                    removals.add(searchMarkers[i]);
                }
                ++i;
            }
            if (removals.size() > 0) {
                IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        int i = 0;
                        while (i < removals.size()) {
                            ((IMarker)removals.get(i)).delete();
                            ++i;
                        }
                    }
                };
                ResourcesPlugin.getWorkspace().run(runnable, null);
            }
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
    }

    protected IStatus doQuery() {
        return Status.OK_STATUS;
    }

    public IFile getFile() {
        return this.fFile;
    }

    public String getLabel() {
        return "";
    }

    public Match[] getMatches() {
        if (this.fFile.exists()) {
            this.deleteOccurrencesMarkers();
            this.doQuery();
        }
        return this.fMatches.toArray(new Match[this.fMatches.size()]);
    }

    public ISearchResult getSearchResult() {
        return null;
    }

    protected String getSearchText() {
        return "";
    }

    public IStatus run(IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }
}

