/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.net.URL;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.IToc;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.search.ISearchEngineResult2;

public class SearchHit
implements ISearchEngineResult2,
Comparable {
    private String href;
    private String label;
    private float score;
    private IToc toc;
    private String summary;
    private String id;
    private String participantId;
    private String filters;

    public SearchHit(String href, String label, String summary, float score, IToc toc, String id, String participantId, String filters) {
        this.href = href;
        this.label = label;
        this.score = score;
        this.toc = toc;
        this.summary = summary;
        this.id = id;
        this.participantId = participantId;
        this.filters = filters;
    }

    public int compareTo(Object o) {
        float s2;
        if (o == this) {
            return 0;
        }
        float s1 = this.getScore();
        return s1 < (s2 = ((SearchHit)o).getScore()) ? 1 : (s1 > s2 ? -1 : 0);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SearchHit) {
            if (obj == this) {
                return true;
            }
            return ((SearchHit)obj).getHref().equals(this.href);
        }
        return false;
    }

    public String getHref() {
        return this.href;
    }

    public String getLabel() {
        return this.label;
    }

    public float getScore() {
        return this.score;
    }

    public IToc getToc() {
        return this.toc;
    }

    public String getFilters() {
        return this.filters;
    }

    public int hashCode() {
        return this.href.hashCode();
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public void setFilters(String filters) {
        this.filters = filters;
    }

    public void setScore(float score) {
        this.score = score;
    }

    public void setToc(IToc toc) {
        this.toc = toc;
    }

    public String getDescription() {
        return this.getSummary();
    }

    public IHelpResource getCategory() {
        if (this.participantId == null) {
            return this.toc;
        }
        return BaseHelpSystem.getSearchManager().getParticipantCategory(this.participantId);
    }

    public String getRawSummary() {
        return this.summary;
    }

    public String getSummary() {
        if (this.summary != null && this.summary.length() > 0) {
            return String.valueOf(this.summary) + "...";
        }
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public boolean getForceExternalWindow() {
        return this.participantId != null;
    }

    public String toAbsoluteHref(String href, boolean frames) {
        return href;
    }

    public String getId() {
        return String.valueOf(this.participantId) + "/" + this.id;
    }

    public String getRawId() {
        return this.id;
    }

    public String getParticipantId() {
        return this.participantId;
    }

    public URL getIconURL() {
        if (this.participantId == null) {
            return null;
        }
        return BaseHelpSystem.getSearchManager().getParticipantIconURL(this.participantId);
    }

    public boolean canOpen() {
        return this.participantId != null;
    }
}

