/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryService;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;
import org.eclipse.ltk.internal.ui.refactoring.model.ModelMessages;
import org.eclipse.ltk.internal.ui.refactoring.model.RefactoringDescriptorSynchronizationProxy;
import org.eclipse.team.core.mapping.IMergeContext;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.ui.PlatformUI;

public final class RejectRefactoringsAction
extends Action {
    private final ISynchronizationContext fContext;
    private RefactoringDescriptorProxy[] fProxies = null;

    public RejectRefactoringsAction(ISynchronizationContext context) {
        Assert.isNotNull((Object)context);
        this.fContext = context;
        this.setText(ModelMessages.RejectRefactoringsAction_title);
        this.setToolTipText(ModelMessages.RejectRefactoringsAction_tool_tip);
        this.setDescription(ModelMessages.RejectRefactoringsAction_description);
    }

    public boolean isEnabled() {
        if (this.fProxies != null && this.fProxies.length > 0 && this.fContext instanceof IMergeContext) {
            int index = 0;
            while (index < this.fProxies.length) {
                RefactoringDescriptorSynchronizationProxy proxy;
                if (this.fProxies[index] instanceof RefactoringDescriptorSynchronizationProxy && (proxy = (RefactoringDescriptorSynchronizationProxy)this.fProxies[index]).getDirection() == 512) {
                    return true;
                }
                ++index;
            }
        }
        return false;
    }

    public void run() {
        if (this.fProxies != null) {
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(){

                    /*
                     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public final void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            monitor.beginTask("", RejectRefactoringsAction.this.fProxies.length + 100);
                            RefactoringHistoryService service = RefactoringHistoryService.getInstance();
                            int index = 0;
                            while (index < RejectRefactoringsAction.this.fProxies.length) {
                                service.addRefactoringDescriptor(RejectRefactoringsAction.this.fProxies[index], (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                ++index;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var4_5 = null;
                            monitor.done();
                            throw throwable;
                        }
                        {
                            Object var4_6 = null;
                        }
                        monitor.done();
                    }
                });
            }
            catch (InvocationTargetException exception) {
                RefactoringUIPlugin.log(exception);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void setRefactoringDescriptors(RefactoringDescriptorProxy[] proxies) {
        Assert.isNotNull((Object)proxies);
        this.fProxies = proxies;
    }
}

