/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.data.internal.ui;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.rdb.data.internal.ui.ExternalTableDataEditorExtension;
import org.eclipse.wst.rdb.data.internal.ui.editor.IExternalTableDataEditor;
import org.eclipse.wst.rdb.data.internal.ui.editor.TableDataEditor;
import org.eclipse.wst.rdb.data.internal.ui.editor.TableDataEditorActionBarContributor;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.containment.ContainmentService;
import org.eclipse.wst.rdb.internal.models.sql.datatypes.BinaryStringDataType;
import org.eclipse.wst.rdb.internal.models.sql.datatypes.CharacterStringDataType;
import org.eclipse.wst.rdb.internal.models.sql.datatypes.DataLinkDataType;
import org.eclipse.wst.rdb.internal.models.sql.datatypes.DataType;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.tables.Column;

public class DataUIPlugin
extends AbstractUIPlugin {
    private static DataUIPlugin plugin;
    public static final String PLUGIN_ID = "org.eclipse.wst.rdb.data.ui";
    protected TableDataEditorActionBarContributor tableDataEditorContributor;
    protected List externalTableDataEditorExtensions;

    public DataUIPlugin() {
        plugin = this;
        this.listExternalTableDataEditorExtensions();
    }

    public static DataUIPlugin getDefault() {
        return plugin;
    }

    public TableDataEditorActionBarContributor getTableDataEditorContributor() {
        return this.tableDataEditorContributor;
    }

    public void setTableDataEditorContributor(TableDataEditorActionBarContributor tableDataEditorContributor) {
        this.tableDataEditorContributor = tableDataEditorContributor;
    }

    public void writeLog(int severity, int code, String message, Throwable exception) {
        if (message == null) {
            message = "";
        }
        this.getLog().log((IStatus)new Status(severity, this.getBundle().getSymbolicName(), code, message, exception));
    }

    public static boolean isGroupIDOK(EObject o) {
        if (o == null) {
            return false;
        }
        ContainmentService containmentService = RDBCorePlugin.getDefault().getContainmentService();
        String groupID = containmentService.getGroupId(o);
        return groupID != null && groupID.startsWith("core.");
    }

    public static String getCharacterEncoding() {
        return ResourcesPlugin.getEncoding();
    }

    public ImageDescriptor getImageDescriptor(String key) {
        try {
            return ImageDescriptor.createFromURL((URL)new URL(this.getBundle().getEntry("/"), "icons" + File.separator + key + ".gif"));
        }
        catch (Exception e) {
            this.writeLog(4, 0, e.getMessage(), e);
            return null;
        }
    }

    protected void listExternalTableDataEditorExtensions() {
        this.externalTableDataEditorExtensions = new ArrayList();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.wst.rdb.data.ui.externalTableDataEditor");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                this.externalTableDataEditorExtensions.add(new ExternalTableDataEditorExtension(elements[j]));
                ++j;
            }
            ++i;
        }
    }

    public IExternalTableDataEditor newExternalTableDataCellEditor(TableDataEditor editor, int columnIndex) {
        if (editor == null || editor.getSqlTable() == null || editor.getSqlTable().getColumns() == null) {
            return null;
        }
        if (columnIndex > editor.getSqlTable().getColumns().size()) {
            return null;
        }
        Column sqlCol = (Column)editor.getSqlTable().getColumns().get(columnIndex);
        IExternalTableDataEditor externalEditor = null;
        try {
            Database db = sqlCol.getTable().getSchema().getDatabase();
            DataType type = sqlCol.getDataType();
            String vendor = db.getVendor();
            String version = db.getVersion();
            String dataType = sqlCol.getDataType().getName();
            int length = -1;
            boolean lengthSupported = false;
            if (type instanceof DataLinkDataType) {
                lengthSupported = true;
                length = ((DataLinkDataType)type).getLength();
            }
            if (type instanceof BinaryStringDataType) {
                lengthSupported = true;
                length = ((BinaryStringDataType)type).getLength();
            }
            if (type instanceof CharacterStringDataType) {
                lengthSupported = true;
                length = ((CharacterStringDataType)type).getLength();
            }
            ExternalTableDataEditorExtension element = null;
            Iterator it = this.externalTableDataEditorExtensions.iterator();
            while (it.hasNext()) {
                boolean matches;
                ExternalTableDataEditorExtension curElement = (ExternalTableDataEditorExtension)it.next();
                boolean bl = matches = curElement.matches(vendor, version, dataType, lengthSupported, length) && (element == null || curElement.getScore() > element.getScore());
                if (!matches) continue;
                element = curElement;
            }
            if (element != null) {
                externalEditor = element.createInstance();
            }
        }
        catch (CoreException ex) {
            this.writeLog(4, 0, ex.getMessage(), ex);
        }
        return externalEditor;
    }
}

