/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.refactoring.IJavaElementMapper;
import org.eclipse.jdt.core.refactoring.RenameTypeArguments;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptor;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenameCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenameResourceChange;
import org.eclipse.jdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameTypeProcessor;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IQualifiedNameUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.ISimilarDeclarationUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.IResourceMapper;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;

public class RenameCompilationUnitProcessor
extends JavaRenameProcessor
implements IReferenceUpdating,
ITextUpdating,
IQualifiedNameUpdating,
ISimilarDeclarationUpdating,
IResourceMapper,
IJavaElementMapper {
    private static final String ID_RENAME_COMPILATION_UNIT = "org.eclipse.jdt.ui.rename.compilationunit";
    private static final String ATTRIBUTE_PATH = "path";
    private static final String ATTRIBUTE_NAME = "name";
    private RenameTypeProcessor fRenameTypeProcessor;
    private boolean fWillRenameType;
    private ICompilationUnit fCu;
    public static final String IDENTIFIER = "org.eclipse.jdt.ui.renameCompilationUnitProcessor";

    public RenameCompilationUnitProcessor(ICompilationUnit unit) throws CoreException {
        this.fCu = unit;
        if (this.fCu != null) {
            this.computeRenameTypeRefactoring();
            this.setNewElementName(this.fCu.getElementName());
        }
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public boolean isApplicable() {
        return RefactoringAvailabilityTester.isRenameAvailable(this.fCu);
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.RenameCompilationUnitRefactoring_name;
    }

    protected String[] getAffectedProjectNatures() throws CoreException {
        return JavaProcessors.computeAffectedNatures((IJavaElement)this.fCu);
    }

    public Object[] getElements() {
        return new Object[]{this.fCu};
    }

    protected RenameModifications computeRenameModifications() {
        RenameModifications result = new RenameModifications();
        result.rename(this.fCu, new RenameArguments(this.getNewElementName(), this.getUpdateReferences()));
        if (this.fRenameTypeProcessor != null) {
            String newTypeName = RenameCompilationUnitProcessor.removeFileNameExtension(this.getNewElementName());
            RenameTypeArguments arguments = new RenameTypeArguments(newTypeName, this.getUpdateReferences(), this.getUpdateSimilarDeclarations(), this.getSimilarElements());
            result.rename(this.fRenameTypeProcessor.getType(), arguments, this.getUpdateSimilarDeclarations() ? new RenameTypeProcessor.ParticipantDescriptorFilter() : null);
        }
        return result;
    }

    protected IFile[] getChangedFiles() throws CoreException {
        IFile file;
        if (!this.fWillRenameType && (file = ResourceUtil.getFile(this.fCu)) != null) {
            return new IFile[]{file};
        }
        return new IFile[0];
    }

    public String getCurrentElementName() {
        return this.getSimpleCUName();
    }

    public String getCurrentElementQualifier() {
        IPackageFragment pack = (IPackageFragment)this.fCu.getParent();
        return pack.getElementName();
    }

    public RefactoringStatus checkNewElementName(String newName) throws CoreException {
        Assert.isNotNull((Object)newName, (String)"new name");
        String typeName = RenameCompilationUnitProcessor.removeFileNameExtension(newName);
        RefactoringStatus result = Checks.checkCompilationUnitName(newName);
        if (this.fWillRenameType) {
            result.merge(this.fRenameTypeProcessor.checkNewElementName(typeName));
        }
        if (Checks.isAlreadyNamed((IJavaElement)this.fCu, newName)) {
            result.addFatalError(RefactoringCoreMessages.RenameCompilationUnitRefactoring_same_name);
        }
        return result;
    }

    public void setNewElementName(String newName) {
        super.setNewElementName(newName);
        if (this.fWillRenameType) {
            this.fRenameTypeProcessor.setNewElementName(RenameCompilationUnitProcessor.removeFileNameExtension(newName));
        }
    }

    public Object getNewElement() {
        IJavaElement parent = this.fCu.getParent();
        if (parent.getElementType() != 4) {
            return this.fCu;
        }
        IPackageFragment pack = (IPackageFragment)parent;
        if (JavaConventions.validateCompilationUnitName((String)this.getNewElementName()).getSeverity() == 4) {
            return this.fCu;
        }
        return pack.getCompilationUnit(this.getNewElementName());
    }

    public boolean canEnableTextUpdating() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.canEnableUpdateReferences();
    }

    public boolean getUpdateTextualMatches() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.getUpdateTextualMatches();
    }

    public void setUpdateTextualMatches(boolean update) {
        if (this.fRenameTypeProcessor != null) {
            this.fRenameTypeProcessor.setUpdateTextualMatches(update);
        }
    }

    public boolean canEnableUpdateReferences() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.canEnableUpdateReferences();
    }

    public void setUpdateReferences(boolean update) {
        if (this.fRenameTypeProcessor != null) {
            this.fRenameTypeProcessor.setUpdateReferences(update);
        }
    }

    public boolean getUpdateReferences() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.getUpdateReferences();
    }

    public boolean canEnableQualifiedNameUpdating() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.canEnableQualifiedNameUpdating();
    }

    public boolean getUpdateQualifiedNames() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.getUpdateQualifiedNames();
    }

    public void setUpdateQualifiedNames(boolean update) {
        if (this.fRenameTypeProcessor == null) {
            return;
        }
        this.fRenameTypeProcessor.setUpdateQualifiedNames(update);
    }

    public String getFilePatterns() {
        if (this.fRenameTypeProcessor == null) {
            return null;
        }
        return this.fRenameTypeProcessor.getFilePatterns();
    }

    public void setFilePatterns(String patterns) {
        if (this.fRenameTypeProcessor == null) {
            return;
        }
        this.fRenameTypeProcessor.setFilePatterns(patterns);
    }

    public boolean canEnableSimilarDeclarationUpdating() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.canEnableSimilarDeclarationUpdating();
    }

    public void setUpdateSimilarDeclarations(boolean update) {
        if (this.fRenameTypeProcessor == null) {
            return;
        }
        this.fRenameTypeProcessor.setUpdateSimilarDeclarations(update);
    }

    public boolean getUpdateSimilarDeclarations() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.getUpdateSimilarDeclarations();
    }

    public int getMatchStrategy() {
        if (this.fRenameTypeProcessor == null) {
            return 1;
        }
        return this.fRenameTypeProcessor.getMatchStrategy();
    }

    public void setMatchStrategy(int selectedStrategy) {
        if (this.fRenameTypeProcessor == null) {
            return;
        }
        this.fRenameTypeProcessor.setMatchStrategy(selectedStrategy);
    }

    public IJavaElement[] getSimilarElements() {
        if (this.fRenameTypeProcessor == null) {
            return null;
        }
        return this.fRenameTypeProcessor.getSimilarElements();
    }

    public IResource getRefactoredResource(IResource element) {
        if (this.fRenameTypeProcessor == null) {
            return element;
        }
        return this.fRenameTypeProcessor.getRefactoredResource(element);
    }

    public IJavaElement getRefactoredJavaElement(IJavaElement element) {
        if (this.fRenameTypeProcessor == null) {
            return element;
        }
        return this.fRenameTypeProcessor.getRefactoredJavaElement(element);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        if (this.fRenameTypeProcessor != null && !this.fCu.isStructureKnown()) {
            this.fRenameTypeProcessor = null;
            this.fWillRenameType = false;
            return new RefactoringStatus();
        }
        if (this.fWillRenameType && this.fRenameTypeProcessor != null && !this.fRenameTypeProcessor.getType().exists()) {
            this.fRenameTypeProcessor = null;
            this.fWillRenameType = false;
            return new RefactoringStatus();
        }
        return new RefactoringStatus();
    }

    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        block6: {
            RefactoringStatus refactoringStatus;
            try {
                if (this.fWillRenameType && !this.fCu.isStructureKnown()) {
                    RefactoringStatus result1 = new RefactoringStatus();
                    RefactoringStatus result2 = new RefactoringStatus();
                    result2.merge(Checks.checkCompilationUnitNewName(this.fCu, this.getNewElementName()));
                    if (result2.hasFatalError()) {
                        result1.addError(Messages.format(RefactoringCoreMessages.RenameCompilationUnitRefactoring_not_parsed_1, this.fCu.getElementName()));
                    } else {
                        result1.addError(Messages.format(RefactoringCoreMessages.RenameCompilationUnitRefactoring_not_parsed, this.fCu.getElementName()));
                    }
                    result1.merge(result2);
                }
                if (!this.fWillRenameType) break block6;
                refactoringStatus = this.fRenameTypeProcessor.checkFinalConditions(pm, context);
                Object var5_7 = null;
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                pm.done();
                throw throwable;
            }
            pm.done();
            return refactoringStatus;
        }
        RefactoringStatus refactoringStatus = Checks.checkCompilationUnitNewName(this.fCu, this.getNewElementName());
        Object var5_8 = null;
        pm.done();
        return refactoringStatus;
    }

    private void computeRenameTypeRefactoring() throws CoreException {
        if (this.getSimpleCUName().indexOf(".") != -1) {
            this.fRenameTypeProcessor = null;
            this.fWillRenameType = false;
            return;
        }
        IType type = this.getTypeWithTheSameName();
        this.fRenameTypeProcessor = type != null ? new RenameTypeProcessor(type) : null;
        this.fWillRenameType = this.fRenameTypeProcessor != null && this.fCu.isStructureKnown();
    }

    private IType getTypeWithTheSameName() {
        try {
            IType[] topLevelTypes = this.fCu.getTypes();
            String name = this.getSimpleCUName();
            int i = 0;
            while (i < topLevelTypes.length) {
                if (name.equals(topLevelTypes[i].getElementName())) {
                    return topLevelTypes[i];
                }
                ++i;
            }
            return null;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private String getSimpleCUName() {
        return RenameCompilationUnitProcessor.removeFileNameExtension(this.fCu.getElementName());
    }

    private static String removeFileNameExtension(String fileName) {
        if (fileName.lastIndexOf(".") == -1) {
            return fileName;
        }
        return fileName.substring(0, fileName.lastIndexOf("."));
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        IPackageFragment fragment;
        if (this.fWillRenameType) {
            return this.fRenameTypeProcessor.createChange(pm);
        }
        this.fRenameTypeProcessor = null;
        String newName = this.getNewElementName();
        IResource resource = ResourceUtil.getResource(this.fCu);
        if (resource != null && resource.isLinked()) {
            HashMap<String, String> arguments = new HashMap<String, String>();
            IProject project = resource.getProject();
            String name = project.getName();
            String description = Messages.format(RefactoringCoreMessages.RenameCompilationUnitChange_descriptor_description_short, resource.getName());
            String header = Messages.format(RefactoringCoreMessages.RenameCompilationUnitChange_descriptor_description, new String[]{resource.getFullPath().toString(), newName});
            String comment = new JavaRefactoringDescriptorComment(this, header).asString();
            JavaRefactoringDescriptor descriptor = new JavaRefactoringDescriptor("org.eclipse.jdt.ui.rename.resource", name, description, comment, arguments, 7);
            arguments.put("input", JavaRefactoringDescriptor.resourceToHandle(name, resource));
            arguments.put(ATTRIBUTE_NAME, newName);
            return new DynamicValidationStateChange(new RenameResourceChange(descriptor, resource, newName, comment));
        }
        String label = null;
        label = this.fCu != null ? (!(fragment = (IPackageFragment)this.fCu.getParent()).isDefaultPackage() ? String.valueOf(fragment.getElementName()) + "." + this.fCu.getElementName() : this.fCu.getElementName()) : this.fCu.getElementName();
        HashMap<String, String> arguments = new HashMap<String, String>();
        String name = this.fCu.getJavaProject().getElementName();
        String description = Messages.format(RefactoringCoreMessages.RenameCompilationUnitChange_descriptor_description_short, this.fCu.getElementName());
        String header = Messages.format(RefactoringCoreMessages.RenameCompilationUnitChange_descriptor_description, new String[]{label, newName});
        String comment = new JavaRefactoringDescriptorComment(this, header).asString();
        JavaRefactoringDescriptor descriptor = new JavaRefactoringDescriptor(ID_RENAME_COMPILATION_UNIT, name, description, comment, arguments, 589830);
        arguments.put("input", descriptor.elementToHandle((IJavaElement)this.fCu));
        arguments.put(ATTRIBUTE_NAME, newName);
        return new DynamicValidationStateChange(new RenameCompilationUnitChange(descriptor, this.fCu, newName, comment));
    }

    public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
        if (this.fWillRenameType) {
            return this.fRenameTypeProcessor.postCreateChange(participantChanges, pm);
        }
        return super.postCreateChange(participantChanges, pm);
    }

    public RefactoringStatus initialize(RefactoringArguments arguments) {
        String name;
        if (arguments instanceof JavaRefactoringArguments) {
            JavaRefactoringArguments generic = (JavaRefactoringArguments)arguments;
            String path = generic.getAttribute(ATTRIBUTE_PATH);
            if (path != null) {
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(path));
                if (resource == null || !resource.exists()) {
                    return ScriptableRefactoring.createInputFatalStatus(resource, this.getRefactoring().getName(), ID_RENAME_COMPILATION_UNIT);
                }
                this.fCu = (ICompilationUnit)JavaCore.create((IResource)resource);
                try {
                    this.computeRenameTypeRefactoring();
                }
                catch (CoreException exception) {
                    JavaPlugin.log(exception);
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_PATH));
            }
            name = generic.getAttribute(ATTRIBUTE_NAME);
            if (name == null || "".equals(name)) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_NAME));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.setNewElementName(name);
        return new RefactoringStatus();
    }

    public RenameTypeProcessor getRenameTypeProcessor() {
        return this.fRenameTypeProcessor;
    }

    public boolean isWillRenameType() {
        return this.fWillRenameType;
    }
}

