/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.compare;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.ITokenComparator;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.compare.CompareMessages;
import org.eclipse.jdt.internal.ui.compare.EclipsePreferencesAdapter;
import org.eclipse.jdt.internal.ui.compare.JavaCompareUtilities;
import org.eclipse.jdt.internal.ui.compare.JavaNode;
import org.eclipse.jdt.internal.ui.compare.JavaTokenComparator;
import org.eclipse.jdt.internal.ui.text.PreferencesAdapter;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;

public class JavaMergeViewer
extends TextMergeViewer {
    private IPropertyChangeListener fPreferenceChangeListener;
    private IPreferenceStore fPreferenceStore;
    private boolean fUseSystemColors;
    private JavaSourceViewerConfiguration fSourceViewerConfiguration;
    private ArrayList fSourceViewer;

    public JavaMergeViewer(Composite parent, int styles, CompareConfiguration mp) {
        super(parent, styles | 0x2000000, mp);
        this.getPreferenceStore();
        this.fUseSystemColors = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault");
        if (!this.fUseSystemColors) {
            RGB bg = JavaMergeViewer.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.Background");
            this.setBackgroundColor(bg);
            RGB fg = JavaMergeViewer.createColor(this.fPreferenceStore, "java_default");
            this.setForegroundColor(fg);
        }
    }

    private IPreferenceStore getPreferenceStore() {
        if (this.fPreferenceStore == null) {
            this.setPreferenceStore((IPreferenceStore)this.createChainedPreferenceStore(null));
        }
        return this.fPreferenceStore;
    }

    protected void handleDispose(DisposeEvent event) {
        this.setPreferenceStore(null);
        this.fSourceViewer = null;
        super.handleDispose(event);
    }

    public IJavaProject getJavaProject(ICompareInput input) {
        IJavaElement element;
        IResource resource;
        if (input == null) {
            return null;
        }
        IResourceProvider rp = null;
        ITypedElement te = input.getLeft();
        if (te instanceof IResourceProvider) {
            rp = (IResourceProvider)te;
        }
        if (rp == null && (te = input.getRight()) instanceof IResourceProvider) {
            rp = (IResourceProvider)te;
        }
        if (rp == null && (te = input.getAncestor()) instanceof IResourceProvider) {
            rp = (IResourceProvider)te;
        }
        if (rp != null && (resource = rp.getResource()) != null && (element = JavaCore.create((IResource)resource)) != null) {
            return element.getJavaProject();
        }
        return null;
    }

    public void setInput(Object input) {
        IJavaProject project;
        if (input instanceof ICompareInput && (project = this.getJavaProject((ICompareInput)input)) != null) {
            this.setPreferenceStore((IPreferenceStore)this.createChainedPreferenceStore(project));
            if (this.fSourceViewer != null) {
                Iterator iterator = this.fSourceViewer.iterator();
                while (iterator.hasNext()) {
                    SourceViewer sourceViewer = (SourceViewer)iterator.next();
                    sourceViewer.unconfigure();
                    sourceViewer.configure((SourceViewerConfiguration)this.getSourceViewerConfiguration());
                }
            }
        }
        super.setInput(input);
    }

    private ChainedPreferenceStore createChainedPreferenceStore(IJavaProject project) {
        ArrayList<IPreferenceStore> stores = new ArrayList<IPreferenceStore>(4);
        if (project != null) {
            stores.add(new EclipsePreferencesAdapter((IScopeContext)new ProjectScope(project.getProject()), "org.eclipse.jdt.core"));
        }
        stores.add(JavaPlugin.getDefault().getPreferenceStore());
        stores.add(new PreferencesAdapter(JavaCore.getPlugin().getPluginPreferences()));
        stores.add(EditorsUI.getPreferenceStore());
        return new ChainedPreferenceStore(stores.toArray(new IPreferenceStore[stores.size()]));
    }

    private void handlePropertyChange(PropertyChangeEvent event) {
        String key = event.getProperty();
        if (key.equals("AbstractTextEditor.Color.Background")) {
            if (!this.fUseSystemColors) {
                RGB bg = JavaMergeViewer.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.Background");
                this.setBackgroundColor(bg);
            }
        } else if (key.equals("AbstractTextEditor.Color.Background.SystemDefault")) {
            this.fUseSystemColors = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault");
            if (this.fUseSystemColors) {
                this.setBackgroundColor(null);
                this.setForegroundColor(null);
            } else {
                RGB bg = JavaMergeViewer.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.Background");
                this.setBackgroundColor(bg);
                RGB fg = JavaMergeViewer.createColor(this.fPreferenceStore, "java_default");
                this.setForegroundColor(fg);
            }
        } else if (key.equals("java_default") && !this.fUseSystemColors) {
            RGB fg = JavaMergeViewer.createColor(this.fPreferenceStore, "java_default");
            this.setForegroundColor(fg);
        }
        if (this.fSourceViewerConfiguration != null && this.fSourceViewerConfiguration.affectsTextPresentation(event)) {
            this.fSourceViewerConfiguration.handlePropertyChangeEvent(event);
            this.invalidateTextPresentation();
        }
    }

    private static RGB createColor(IPreferenceStore store, String key) {
        if (!store.contains(key)) {
            return null;
        }
        if (store.isDefault(key)) {
            return PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key);
        }
        return PreferenceConverter.getColor((IPreferenceStore)store, (String)key);
    }

    public String getTitle() {
        return CompareMessages.JavaMergeViewer_title;
    }

    protected ITokenComparator createTokenComparator(String s) {
        return new JavaTokenComparator(s, true);
    }

    protected IDocumentPartitioner getDocumentPartitioner() {
        return JavaCompareUtilities.createJavaPartitioner();
    }

    protected void configureTextViewer(TextViewer textViewer) {
        if (textViewer instanceof SourceViewer) {
            if (this.fSourceViewer == null) {
                this.fSourceViewer = new ArrayList();
            }
            this.fSourceViewer.add(textViewer);
            JavaTextTools tools = JavaCompareUtilities.getJavaTextTools();
            if (tools != null) {
                ((SourceViewer)textViewer).configure((SourceViewerConfiguration)this.getSourceViewerConfiguration());
            }
        }
    }

    private JavaSourceViewerConfiguration getSourceViewerConfiguration() {
        if (this.fSourceViewerConfiguration == null) {
            this.getPreferenceStore();
        }
        return this.fSourceViewerConfiguration;
    }

    protected int findInsertionPosition(char type, ICompareInput input) {
        int pos = super.findInsertionPosition(type, input);
        if (pos != 0) {
            return pos;
        }
        if (input instanceof IDiffElement) {
            JavaNode otherJavaElement = null;
            ITypedElement otherElement = null;
            switch (type) {
                case 'L': {
                    otherElement = input.getRight();
                    break;
                }
                case 'R': {
                    otherElement = input.getLeft();
                }
            }
            if (otherElement instanceof JavaNode) {
                otherJavaElement = (JavaNode)otherElement;
            }
            JavaNode javaContainer = null;
            IDiffElement diffElement = (IDiffElement)input;
            IDiffContainer container = diffElement.getParent();
            if (container instanceof ICompareInput) {
                ICompareInput parent = (ICompareInput)container;
                ITypedElement element = null;
                switch (type) {
                    case 'L': {
                        element = parent.getLeft();
                        break;
                    }
                    case 'R': {
                        element = parent.getRight();
                    }
                }
                if (element instanceof JavaNode) {
                    javaContainer = (JavaNode)element;
                }
            }
            if (otherJavaElement != null && javaContainer != null) {
                switch (otherJavaElement.getTypeCode()) {
                    case 1: {
                        return 0;
                    }
                    case 2: {
                        Position p;
                        Object[] children = javaContainer.getChildren();
                        if (children.length > 0) {
                            JavaNode packageDecl = null;
                            int i = 0;
                            while (i < children.length) {
                                JavaNode child = (JavaNode)((Object)children[i]);
                                switch (child.getTypeCode()) {
                                    case 1: {
                                        packageDecl = child;
                                        break;
                                    }
                                    case 5: {
                                        return child.getRange().getOffset();
                                    }
                                }
                                ++i;
                            }
                            if (packageDecl != null) {
                                p = packageDecl.getRange();
                                return p.getOffset() + p.getLength();
                            }
                        }
                        return javaContainer.getRange().getOffset();
                    }
                    case 3: {
                        Position p = javaContainer.getRange();
                        return p.getOffset() + p.getLength();
                    }
                    case 5: {
                        Position p;
                        Object[] children = javaContainer.getChildren();
                        if (children.length > 0) {
                            int i = children.length - 1;
                            while (i >= 0) {
                                JavaNode child = (JavaNode)((Object)children[i]);
                                switch (child.getTypeCode()) {
                                    case 1: 
                                    case 2: 
                                    case 5: 
                                    case 8: {
                                        p = child.getRange();
                                        return p.getOffset() + p.getLength();
                                    }
                                }
                                --i;
                            }
                        }
                        return javaContainer.getAppendPosition().getOffset();
                    }
                    case 11: {
                        Position p;
                        Object[] children = javaContainer.getChildren();
                        if (children.length > 0) {
                            JavaNode child = (JavaNode)((Object)children[children.length - 1]);
                            p = child.getRange();
                            return this.findEndOfLine(javaContainer, p.getOffset() + p.getLength());
                        }
                        return javaContainer.getAppendPosition().getOffset();
                    }
                    case 8: {
                        Position p;
                        Object[] children = javaContainer.getChildren();
                        if (children.length > 0) {
                            JavaNode method = null;
                            int i = children.length - 1;
                            while (i >= 0) {
                                JavaNode child = (JavaNode)((Object)children[i]);
                                switch (child.getTypeCode()) {
                                    case 11: {
                                        method = child;
                                        break;
                                    }
                                    case 8: {
                                        p = child.getRange();
                                        return p.getOffset() + p.getLength();
                                    }
                                }
                                --i;
                            }
                            if (method != null) {
                                return method.getRange().getOffset();
                            }
                        }
                        return javaContainer.getAppendPosition().getOffset();
                    }
                }
            }
            if (javaContainer != null) {
                Position p = javaContainer.getRange();
                return p.getOffset() + p.getLength();
            }
        }
        return 0;
    }

    private int findEndOfLine(JavaNode container, int pos) {
        IDocument doc = container.getDocument();
        try {
            int line = doc.getLineOfOffset(pos);
            pos = doc.getLineOffset(line + 1);
        }
        catch (BadLocationException badLocationException) {}
        Position containerRange = container.getRange();
        int start = containerRange.getOffset();
        int end = containerRange.getOffset() + containerRange.getLength();
        if (pos < start) {
            return start;
        }
        if (pos >= end) {
            return end - 1;
        }
        return pos;
    }

    private void setPreferenceStore(IPreferenceStore ps) {
        if (this.fPreferenceChangeListener != null) {
            if (this.fPreferenceStore != null) {
                this.fPreferenceStore.removePropertyChangeListener(this.fPreferenceChangeListener);
            }
            this.fPreferenceChangeListener = null;
        }
        this.fPreferenceStore = ps;
        if (this.fPreferenceStore != null) {
            JavaTextTools tools = JavaCompareUtilities.getJavaTextTools();
            this.fSourceViewerConfiguration = new JavaSourceViewerConfiguration(tools.getColorManager(), this.fPreferenceStore, null, null);
            this.fPreferenceChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    JavaMergeViewer.this.handlePropertyChange(event);
                }
            };
            this.fPreferenceStore.addPropertyChangeListener(this.fPreferenceChangeListener);
        }
    }
}

