/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Random;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.IFix;
import org.eclipse.jdt.internal.corext.fix.PotentialProgrammingProblemsFix;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jface.dialogs.IDialogSettings;

public class PotentialProgrammingProblemsCleanUp
extends AbstractCleanUp {
    public static final int ADD_CALCULATED_SERIAL_VERSION_ID = 1;
    public static final int ADD_DEFAULT_SERIAL_VERSION_ID = 2;
    public static final int ADD_RANDOM_SERIAL_VERSION_ID = 4;
    private static final int DEFAULT_FLAG = 0;
    private static final String SECTION_NAME = "CleanUp_PotentialProgrammingProblems0";
    private static final Random RANDOM_NUMBER_GENERATOR = new Random();
    private PotentialProgrammingProblemsFix.ISerialVersionFixContext fContext;

    public PotentialProgrammingProblemsCleanUp(int flag) {
        super(flag);
    }

    public PotentialProgrammingProblemsCleanUp(IDialogSettings settings) {
        super(PotentialProgrammingProblemsCleanUp.getSection(settings, SECTION_NAME), 0);
    }

    public IFix createFix(CompilationUnit compilationUnit) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        return PotentialProgrammingProblemsFix.createCleanUp(compilationUnit, this.isFlag(1) || this.isFlag(2) || this.isFlag(4), this.getContext());
    }

    public IFix createFix(CompilationUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        return PotentialProgrammingProblemsFix.createCleanUp(compilationUnit, problems, this.isFlag(1) || this.isFlag(2) || this.isFlag(4), this.getContext());
    }

    public Map getRequiredOptions() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        if (this.isFlag(1) || this.isFlag(2) || this.isFlag(4)) {
            options.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "warning");
        }
        return options;
    }

    public void saveSettings(IDialogSettings settings) {
        super.saveSettings(PotentialProgrammingProblemsCleanUp.getSection(settings, SECTION_NAME));
    }

    public String[] getDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isFlag(1)) {
            result.add(MultiFixMessages.SerialVersionCleanUp_Generated_description);
        }
        if (this.isFlag(2)) {
            result.add(MultiFixMessages.CodeStyleCleanUp_addDefaultSerialVersionId_description);
        }
        if (this.isFlag(4)) {
            result.add(MultiFixMessages.PotentialProgrammingProblemsCleanUp_RandomSerialId_description);
        }
        return result.toArray(new String[result.size()]);
    }

    public String getPreview() {
        StringBuffer buf = new StringBuffer();
        buf.append("class E implements java.io.Serializable{\n");
        if (this.isFlag(1)) {
            buf.append("    private static final long serialVersionUID = -391484377137870342L;\n");
        } else if (this.isFlag(2)) {
            buf.append("    private static final long serialVersionUID = 1L;\n");
        }
        buf.append("}\n");
        return buf.toString();
    }

    public boolean canFix(CompilationUnit compilationUnit, IProblemLocation problem) throws CoreException {
        IFix[] fix;
        return (this.isFlag(1) || this.isFlag(2)) && (fix = PotentialProgrammingProblemsFix.createMissingSerialVersionFixes(compilationUnit, problem)) != null;
    }

    public void beginCleanUp(IJavaProject project, ICompilationUnit[] compilationUnits, IProgressMonitor monitor) throws CoreException {
        super.beginCleanUp(project, compilationUnits, monitor);
        if (this.isFlag(1)) {
            this.fContext = PotentialProgrammingProblemsFix.createSerialVersionHashContext(project, compilationUnits, monitor);
        }
    }

    public void endCleanUp() throws CoreException {
        super.endCleanUp();
        this.fContext = null;
    }

    private PotentialProgrammingProblemsFix.ISerialVersionFixContext getContext() {
        if (this.isFlag(1)) {
            return this.fContext;
        }
        if (this.isFlag(2)) {
            return new PotentialProgrammingProblemsFix.ISerialVersionFixContext(){

                public long getSerialVersionId(String qualifiedName) throws CoreException {
                    return 1L;
                }
            };
        }
        if (this.isFlag(4)) {
            return new PotentialProgrammingProblemsFix.ISerialVersionFixContext(){

                public long getSerialVersionId(String qualifiedName) throws CoreException {
                    return RANDOM_NUMBER_GENERATOR.nextLong();
                }
            };
        }
        return null;
    }

    public int maximalNumberOfFixes(CompilationUnit compilationUnit) {
        if (this.isFlag(1) || this.isFlag(2) || this.isFlag(4)) {
            return this.getNumberOfProblems(compilationUnit.getProblems(), 0x20000060);
        }
        return 0;
    }

    public int getDefaultFlag() {
        return 0;
    }
}

