/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.internal.ui.search.WorkingSetComparator;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;

public class JavaSearchScopeFactory {
    private static JavaSearchScopeFactory fgInstance;
    private final IJavaSearchScope EMPTY_SCOPE = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[0]);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private JavaSearchScopeFactory() {
    }

    public static JavaSearchScopeFactory getInstance() {
        if (fgInstance == null) {
            fgInstance = new JavaSearchScopeFactory();
        }
        return fgInstance;
    }

    public IWorkingSet[] queryWorkingSets() throws JavaModelException {
        IWorkingSet[] workingSets;
        Shell shell = JavaPlugin.getActiveWorkbenchShell();
        if (shell == null) {
            return null;
        }
        IWorkingSetSelectionDialog dialog = PlatformUI.getWorkbench().getWorkingSetManager().createWorkingSetSelectionDialog(shell, true);
        if (dialog.open() == 0 && (workingSets = dialog.getSelection()).length > 0) {
            return workingSets;
        }
        return null;
    }

    public IJavaSearchScope createJavaSearchScope(IWorkingSet[] workingSets, boolean includeJRE) {
        if (workingSets == null || workingSets.length < 1) {
            return this.EMPTY_SCOPE;
        }
        HashSet javaElements = new HashSet(workingSets.length * 10);
        int i = 0;
        while (i < workingSets.length) {
            IWorkingSet workingSet = workingSets[i];
            if (workingSet.isEmpty() && workingSet.isAggregateWorkingSet()) {
                return this.createWorkspaceScope(includeJRE);
            }
            this.addJavaElements(javaElements, workingSet);
            ++i;
        }
        return this.createJavaSearchScope(javaElements, includeJRE);
    }

    public IJavaSearchScope createJavaSearchScope(IWorkingSet workingSet, boolean includeJRE) {
        HashSet javaElements = new HashSet(10);
        if (workingSet.isEmpty() && workingSet.isAggregateWorkingSet()) {
            return this.createWorkspaceScope(includeJRE);
        }
        this.addJavaElements(javaElements, workingSet);
        return this.createJavaSearchScope(javaElements, includeJRE);
    }

    public IJavaSearchScope createJavaSearchScope(IResource[] resources, boolean includeJRE) {
        if (resources == null) {
            return this.EMPTY_SCOPE;
        }
        HashSet javaElements = new HashSet(resources.length);
        this.addJavaElements(javaElements, resources);
        return this.createJavaSearchScope(javaElements, includeJRE);
    }

    public IJavaSearchScope createJavaSearchScope(ISelection selection, boolean includeJRE) {
        return this.createJavaSearchScope(this.getJavaElements(selection), includeJRE);
    }

    public IJavaSearchScope createJavaProjectSearchScope(String[] projectNames, boolean includeJRE) {
        ArrayList<IJavaProject> res = new ArrayList<IJavaProject>();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < projectNames.length) {
            IJavaProject project = JavaCore.create((IProject)root.getProject(projectNames[i]));
            if (project.exists()) {
                res.add(project);
            }
            ++i;
        }
        return this.createJavaSearchScope(res, includeJRE);
    }

    public IJavaSearchScope createJavaProjectSearchScope(IJavaProject project, boolean includeJRE) {
        return SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{project}, (int)JavaSearchScopeFactory.getSearchFlags(includeJRE));
    }

    public IJavaSearchScope createJavaProjectSearchScope(IEditorInput editorInput, boolean includeJRE) {
        IJavaProject project;
        IJavaElement elem = JavaUI.getEditorInputJavaElement(editorInput);
        if (elem != null && (project = elem.getJavaProject()) != null) {
            return this.createJavaProjectSearchScope(project, includeJRE);
        }
        return this.EMPTY_SCOPE;
    }

    public String getWorkspaceScopeDescription(boolean includeJRE) {
        return includeJRE ? SearchMessages.WorkspaceScope : SearchMessages.WorkspaceScopeNoJRE;
    }

    public String getProjectScopeDescription(String[] projectNames, boolean includeJRE) {
        String scopeDescription;
        if (projectNames.length == 0) {
            return SearchMessages.JavaSearchScopeFactory_undefined_projects;
        }
        if (projectNames.length == 1) {
            String label = includeJRE ? SearchMessages.EnclosingProjectScope : SearchMessages.EnclosingProjectScopeNoJRE;
            scopeDescription = Messages.format(label, projectNames[0]);
        } else if (projectNames.length == 2) {
            String label = includeJRE ? SearchMessages.EnclosingProjectsScope2 : SearchMessages.EnclosingProjectsScope2NoJRE;
            scopeDescription = Messages.format(label, new String[]{projectNames[0], projectNames[1]});
        } else {
            String label = includeJRE ? SearchMessages.EnclosingProjectsScope : SearchMessages.EnclosingProjectsScopeNoJRE;
            scopeDescription = Messages.format(label, new String[]{projectNames[0], projectNames[1]});
        }
        return scopeDescription;
    }

    public String getProjectScopeDescription(IJavaProject project, boolean includeJRE) {
        if (includeJRE) {
            return Messages.format(SearchMessages.ProjectScope, project.getElementName());
        }
        return Messages.format(SearchMessages.ProjectScopeNoJRE, project.getElementName());
    }

    public String getProjectScopeDescription(IEditorInput editorInput, boolean includeJRE) {
        IJavaProject project;
        IJavaElement elem = JavaUI.getEditorInputJavaElement(editorInput);
        if (elem != null && (project = elem.getJavaProject()) != null) {
            return this.getProjectScopeDescription(project, includeJRE);
        }
        return Messages.format(SearchMessages.ProjectScope, "");
    }

    public String getHierarchyScopeDescription(IType type) {
        return Messages.format(SearchMessages.HierarchyScope, new String[]{type.getElementName()});
    }

    public String getSelectionScopeDescription(IJavaElement[] javaElements, boolean includeJRE) {
        String scopeDescription;
        if (javaElements.length == 0) {
            return SearchMessages.JavaSearchScopeFactory_undefined_selection;
        }
        if (javaElements.length == 1) {
            String label = includeJRE ? SearchMessages.SingleSelectionScope : SearchMessages.SingleSelectionScopeNoJRE;
            scopeDescription = Messages.format(label, javaElements[0].getElementName());
        } else if (javaElements.length == 1) {
            String label = includeJRE ? SearchMessages.DoubleSelectionScope : SearchMessages.DoubleSelectionScopeNoJRE;
            scopeDescription = Messages.format(label, new String[]{javaElements[0].getElementName(), javaElements[1].getElementName()});
        } else {
            String label = includeJRE ? SearchMessages.SelectionScope : SearchMessages.SelectionScopeNoJRE;
            scopeDescription = Messages.format(label, new String[]{javaElements[0].getElementName(), javaElements[1].getElementName()});
        }
        return scopeDescription;
    }

    public String getWorkingSetScopeDescription(IWorkingSet[] workingSets, boolean includeJRE) {
        if (workingSets.length == 0) {
            return SearchMessages.JavaSearchScopeFactory_undefined_workingsets;
        }
        if (workingSets.length == 1) {
            String label = includeJRE ? SearchMessages.SingleWorkingSetScope : SearchMessages.SingleWorkingSetScopeNoJRE;
            return Messages.format(label, workingSets[0].getLabel());
        }
        Arrays.sort(workingSets, new WorkingSetComparator());
        if (workingSets.length == 2) {
            String label = includeJRE ? SearchMessages.DoubleWorkingSetScope : SearchMessages.DoubleWorkingSetScopeNoJRE;
            return Messages.format(label, new String[]{workingSets[0].getLabel(), workingSets[1].getLabel()});
        }
        String label = includeJRE ? SearchMessages.WorkingSetsScope : SearchMessages.WorkingSetsScopeNoJRE;
        return Messages.format(label, new String[]{workingSets[0].getLabel(), workingSets[1].getLabel()});
    }

    public IProject[] getProjects(IJavaSearchScope scope) {
        IPath[] paths = scope.enclosingProjectsAndJars();
        HashSet<IResource> temp = new HashSet<IResource>();
        int i = 0;
        while (i < paths.length) {
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(paths[i]);
            if (resource != null && resource.getType() == 4) {
                temp.add(resource);
            }
            ++i;
        }
        return temp.toArray(new IProject[temp.size()]);
    }

    public IJavaElement[] getJavaElements(ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            return this.getJavaElements(((IStructuredSelection)selection).toArray());
        }
        return new IJavaElement[0];
    }

    private IJavaElement[] getJavaElements(Object[] elements) {
        if (elements.length == 0) {
            return new IJavaElement[0];
        }
        HashSet result = new HashSet(elements.length);
        int i = 0;
        while (i < elements.length) {
            Object selectedElement = elements[i];
            if (selectedElement instanceof IJavaElement) {
                this.addJavaElements(result, (IJavaElement)selectedElement);
            } else if (selectedElement instanceof IResource) {
                this.addJavaElements(result, (IResource)selectedElement);
            } else if (selectedElement instanceof LogicalPackage) {
                this.addJavaElements(result, (LogicalPackage)((Object)selectedElement));
            } else if (selectedElement instanceof IWorkingSet) {
                IWorkingSet ws = (IWorkingSet)selectedElement;
                this.addJavaElements(result, ws);
            } else if (selectedElement instanceof IAdaptable) {
                IResource resource;
                IAdaptable iAdaptable = (IAdaptable)selectedElement;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((resource = (IResource)iAdaptable.getAdapter((Class)clazz)) != null) {
                    this.addJavaElements(result, resource);
                }
            }
            ++i;
        }
        return result.toArray(new IJavaElement[result.size()]);
    }

    public IJavaSearchScope createJavaSearchScope(IJavaElement[] javaElements, boolean includeJRE) {
        if (javaElements.length == 0) {
            return this.EMPTY_SCOPE;
        }
        return SearchEngine.createJavaSearchScope((IJavaElement[])javaElements, (int)JavaSearchScopeFactory.getSearchFlags(includeJRE));
    }

    private IJavaSearchScope createJavaSearchScope(Collection javaElements, boolean includeJRE) {
        if (javaElements.isEmpty()) {
            return this.EMPTY_SCOPE;
        }
        IJavaElement[] elementArray = javaElements.toArray(new IJavaElement[javaElements.size()]);
        return SearchEngine.createJavaSearchScope((IJavaElement[])elementArray, (int)JavaSearchScopeFactory.getSearchFlags(includeJRE));
    }

    private static int getSearchFlags(boolean includeJRE) {
        int flags = 3;
        if (includeJRE) {
            flags |= 4;
        }
        return flags;
    }

    private void addJavaElements(Set javaElements, IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            this.addJavaElements(javaElements, resources[i]);
            ++i;
        }
    }

    private void addJavaElements(Set javaElements, IResource resource) {
        IJavaElement javaElement;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jdt.core.IJavaElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((javaElement = (IJavaElement)resource.getAdapter((Class)clazz)) == null) {
            return;
        }
        if (javaElement.getElementType() == 4) {
            try {
                this.addJavaElements(javaElements, ((IFolder)resource).members());
            }
            catch (CoreException coreException) {}
        }
        javaElements.add(javaElement);
    }

    private void addJavaElements(Set javaElements, IJavaElement javaElement) {
        javaElements.add(javaElement);
    }

    private void addJavaElements(Set javaElements, IWorkingSet workingSet) {
        if (workingSet == null) {
            return;
        }
        if (workingSet.isAggregateWorkingSet() && workingSet.isEmpty()) {
            try {
                IJavaProject[] projects = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
                javaElements.addAll(Arrays.asList(projects));
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
            return;
        }
        IAdaptable[] elements = workingSet.getElements();
        int i = 0;
        while (i < elements.length) {
            IJavaElement javaElement;
            IAdaptable iAdaptable = elements[i];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.jdt.core.IJavaElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((javaElement = (IJavaElement)iAdaptable.getAdapter((Class)clazz)) != null) {
                this.addJavaElements(javaElements, javaElement);
            } else {
                IResource resource;
                IAdaptable iAdaptable2 = elements[i];
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((resource = (IResource)iAdaptable2.getAdapter((Class)clazz2)) != null) {
                    this.addJavaElements(javaElements, resource);
                }
            }
            ++i;
        }
    }

    public void addJavaElements(Set javaElements, LogicalPackage selectedElement) {
        IPackageFragment[] packages = selectedElement.getFragments();
        int i = 0;
        while (i < packages.length) {
            this.addJavaElements(javaElements, (IJavaElement)packages[i]);
            ++i;
        }
    }

    public IJavaSearchScope createWorkspaceScope(boolean includeJRE) {
        if (!includeJRE) {
            try {
                IJavaProject[] projects = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
                return SearchEngine.createJavaSearchScope((IJavaElement[])projects, (int)JavaSearchScopeFactory.getSearchFlags(includeJRE));
            }
            catch (JavaModelException javaModelException) {}
        }
        return SearchEngine.createWorkspaceScope();
    }

    public boolean isInsideJRE(IJavaElement element) {
        IPackageFragmentRoot root = (IPackageFragmentRoot)element.getAncestor(3);
        if (root != null) {
            try {
                IClasspathEntry entry = root.getRawClasspathEntry();
                if (entry.getEntryKind() == 5) {
                    IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)root.getJavaProject());
                    return container != null && container.getKind() == 3;
                }
                return false;
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        return true;
    }
}

