/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.text.java;

import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.template.java.SignatureUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.text.java.JavaTextMessages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Assert;

public class CompletionProposalLabelProvider {
    private CompletionContext fContext;

    public String createParameterList(CompletionProposal methodProposal) {
        Assert.isTrue((methodProposal.getKind() == 6 ? 1 : 0) != 0);
        return this.appendUnboundedParameterList(new StringBuffer(), methodProposal).toString();
    }

    private StringBuffer appendUnboundedParameterList(StringBuffer buffer, CompletionProposal methodProposal) {
        char[] signature = SignatureUtil.fix83600(methodProposal.getSignature());
        char[][] parameterNames = methodProposal.findParameterNames(null);
        char[][] parameterTypes = Signature.getParameterTypes((char[])signature);
        int i = 0;
        while (i < parameterTypes.length) {
            parameterTypes[i] = this.createTypeDisplayName(SignatureUtil.getLowerBound(parameterTypes[i]));
            ++i;
        }
        return this.appendParameterSignature(buffer, parameterTypes, parameterNames);
    }

    private char[] createTypeDisplayName(char[] typeSignature) throws IllegalArgumentException {
        char[] displayName = Signature.getSimpleName((char[])Signature.toCharArray((char[])typeSignature));
        boolean useShortGenerics = false;
        if (useShortGenerics) {
            int pos;
            StringBuffer buf = new StringBuffer();
            buf.append(displayName);
            do {
                if ((pos = buf.indexOf("? extends ")) >= 0) {
                    buf.replace(pos, pos + 10, "+");
                    continue;
                }
                pos = buf.indexOf("? super ");
                if (pos < 0) continue;
                buf.replace(pos, pos + 8, "-");
            } while (pos >= 0);
            return buf.toString().toCharArray();
        }
        return displayName;
    }

    private final StringBuffer appendParameterSignature(StringBuffer buffer, char[][] parameterTypes, char[][] parameterNames) {
        if (parameterTypes != null) {
            int i = 0;
            while (i < parameterTypes.length) {
                if (i > 0) {
                    buffer.append(',');
                    buffer.append(' ');
                }
                buffer.append(parameterTypes[i]);
                if (parameterNames != null && parameterNames[i] != null) {
                    buffer.append(' ');
                    buffer.append(parameterNames[i]);
                }
                ++i;
            }
        }
        return buffer;
    }

    String createMethodProposalLabel(CompletionProposal methodProposal) {
        StringBuffer nameBuffer = new StringBuffer();
        nameBuffer.append(methodProposal.getName());
        nameBuffer.append('(');
        this.appendUnboundedParameterList(nameBuffer, methodProposal);
        nameBuffer.append(')');
        if (!methodProposal.isConstructor()) {
            char[] returnType = this.createTypeDisplayName(SignatureUtil.getUpperBound(Signature.getReturnType((char[])SignatureUtil.fix83600(methodProposal.getSignature()))));
            nameBuffer.append("  ");
            nameBuffer.append(returnType);
        }
        nameBuffer.append(" - ");
        String declaringType = this.extractDeclaringTypeFQN(methodProposal);
        declaringType = Signature.getSimpleName((String)declaringType);
        nameBuffer.append(declaringType);
        return nameBuffer.toString();
    }

    String createJavadocMethodProposalLabel(CompletionProposal methodProposal) {
        StringBuffer nameBuffer = new StringBuffer();
        nameBuffer.append(methodProposal.getCompletion());
        nameBuffer.append(" - ");
        String declaringType = this.extractDeclaringTypeFQN(methodProposal);
        declaringType = Signature.getSimpleName((String)declaringType);
        nameBuffer.append(declaringType);
        return nameBuffer.toString();
    }

    String createOverrideMethodProposalLabel(CompletionProposal methodProposal) {
        StringBuffer nameBuffer = new StringBuffer();
        nameBuffer.append(methodProposal.getName());
        nameBuffer.append('(');
        this.appendUnboundedParameterList(nameBuffer, methodProposal);
        nameBuffer.append(")  ");
        char[] returnType = this.createTypeDisplayName(SignatureUtil.getUpperBound(Signature.getReturnType((char[])SignatureUtil.fix83600(methodProposal.getSignature()))));
        nameBuffer.append(returnType);
        nameBuffer.append(" - ");
        String declaringType = this.extractDeclaringTypeFQN(methodProposal);
        declaringType = Signature.getSimpleName((String)declaringType);
        nameBuffer.append(Messages.format(JavaTextMessages.ResultCollector_overridingmethod, new String(declaringType)));
        return nameBuffer.toString();
    }

    private String extractDeclaringTypeFQN(CompletionProposal methodProposal) {
        char[] declaringTypeSignature = methodProposal.getDeclarationSignature();
        if (declaringTypeSignature == null) {
            return "java.lang.Object";
        }
        return SignatureUtil.stripSignatureToFQN(String.valueOf(declaringTypeSignature));
    }

    String createTypeProposalLabel(CompletionProposal typeProposal) {
        char[] signature = this.fContext != null && this.fContext.isInJavadoc() ? Signature.getTypeErasure((char[])typeProposal.getSignature()) : typeProposal.getSignature();
        char[] fullName = Signature.toCharArray((char[])signature);
        return this.createTypeProposalLabel(fullName);
    }

    String createJavadocTypeProposalLabel(CompletionProposal typeProposal) {
        char[] fullName = Signature.toCharArray((char[])typeProposal.getSignature());
        return this.createJavadocTypeProposalLabel(fullName);
    }

    String createJavadocSimpleProposalLabel(CompletionProposal proposal) {
        return this.createSimpleLabel(proposal);
    }

    String createTypeProposalLabel(char[] fullName) {
        int qIndex = this.findSimpleNameStart(fullName);
        StringBuffer buf = new StringBuffer();
        buf.append(fullName, qIndex, fullName.length - qIndex);
        if (qIndex > 0) {
            buf.append(JavaElementLabels.CONCAT_STRING);
            buf.append(fullName, 0, qIndex - 1);
        }
        return buf.toString();
    }

    String createJavadocTypeProposalLabel(char[] fullName) {
        int qIndex = this.findSimpleNameStart(fullName);
        StringBuffer buf = new StringBuffer("{@link ");
        buf.append(fullName, qIndex, fullName.length - qIndex);
        buf.append('}');
        if (qIndex > 0) {
            buf.append(JavaElementLabels.CONCAT_STRING);
            buf.append(fullName, 0, qIndex - 1);
        }
        return buf.toString();
    }

    private int findSimpleNameStart(char[] array) {
        int lastDot = 0;
        int i = 0;
        int len = array.length;
        while (i < len) {
            char ch = array[i];
            if (ch == '<') {
                return lastDot;
            }
            if (ch == '.') {
                lastDot = i + 1;
            }
            ++i;
        }
        return lastDot;
    }

    String createSimpleLabelWithType(CompletionProposal proposal) {
        StringBuffer buf = new StringBuffer();
        buf.append(proposal.getCompletion());
        char[] typeName = Signature.getSignatureSimpleName((char[])proposal.getSignature());
        if (typeName.length > 0) {
            buf.append("    ");
            buf.append(typeName);
        }
        return buf.toString();
    }

    String createLabelWithTypeAndDeclaration(CompletionProposal proposal) {
        char[] declaration;
        StringBuffer buf = new StringBuffer();
        buf.append(proposal.getCompletion());
        char[] typeName = Signature.getSignatureSimpleName((char[])proposal.getSignature());
        if (typeName.length > 0) {
            buf.append("    ");
            buf.append(typeName);
        }
        if ((declaration = proposal.getDeclarationSignature()) != null && (declaration = Signature.getSignatureSimpleName((char[])declaration)).length > 0) {
            buf.append(" - ");
            buf.append(declaration);
        }
        return buf.toString();
    }

    String createPackageProposalLabel(CompletionProposal proposal) {
        Assert.isTrue((proposal.getKind() == 8 ? 1 : 0) != 0);
        return String.valueOf(proposal.getDeclarationSignature());
    }

    String createSimpleLabel(CompletionProposal proposal) {
        return String.valueOf(proposal.getCompletion());
    }

    String createAnonymousTypeLabel(CompletionProposal proposal) {
        char[] declaringTypeSignature = proposal.getDeclarationSignature();
        StringBuffer buffer = new StringBuffer();
        buffer.append(Signature.getSignatureSimpleName((char[])declaringTypeSignature));
        buffer.append('(');
        this.appendUnboundedParameterList(buffer, proposal);
        buffer.append(')');
        buffer.append("  ");
        buffer.append(JavaTextMessages.ResultCollector_anonymous_type);
        return buffer.toString();
    }

    public String createLabel(CompletionProposal proposal) {
        switch (proposal.getKind()) {
            case 6: 
            case 11: 
            case 12: {
                if (this.fContext != null && this.fContext.isInJavadoc()) {
                    return this.createJavadocMethodProposalLabel(proposal);
                }
                return this.createMethodProposalLabel(proposal);
            }
            case 7: {
                return this.createOverrideMethodProposalLabel(proposal);
            }
            case 1: {
                return this.createAnonymousTypeLabel(proposal);
            }
            case 9: {
                return this.createTypeProposalLabel(proposal);
            }
            case 16: {
                return this.createJavadocTypeProposalLabel(proposal);
            }
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                return this.createJavadocSimpleProposalLabel(proposal);
            }
            case 15: {
                return this.createJavadocMethodProposalLabel(proposal);
            }
            case 8: {
                return this.createPackageProposalLabel(proposal);
            }
            case 2: 
            case 13: {
                return this.createLabelWithTypeAndDeclaration(proposal);
            }
            case 5: 
            case 10: {
                return this.createSimpleLabelWithType(proposal);
            }
            case 3: 
            case 4: {
                return this.createSimpleLabel(proposal);
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public ImageDescriptor createImageDescriptor(CompletionProposal proposal) {
        ImageDescriptor descriptor;
        int flags = proposal.getFlags();
        block0 : switch (proposal.getKind()) {
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                descriptor = JavaElementImageProvider.getMethodImageDescriptor(false, flags);
                break;
            }
            case 1: 
            case 9: {
                switch (Signature.getTypeSignatureKind((char[])proposal.getSignature())) {
                    case 1: {
                        descriptor = JavaElementImageProvider.getTypeImageDescriptor(false, false, flags, false);
                        break block0;
                    }
                    case 3: {
                        descriptor = JavaPluginImages.DESC_OBJS_TYPEVARIABLE;
                        break block0;
                    }
                }
                descriptor = null;
                break;
            }
            case 2: {
                descriptor = JavaElementImageProvider.getFieldImageDescriptor(false, flags);
                break;
            }
            case 5: 
            case 10: {
                descriptor = JavaPluginImages.DESC_OBJS_LOCAL_VARIABLE;
                break;
            }
            case 8: {
                descriptor = JavaPluginImages.DESC_OBJS_PACKAGE;
                break;
            }
            case 3: 
            case 4: {
                descriptor = null;
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                descriptor = JavaPluginImages.DESC_OBJS_JAVADOCTAG;
                break;
            }
            default: {
                descriptor = null;
                Assert.isTrue((boolean)false);
            }
        }
        if (descriptor == null) {
            return null;
        }
        return this.decorateImageDescriptor(descriptor, proposal);
    }

    ImageDescriptor createMethodImageDescriptor(CompletionProposal proposal) {
        int flags = proposal.getFlags();
        return this.decorateImageDescriptor(JavaElementImageProvider.getMethodImageDescriptor(false, flags), proposal);
    }

    ImageDescriptor createTypeImageDescriptor(CompletionProposal proposal) {
        int flags = proposal.getFlags();
        boolean isInterfaceOrAnnotation = Flags.isInterface((int)flags) || Flags.isAnnotation((int)flags);
        return this.decorateImageDescriptor(JavaElementImageProvider.getTypeImageDescriptor(true, isInterfaceOrAnnotation, flags, false), proposal);
    }

    ImageDescriptor createFieldImageDescriptor(CompletionProposal proposal) {
        int flags = proposal.getFlags();
        return this.decorateImageDescriptor(JavaElementImageProvider.getFieldImageDescriptor(false, flags), proposal);
    }

    ImageDescriptor createLocalImageDescriptor(CompletionProposal proposal) {
        return this.decorateImageDescriptor(JavaPluginImages.DESC_OBJS_LOCAL_VARIABLE, proposal);
    }

    ImageDescriptor createPackageImageDescriptor(CompletionProposal proposal) {
        return this.decorateImageDescriptor(JavaPluginImages.DESC_OBJS_PACKAGE, proposal);
    }

    private ImageDescriptor decorateImageDescriptor(ImageDescriptor descriptor, CompletionProposal proposal) {
        int adornments = 0;
        int flags = proposal.getFlags();
        int kind = proposal.getKind();
        if (Flags.isDeprecated((int)flags)) {
            adornments |= 0x400;
        }
        if ((kind == 2 || kind == 7 || kind == 7 || kind == 12 || kind == 6) && Flags.isStatic((int)flags)) {
            adornments |= 8;
        }
        if ((kind == 7 || kind == 7 || kind == 12 || kind == 6) && Flags.isSynchronized((int)flags)) {
            adornments |= 4;
        }
        if (kind == 9 && Flags.isAbstract((int)flags) && !Flags.isInterface((int)flags)) {
            adornments |= 1;
        }
        return new JavaElementImageDescriptor(descriptor, adornments, JavaElementImageProvider.SMALL_SIZE);
    }

    void setContext(CompletionContext context) {
        this.fContext = context;
    }
}

