/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentExtension;
import org.eclipse.ui.navigator.ICommonLabelProvider;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;

public class NavigatorContentServiceLabelProvider
extends EventManager
implements ILabelProvider,
IColorProvider,
IFontProvider,
ITreePathLabelProvider,
ILabelProviderListener {
    private final NavigatorContentService contentService;
    private final boolean isContentServiceSelfManaged;

    public NavigatorContentServiceLabelProvider(NavigatorContentService aContentService) {
        this.contentService = aContentService;
        this.isContentServiceSelfManaged = false;
    }

    public Image getImage(Object anElement) {
        Set contentExtensions = this.contentService.findContentExtensionsWithPossibleChild(anElement);
        Image image = null;
        Iterator itr = contentExtensions.iterator();
        while (itr.hasNext() && image == null) {
            image = this.findImage((NavigatorContentExtension)itr.next(), anElement);
        }
        return image;
    }

    public String getText(Object anElement) {
        Set contentExtensions = this.contentService.findContentExtensionsWithPossibleChild(anElement);
        String text = null;
        Iterator itr = contentExtensions.iterator();
        while (itr.hasNext() && text == null) {
            text = this.findText((NavigatorContentExtension)itr.next(), anElement);
        }
        return text == null ? "Null Label" : text;
    }

    private String findText(NavigatorContentExtension foundExtension, Object anElement) {
        INavigatorContentDescriptor foundDescriptor;
        String text = null;
        text = foundExtension.getLabelProvider().getText(anElement);
        if (text == null && (foundDescriptor = foundExtension.getDescriptor()).getOverriddenDescriptor() != null) {
            return this.findText(this.contentService.getExtension(foundDescriptor.getOverriddenDescriptor()), anElement);
        }
        return text;
    }

    private Image findImage(NavigatorContentExtension foundExtension, Object anElement) {
        INavigatorContentDescriptor foundDescriptor;
        Image image = null;
        image = foundExtension.getLabelProvider().getImage(anElement);
        if (image == null && (foundDescriptor = foundExtension.getDescriptor()).getOverriddenDescriptor() != null) {
            return this.findImage(this.contentService.getExtension(foundDescriptor.getOverriddenDescriptor()), anElement);
        }
        return image;
    }

    public Font getFont(Object anElement) {
        ILabelProvider[] labelProviders = this.contentService.findRelevantLabelProviders(anElement);
        int i = 0;
        while (i < labelProviders.length) {
            IFontProvider fontProvider;
            Font font;
            ILabelProvider provider = labelProviders[i];
            if (provider instanceof IFontProvider && (font = (fontProvider = (IFontProvider)provider).getFont(anElement)) != null) {
                return font;
            }
            ++i;
        }
        return null;
    }

    public Color getForeground(Object anElement) {
        ILabelProvider[] labelProviders = this.contentService.findRelevantLabelProviders(anElement);
        int i = 0;
        while (i < labelProviders.length) {
            IColorProvider colorProvider;
            Color color;
            ILabelProvider provider = labelProviders[i];
            if (provider instanceof IColorProvider && (color = (colorProvider = (IColorProvider)provider).getForeground(anElement)) != null) {
                return color;
            }
            ++i;
        }
        return null;
    }

    public Color getBackground(Object anElement) {
        ILabelProvider[] labelProviders = this.contentService.findRelevantLabelProviders(anElement);
        int i = 0;
        while (i < labelProviders.length) {
            IColorProvider colorProvider;
            Color color;
            ILabelProvider provider = labelProviders[i];
            if (provider instanceof IColorProvider && (color = (colorProvider = (IColorProvider)provider).getBackground(anElement)) != null) {
                return color;
            }
            ++i;
        }
        return null;
    }

    public boolean isLabelProperty(Object anElement, String aProperty) {
        boolean result = false;
        ILabelProvider[] labelProviders = this.contentService.findRelevantLabelProviders(anElement);
        int i = 0;
        while (i < labelProviders.length && !result) {
            result = labelProviders[i].isLabelProperty(anElement, aProperty);
            ++i;
        }
        return result;
    }

    public void addListener(ILabelProviderListener aListener) {
        this.addListenerObject(aListener);
    }

    public void removeListener(ILabelProviderListener aListener) {
        this.removeListenerObject(aListener);
    }

    public void dispose() {
        if (this.isContentServiceSelfManaged) {
            this.contentService.dispose();
        }
    }

    protected void fireLabelProviderChanged(final LabelProviderChangedEvent event) {
        Object[] theListeners = this.getListeners();
        int i = 0;
        while (i < theListeners.length) {
            final ILabelProviderListener l = (ILabelProviderListener)theListeners[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.labelProviderChanged(event);
                }
            });
            ++i;
        }
    }

    public void updateLabel(ViewerLabel label, TreePath elementPath) {
        Set contentExtensions = this.contentService.findContentExtensionsWithPossibleChild(elementPath.getLastSegment());
        Iterator itr = contentExtensions.iterator();
        while (itr.hasNext() && !label.hasNewText() && label.getText() != null) {
            this.findUpdateLabel((NavigatorContentExtension)itr.next(), label, elementPath);
        }
        if (label.getText() == null) {
            label.setText("");
        }
    }

    private String findUpdateLabel(NavigatorContentExtension foundExtension, ViewerLabel label, TreePath elementPath) {
        String text = null;
        ICommonLabelProvider labelProvider = foundExtension.getLabelProvider();
        if (labelProvider instanceof ITreePathLabelProvider) {
            ITreePathLabelProvider tplp = (ITreePathLabelProvider)labelProvider;
            tplp.updateLabel(label, elementPath);
        } else {
            label.setImage(labelProvider.getImage(elementPath.getLastSegment()));
            label.setText(labelProvider.getText(elementPath.getLastSegment()));
        }
        if (this.shouldContinue(label, foundExtension)) {
            return this.findUpdateLabel(this.contentService.getExtension(foundExtension.getDescriptor().getOverriddenDescriptor().getOverriddenDescriptor()), label, elementPath);
        }
        return text;
    }

    private boolean shouldContinue(ViewerLabel label, NavigatorContentExtension foundExtension) {
        if (foundExtension.getDescriptor().getOverriddenDescriptor() != null) {
            if (label.getText() == null || label.getText().length() == 0) {
                return true;
            }
            if (label.hasNewText()) {
                return false;
            }
        }
        return false;
    }

    public void labelProviderChanged(LabelProviderChangedEvent event) {
        this.fireLabelProviderChanged(event);
    }
}

