/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.runtime.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentType;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;
import org.eclipse.wst.common.project.facet.core.runtime.internal.RuntimeComponentVersion;

public final class RuntimeComponent
implements IRuntimeComponent {
    private RuntimeComponentVersion rcv;
    private final Map properties = new HashMap();
    private final Map propertiesReadOnly = Collections.unmodifiableMap(this.properties);

    RuntimeComponent() {
    }

    public IRuntimeComponentType getRuntimeComponentType() {
        return this.rcv.getRuntimeComponentType();
    }

    public IRuntimeComponentVersion getRuntimeComponentVersion() {
        return this.rcv;
    }

    void setRuntimeComponentVersion(IRuntimeComponentVersion rcv) {
        this.rcv = (RuntimeComponentVersion)rcv;
    }

    public Map getProperties() {
        return this.propertiesReadOnly;
    }

    public String getProperty(String key) {
        return (String)this.properties.get(key);
    }

    void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public Object getAdapter(Class type) {
        IAdapterManager manager = Platform.getAdapterManager();
        Object res = manager.loadAdapter((Object)this, type.getName());
        if (res == null) {
            IAdapterFactory factory = null;
            try {
                factory = this.rcv.getAdapterFactory(type);
            }
            catch (CoreException e) {
                FacetCorePlugin.log((Exception)((Object)e));
            }
            if (factory != null) {
                res = factory.getAdapter((Object)this, type);
            }
        }
        return res;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RuntimeComponent) {
            RuntimeComponent rc = (RuntimeComponent)obj;
            return this.rcv == rc.rcv && this.properties.equals(rc.properties);
        }
        return false;
    }

    public int hashCode() {
        return this.rcv.hashCode();
    }

    public String toString() {
        return this.rcv.toString();
    }
}

