/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.documentModel;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.php.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public class PHPFileVisitor
implements IResourceProxyVisitor {
    protected List fFiles = new ArrayList();
    protected IReporter fReporter = null;

    public PHPFileVisitor(IReporter iReporter) {
        this.fReporter = iReporter;
    }

    public boolean visit(IResourceProxy iResourceProxy) throws CoreException {
        IFile iFile;
        if (this.fReporter.isCancelled()) {
            return false;
        }
        if (iResourceProxy.getType() == 1 && (iFile = (IFile)iResourceProxy.requestResource()).exists() && this.canHandle(iFile)) {
            this.fFiles.add(iFile);
            return false;
        }
        return true;
    }

    protected boolean canHandle(IFile iFile) {
        boolean bl = false;
        if (iFile != null) {
            try {
                IContentTypeManager iContentTypeManager = Platform.getContentTypeManager();
                IContentDescription iContentDescription = iFile.getContentDescription();
                IContentType iContentType = iContentTypeManager.getContentType(ContentTypeIdForPHP.ContentTypeID_PHP);
                if (iContentDescription != null) {
                    IContentType iContentType2 = iContentDescription.getContentType();
                    if (iContentType != null && iContentType2.isKindOf(iContentType)) {
                        bl = true;
                    }
                } else if (iContentType != null) {
                    bl = iContentType.isAssociatedWith(iFile.getName());
                }
            }
            catch (CoreException coreException) {}
        }
        return bl;
    }

    public final IFile[] getFiles() {
        return this.fFiles.toArray(new IFile[this.fFiles.size()]);
    }
}

