/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import java.util.Date;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.ccvs.ui.CVSHistoryFilter;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.ui.PlatformUI;

public class CVSHistoryFilterDialog
extends TrayDialog {
    private CVSHistoryFilter historyFilter;
    private Button orRadio;
    private Button andRadio;
    private Combo fromDayCombo;
    private Combo toDayCombo;
    private Combo fromMonthCombo;
    private Combo toMonthCombo;
    private Combo fromYearCombo;
    private Combo toYearCombo;
    private Text author;
    private Text comment;

    public CVSHistoryFilterDialog(Shell shell) {
        super(shell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(CVSUIMessages.HistoryFilterDialog_title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite topLevel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        topLevel.setLayout((Layout)layout);
        Label label = new Label(topLevel, 0);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setText(CVSUIMessages.HistoryFilterDialog_showMatching);
        this.andRadio = new Button(topLevel, 16);
        this.andRadio.setText(CVSUIMessages.HistoryFilterDialog_matchingAll);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.andRadio.setLayoutData((Object)data);
        this.andRadio.setSelection(true);
        this.orRadio = new Button(topLevel, 16);
        this.orRadio.setText(CVSUIMessages.HistoryFilterDialog_matchingAny);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.orRadio.setLayoutData((Object)data);
        label = new Label(topLevel, 0);
        label.setText(CVSUIMessages.HistoryFilterDialog_author);
        this.author = new Text(topLevel, 2048);
        this.author.setLayoutData((Object)new GridData(768));
        label = new Label(topLevel, 0);
        label.setText(CVSUIMessages.HistoryFilterDialog_comment);
        this.comment = new Text(topLevel, 2048);
        this.comment.setLayoutData((Object)new GridData(768));
        label = new Label(topLevel, 0);
        label.setText(CVSUIMessages.HistoryFilterDialog_fromDate);
        Composite fdComposite = new Composite(topLevel, 0);
        GridLayout fdLayout = new GridLayout();
        fdLayout.numColumns = 3;
        fdComposite.setLayout((Layout)fdLayout);
        this.fromMonthCombo = new Combo(fdComposite, 8);
        this.fromDayCombo = new Combo(fdComposite, 8);
        this.fromYearCombo = new Combo(fdComposite, 0);
        this.fromYearCombo.setTextLimit(4);
        label = new Label(topLevel, 0);
        label.setText(CVSUIMessages.HistoryFilterDialog_toDate);
        Composite tdComposite = new Composite(topLevel, 0);
        GridLayout tdLayout = new GridLayout();
        tdLayout.numColumns = 3;
        tdComposite.setLayout((Layout)tdLayout);
        this.toMonthCombo = new Combo(tdComposite, 8);
        this.toDayCombo = new Combo(tdComposite, 8);
        this.toYearCombo = new Combo(tdComposite, 0);
        this.toYearCombo.setTextLimit(4);
        String[] days = new String[32];
        days[0] = "---";
        int i = 1;
        while (i < 32) {
            days[i] = String.valueOf(i);
            ++i;
        }
        String[] months = new String[13];
        months[0] = "---";
        SimpleDateFormat format = new SimpleDateFormat("MMMM");
        Calendar calendar = Calendar.getInstance();
        int i2 = 1;
        while (i2 < 13) {
            calendar.set(2, i2 - 1);
            months[i2] = format.format(calendar.getTime());
            ++i2;
        }
        String[] years = new String[5];
        Calendar calender = Calendar.getInstance();
        int i3 = 0;
        while (i3 < 5) {
            years[i3] = String.valueOf(calender.get(1) - i3);
            ++i3;
        }
        this.fromDayCombo.setItems(days);
        this.fromDayCombo.select(0);
        this.toDayCombo.setItems(days);
        this.toDayCombo.select(0);
        this.fromMonthCombo.setItems(months);
        this.fromMonthCombo.select(0);
        this.toMonthCombo.setItems(months);
        this.toMonthCombo.select(0);
        this.fromYearCombo.setItems(years);
        this.toYearCombo.setItems(years);
        this.fromYearCombo.select(0);
        this.toYearCombo.select(0);
        this.initializeValues();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)topLevel, "org.eclipse.team.cvs.ui.history_filter_dialog_context");
        Dialog.applyDialogFont((Control)parent);
        return topLevel;
    }

    void initializeValues() {
        int index;
        String yearValue;
        if (this.historyFilter == null) {
            return;
        }
        if (this.historyFilter.author != null) {
            this.author.setText(this.historyFilter.author);
        }
        if (this.historyFilter.comment != null) {
            this.comment.setText(this.historyFilter.comment);
        }
        this.orRadio.setSelection(this.historyFilter.isOr);
        this.andRadio.setSelection(!this.historyFilter.isOr);
        Calendar calendar = Calendar.getInstance();
        if (this.historyFilter.fromDate != null) {
            calendar.setTime(this.historyFilter.fromDate);
            this.fromDayCombo.select(calendar.get(5));
            this.fromMonthCombo.select(calendar.get(2) + 1);
            yearValue = String.valueOf(calendar.get(1));
            index = this.fromYearCombo.indexOf(yearValue);
            if (index == -1) {
                this.fromYearCombo.add(yearValue);
                index = this.fromYearCombo.indexOf(yearValue);
            }
            this.fromYearCombo.select(index);
        }
        if (this.historyFilter.toDate != null) {
            calendar.setTime(this.historyFilter.toDate);
            this.toDayCombo.select(calendar.get(5));
            this.toMonthCombo.select(calendar.get(2) + 1);
            yearValue = String.valueOf(calendar.get(1));
            index = this.toYearCombo.indexOf(yearValue);
            if (index == -1) {
                this.toYearCombo.add(yearValue);
                index = this.toYearCombo.indexOf(yearValue);
            }
            this.toYearCombo.select(index);
        }
    }

    protected void buttonPressed(int buttonId) {
        boolean toSet;
        if (1 == buttonId) {
            super.buttonPressed(buttonId);
            return;
        }
        Date fromDate = null;
        Date toDate = null;
        boolean fromSet = this.fromDayCombo.getSelectionIndex() > 0 && this.fromMonthCombo.getSelectionIndex() > 0;
        boolean bl = toSet = this.toDayCombo.getSelectionIndex() > 0 && this.toMonthCombo.getText().length() > 0;
        if (fromSet || toSet) {
            Calendar calendar = Calendar.getInstance();
            fromDate = this.getFromDate(calendar, fromSet);
            toDate = this.getToDate(calendar, toSet);
        }
        this.historyFilter = new CVSHistoryFilter(this.author.getText(), this.comment.getText(), fromDate, toDate, this.orRadio.getSelection());
        super.buttonPressed(buttonId);
    }

    private Date getFromDate(Calendar calendar, boolean fromSet) {
        if (fromSet) {
            calendar.set(1, Integer.parseInt(String.valueOf(this.fromYearCombo.getText())));
            calendar.set(2, this.fromMonthCombo.getSelectionIndex() - 1);
            calendar.set(5, Integer.parseInt(String.valueOf(this.fromDayCombo.getText())));
        } else {
            calendar.set(1, Integer.parseInt(String.valueOf(this.fromYearCombo.getItem(this.fromYearCombo.getItemCount() - 1))));
            calendar.set(2, 0);
            calendar.set(5, 1);
        }
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    private Date getToDate(Calendar calendar, boolean toSet) {
        if (toSet) {
            calendar.set(1, Integer.parseInt(String.valueOf(this.toYearCombo.getText())));
            calendar.set(2, this.toMonthCombo.getSelectionIndex() - 1);
            calendar.set(5, Integer.parseInt(String.valueOf(this.toDayCombo.getText())));
        } else {
            calendar.setTimeInMillis(System.currentTimeMillis());
        }
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime();
    }

    public CVSHistoryFilter getFilter() {
        return this.historyFilter;
    }

    public void setFilter(CVSHistoryFilter filter) {
        this.historyFilter = filter;
    }
}

