/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.tags;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.repo.NewDateTagAction;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryManager;
import org.eclipse.team.internal.ccvs.ui.tags.FilteredTagList;
import org.eclipse.team.internal.ccvs.ui.tags.TagElement;
import org.eclipse.team.internal.ccvs.ui.tags.TagRefreshButtonArea;
import org.eclipse.team.internal.ccvs.ui.tags.TagSource;
import org.eclipse.team.internal.ccvs.ui.tags.TagSourceWorkbenchAdapter;
import org.eclipse.team.internal.ui.PixelConverter;
import org.eclipse.team.internal.ui.SWTUtils;
import org.eclipse.team.internal.ui.actions.TeamAction;
import org.eclipse.team.internal.ui.dialogs.DialogArea;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.PageBook;

public class TagSelectionArea
extends DialogArea {
    private static int COLUMN_TRIM = "carbon".equals(SWT.getPlatform()) ? 24 : 3;
    private static int ICON_WIDTH = 40;
    public static final String SELECTED_TAG = "selectedTag";
    public static final String OPEN_SELECTED_TAG = "openSelectedTag";
    public static final int INCLUDE_HEAD_TAG = 1;
    public static final int INCLUDE_BASE_TAG = 2;
    public static final int INCLUDE_BRANCHES = 4;
    public static final int INCLUDE_VERSIONS = 8;
    public static final int INCLUDE_DATES = 16;
    public static final int INCLUDE_ALL_TAGS = 31;
    private String tagAreaLabel;
    private final int includeFlags;
    private CVSTag selection;
    private String helpContext;
    private Text filterText;
    private TagSource tagSource;
    private final Shell shell;
    private TagRefreshButtonArea tagRefreshArea;
    private final TagSource.ITagSourceChangeListener listener = new TagSource.ITagSourceChangeListener(){

        public void tagsChanged(TagSource source) {
            Shell shell = TagSelectionArea.this.getShell();
            if (!shell.isDisposed()) {
                shell.getDisplay().syncExec(new Runnable(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        1.access$0(this.this$1).refresh();
                    }
                });
            }
        }

        static /* synthetic */ TagSelectionArea access$0(1 var0) {
            return var0.TagSelectionArea.this;
        }
    };
    private final DisposeListener disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            if (TagSelectionArea.this.tagSource != null) {
                TagSelectionArea.this.tagSource.removeListener(TagSelectionArea.this.listener);
            }
        }
    };
    private PageBook switcher;
    private TreeViewer tagTree;
    private TableViewer tagTable;
    private boolean treeVisible = true;
    private boolean includeFilterInputArea = true;
    private String filterPattern = "";
    private IRunnableContext context;
    static /* synthetic */ Class class$0;

    public TagSelectionArea(Shell shell, TagSource tagSource, int includeFlags, String helpContext) {
        this.shell = shell;
        this.includeFlags = includeFlags;
        this.helpContext = helpContext;
        this.tagSource = tagSource;
        this.setSelection(null);
    }

    public void createArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Dialog.applyDialogFont((Control)parent);
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)SWTUtils.createHVFillGridData());
        composite.setLayout((Layout)SWTUtils.createGridLayout((int)1, (PixelConverter)converter, (int)0));
        if (this.helpContext != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, this.helpContext);
        }
        this.createTagDisplayArea(composite);
        this.createCustomArea(composite);
        this.createRefreshButtons(composite);
        Dialog.applyDialogFont((Control)parent);
        this.updateTagDisplay(true);
    }

    private void createTagDisplayArea(Composite parent) {
        Composite inner = this.createGrabbingComposite(parent, 1);
        if (this.isIncludeFilterInputArea()) {
            this.createFilterInput(inner);
            this.createWrappingLabel(inner, CVSUIMessages.TagSelectionArea_0, 1);
        } else {
            this.createWrappingLabel(inner, NLS.bind((String)CVSUIMessages.TagSelectionArea_1, (Object[])new String[]{this.getTagAreaLabel()}), 1);
        }
        this.switcher = new PageBook(inner, 0);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 0;
        gridData.widthHint = 0;
        this.switcher.setLayoutData((Object)gridData);
        this.tagTree = this.createTree((Composite)this.switcher);
        this.tagTable = this.createTable((Composite)this.switcher);
    }

    private void createFilterInput(Composite inner) {
        this.createWrappingLabel(inner, NLS.bind((String)CVSUIMessages.TagSelectionArea_2, (Object[])new String[]{this.getTagAreaLabel()}), 1);
        this.filterText = this.createText(inner, 1);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TagSelectionArea.this.setFilter(TagSelectionArea.this.filterText.getText());
            }
        });
        this.filterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002 && e.stateMask == 0) {
                    TagSelectionArea.this.tagTable.getControl().setFocus();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    public String getTagAreaLabel() {
        if (this.tagAreaLabel == null) {
            this.tagAreaLabel = CVSUIMessages.TagSelectionArea_3;
        }
        return this.tagAreaLabel;
    }

    public void setTagAreaLabel(String tagAreaLabel) {
        this.tagAreaLabel = tagAreaLabel;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateTagDisplay(boolean firstTime) {
        block10: {
            String filter = this.getFilterString();
            if ((filter == null || filter.length() <= 0) && !this.isTableOnly()) break block10;
            try {
                this.switcher.setRedraw(false);
                this.treeVisible = false;
                this.switcher.showPage(this.tagTable.getControl());
                FilteredTagList list = (FilteredTagList)this.tagTable.getInput();
                list.setPattern(filter);
                this.tagTable.refresh();
                int maxWidth = this.getMaxWidth(list.getChildren(null));
                if (maxWidth > 0) {
                    maxWidth = maxWidth + ICON_WIDTH + COLUMN_TRIM;
                    this.tagTable.getTable().getColumn(0).setWidth(maxWidth);
                }
                if (this.filterText == null || filter == null || filter.length() == 0) {
                    this.setSelection(this.selection);
                } else {
                    this.selectTopElement();
                }
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                this.switcher.setRedraw(true);
                throw throwable;
            }
            {
                Object var5_10 = null;
                this.switcher.setRedraw(true);
                return;
            }
        }
        if (this.isTreeVisible()) {
            if (!firstTime) return;
        }
        try {
            this.switcher.setRedraw(false);
            this.treeVisible = true;
            this.switcher.showPage(this.tagTree.getControl());
            this.tagTree.refresh();
            this.setSelection(this.selection);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.switcher.setRedraw(true);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.switcher.setRedraw(true);
    }

    private int getMaxWidth(Object[] children) {
        PixelConverter converter = new PixelConverter((Control)this.tagTable.getTable());
        int maxWidth = 0;
        int i = 0;
        while (i < children.length) {
            TagElement tag;
            int width;
            Object object = children[i];
            if (object instanceof TagElement && (width = (tag = (TagElement)object).getTag().getName().length()) > maxWidth) {
                maxWidth = width;
            }
            ++i;
        }
        return converter.convertWidthInCharsToPixels(maxWidth);
    }

    protected boolean isTableOnly() {
        return this.includeFlags == 8 || this.includeFlags == 4;
    }

    private String getFilterString() {
        return this.filterPattern;
    }

    private void selectTopElement() {
        if (this.tagTable.getTable().getItemCount() > 0) {
            TableItem item = this.tagTable.getTable().getItem(0);
            this.tagTable.getTable().setSelection(new TableItem[]{item});
            this.tagTable.setSelection(this.tagTable.getSelection());
        }
    }

    private FilteredTagList createFilteredInput() {
        return new FilteredTagList(this.tagSource, TagSource.convertIncludeFlaqsToTagTypes(this.includeFlags));
    }

    private Text createText(Composite parent, int horizontalSpan) {
        Text text = new Text(parent, 2048);
        GridData data = new GridData();
        data.horizontalSpan = horizontalSpan;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 0;
        text.setLayoutData((Object)data);
        return text;
    }

    protected void createRefreshButtons(Composite parent) {
        this.tagSource.addListener(this.listener);
        parent.addDisposeListener(this.disposeListener);
        this.tagRefreshArea = new TagRefreshButtonArea(this.shell, this.tagSource, new Listener(){

            public void handleEvent(Event event) {
                CVSTag dateTag = NewDateTagAction.getDateTag(TagSelectionArea.this.getShell(), TagSelectionArea.this.getLocation());
                TagSelectionArea.this.addDateTag(dateTag);
            }
        });
        if (this.context != null) {
            this.tagRefreshArea.setRunnableContext(this.context);
        }
        this.tagRefreshArea.createArea(parent);
    }

    protected void createTreeMenu(TreeViewer tagTree) {
        if ((this.includeFlags & 0x10) != 0) {
            MenuManager menuMgr = new MenuManager();
            Tree tree = tagTree.getTree();
            Menu menu = menuMgr.createContextMenu((Control)tree);
            menuMgr.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    TagSelectionArea.this.addMenuItemActions(manager);
                }
            });
            menuMgr.setRemoveAllWhenShown(true);
            tree.setMenu(menu);
        }
    }

    protected void createCustomArea(Composite parent) {
    }

    protected TreeViewer createTree(Composite parent) {
        Tree tree = new Tree(parent, 2052);
        GridData data = new GridData(1808);
        tree.setLayoutData((Object)data);
        TreeViewer result = new TreeViewer(tree);
        this.initialize((StructuredViewer)result);
        result.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event) {
                TagSelectionArea.this.handleKeyPressed(event);
            }

            public void keyReleased(KeyEvent event) {
                TagSelectionArea.this.handleKeyReleased(event);
            }
        });
        result.setInput(this.createUnfilteredInput());
        this.createTreeMenu(result);
        return result;
    }

    protected TableViewer createTable(Composite parent) {
        Table table = new Table(parent, 68356);
        GridData data = new GridData(1808);
        table.setLayoutData((Object)data);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        table.setLayout((Layout)layout);
        new TableColumn(table, 0);
        TableViewer viewer = new TableViewer(table);
        this.initialize((StructuredViewer)viewer);
        viewer.setInput((Object)this.createFilteredInput());
        return viewer;
    }

    private void initialize(StructuredViewer viewer) {
        viewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        viewer.setSorter((ViewerSorter)new TagSourceWorkbenchAdapter.ProjectElementSorter());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TagSelectionArea.this.handleSelectionChange();
            }
        });
        viewer.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                CVSTag tag = TagSelectionArea.this.internalGetSelectedTag();
                if (tag != null) {
                    TagSelectionArea.this.firePropertyChangeChange(TagSelectionArea.OPEN_SELECTED_TAG, null, tag);
                }
            }
        });
    }

    private Object createUnfilteredInput() {
        return TagSourceWorkbenchAdapter.createInput(this.tagSource, this.includeFlags);
    }

    public void handleKeyPressed(KeyEvent event) {
        if (event.character == '\u007f' && event.stateMask == 0) {
            this.deleteDateTag();
        }
    }

    private void deleteDateTag() {
        TagElement[] selectedDateTagElements = this.getSelectedDateTagElement();
        if (selectedDateTagElements.length == 0) {
            return;
        }
        int i = 0;
        while (i < selectedDateTagElements.length) {
            RepositoryManager mgr = CVSUIPlugin.getPlugin().getRepositoryManager();
            CVSTag tag = selectedDateTagElements[i].getTag();
            if (tag.getType() == 3) {
                mgr.removeDateTag(this.getLocation(), tag);
            }
            ++i;
        }
        this.tagTree.refresh();
        this.handleSelectionChange();
    }

    private TagElement[] getSelectedDateTagElement() {
        ArrayList<Object> dateTagElements = null;
        IStructuredSelection selection = (IStructuredSelection)this.tagTree.getSelection();
        if (selection != null && !selection.isEmpty()) {
            dateTagElements = new ArrayList<Object>();
            Iterator elements = selection.iterator();
            while (elements.hasNext()) {
                Object next;
                Object e = elements.next();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.team.internal.ccvs.ui.tags.TagElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!((next = TeamAction.getAdapter(e, (Class)clazz)) instanceof TagElement) || ((TagElement)next).getTag().getType() != 3) continue;
                dateTagElements.add(next);
            }
        }
        if (dateTagElements != null && !dateTagElements.isEmpty()) {
            TagElement[] result = new TagElement[dateTagElements.size()];
            dateTagElements.toArray(result);
            return result;
        }
        return new TagElement[0];
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addDateTag(CVSTag tag) {
        if (tag == null) {
            return;
        }
        ArrayList<CVSTag> dateTags = new ArrayList<CVSTag>();
        ICVSRepositoryLocation location = this.getLocation();
        dateTags.addAll(Arrays.asList(CVSUIPlugin.getPlugin().getRepositoryManager().getDateTags(location)));
        if (!dateTags.contains(tag)) {
            CVSUIPlugin.getPlugin().getRepositoryManager().addDateTag(location, tag);
        }
        try {
            this.tagTree.getControl().setRedraw(false);
            this.tagTree.refresh();
            this.setSelection(tag);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.tagTree.getControl().setRedraw(true);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.tagTree.getControl().setRedraw(true);
        this.handleSelectionChange();
    }

    private void addMenuItemActions(IMenuManager manager) {
        manager.add((IAction)new Action(CVSUIMessages.TagSelectionDialog_0){

            public void run() {
                CVSTag dateTag = NewDateTagAction.getDateTag(TagSelectionArea.this.getShell(), TagSelectionArea.this.getLocation());
                TagSelectionArea.this.addDateTag(dateTag);
            }
        });
        if (this.getSelectedDateTagElement().length > 0) {
            manager.add((IAction)new Action(CVSUIMessages.TagSelectionDialog_1){

                public void run() {
                    TagSelectionArea.this.deleteDateTag();
                }
            });
        }
    }

    protected void handleKeyReleased(KeyEvent event) {
    }

    protected void handleSelectionChange() {
        CVSTag newSelection = this.internalGetSelectedTag();
        if (this.selection != null && newSelection != null && this.selection.equals((Object)newSelection)) {
            return;
        }
        CVSTag oldSelection = this.selection;
        this.selection = newSelection;
        this.firePropertyChangeChange(SELECTED_TAG, oldSelection, this.selection);
    }

    private CVSTag internalGetSelectedTag() {
        IStructuredSelection selection = this.isTreeVisible() ? (IStructuredSelection)this.tagTree.getSelection() : (IStructuredSelection)this.tagTable.getSelection();
        Object o = selection.getFirstElement();
        if (o instanceof TagElement) {
            return ((TagElement)o).getTag();
        }
        return null;
    }

    private boolean isTreeVisible() {
        return this.treeVisible;
    }

    private ICVSRepositoryLocation getLocation() {
        return this.tagSource.getLocation();
    }

    public CVSTag getSelection() {
        return this.selection;
    }

    public Shell getShell() {
        return this.shell;
    }

    public void setFocus() {
        if (this.filterText != null) {
            this.filterText.setFocus();
        } else if (this.switcher != null) {
            this.switcher.setFocus();
        }
        this.refresh();
    }

    public void setSelection(CVSTag selectedTag) {
        if (this.isTreeVisible()) {
            if (this.tagTree != null && !this.tagTree.getControl().isDisposed()) {
                this.tagTree.expandToLevel(2);
                this.tagTree.collapseAll();
                this.tagTree.reveal((Object)new TagElement(selectedTag));
                this.tagTree.setSelection((ISelection)new StructuredSelection((Object)new TagElement(selectedTag)));
            } else if (this.tagTable != null && !this.tagTable.getControl().isDisposed()) {
                this.tagTable.setSelection((ISelection)new StructuredSelection((Object)new TagElement(selectedTag)));
            }
        }
    }

    public void refresh() {
        if (this.isTreeVisible()) {
            if (this.tagTree != null && !this.tagTree.getControl().isDisposed()) {
                this.tagTree.refresh();
            }
        } else if (this.tagTable != null && !this.tagTable.getControl().isDisposed()) {
            this.tagTable.refresh();
        }
    }

    public void refreshTagList() {
        this.tagRefreshArea.refresh(true);
    }

    public void setEnabled(boolean enabled) {
        if (this.filterText != null) {
            this.filterText.setEnabled(enabled);
        }
        this.tagTree.getControl().setEnabled(enabled);
        this.tagTable.getControl().setEnabled(enabled);
    }

    public void setTagSource(TagSource tagSource) {
        if (this.tagSource != null) {
            this.tagSource.removeListener(this.listener);
        }
        this.tagSource = tagSource;
        this.tagSource.addListener(this.listener);
        this.tagRefreshArea.setTagSource(this.tagSource);
        this.setTreeAndTableInput();
    }

    private void setTreeAndTableInput() {
        if (this.tagTree != null) {
            this.tagTree.setInput(this.createUnfilteredInput());
        }
        if (this.tagTable != null) {
            this.tagTable.setInput((Object)this.createFilteredInput());
        }
    }

    public void setIncludeFilterInputArea(boolean include) {
        this.includeFilterInputArea = include;
    }

    public boolean isIncludeFilterInputArea() {
        return this.includeFilterInputArea;
    }

    public void setFilter(String filter) {
        this.filterPattern = filter;
        this.updateTagDisplay(false);
    }

    public void setRunnableContext(IRunnableContext context) {
        this.context = context;
        if (this.tagRefreshArea != null) {
            this.tagRefreshArea.setRunnableContext(context);
        }
    }
}

