/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ssh;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.Socket;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ccvs.core.connection.CVSAuthenticationException;
import org.eclipse.team.internal.ccvs.ssh.CVSSSHMessages;
import org.eclipse.team.internal.ccvs.ssh.Cipher;
import org.eclipse.team.internal.ccvs.ssh.ClientPacket;
import org.eclipse.team.internal.ccvs.ssh.KnownHosts;
import org.eclipse.team.internal.ccvs.ssh.Misc;
import org.eclipse.team.internal.ccvs.ssh.Policy;
import org.eclipse.team.internal.ccvs.ssh.ServerPacket;
import org.eclipse.team.internal.core.streams.PollingOutputStream;

public class Client {
    private static final String clientId = "SSH-1.5-Java 1.2.2\n";
    private static String serverId = null;
    private static final int MAX_CLIENT_PACKET_SIZE = 1024;
    private static final int SSH_MSG_DISCONNECT = 1;
    private static final int SSH_SMSG_PUBLIC_KEY = 2;
    private static final int SSH_CMSG_SESSION_KEY = 3;
    private static final int SSH_CMSG_USER = 4;
    private static final int SSH_CMSG_AUTH_PASSWORD = 9;
    private static final int SSH_CMSG_REQUEST_PTY = 10;
    private static final int SSH_CMSG_EXEC_SHELL = 12;
    private static final int SSH_CMSG_EXEC_CMD = 13;
    private static final int SSH_SMSG_SUCCESS = 14;
    private static final int SSH_SMSG_FAILURE = 15;
    private static final int SSH_CMSG_STDIN_DATA = 16;
    private static final int SSH_SMSG_STDOUT_DATA = 17;
    private static final int SSH_SMSG_STDERR_DATA = 18;
    private static final int SSH_SMSG_EXITSTATUS = 20;
    private static final int SSH_CMSG_EXIT_CONFIRMATION = 33;
    private static final int SSH_MSG_DEBUG = 36;
    private static String[] cipherNames = new String[]{"None", "IDEA", "DES", "3DES", "TSS", "RC4", "Blowfish"};
    private static int SSH_CIPHER_BLOWFISH = 6;
    private int[] preferredCipherTypes = new int[]{SSH_CIPHER_BLOWFISH};
    private String host;
    private int port;
    private String username;
    private String password;
    private String command;
    private Socket socket;
    private InputStream socketIn;
    private PollingOutputStream socketOut;
    private InputStream is;
    private OutputStream os;
    private boolean connected = false;
    private int timeout = -1;
    private Cipher cipher = null;

    public Client(String host, int port, String username, String password) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
    }

    public Client(String host, int port, String username, String password, String command) {
        this(host, port, username, password);
        this.command = command;
    }

    public Client(String host, int port, String username, String password, String command, int timeout) {
        this(host, port, username, password, command);
        this.timeout = timeout;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void cleanup() throws IOException {
        try {
            if (this.is != null) {
                this.is.close();
            }
            var1_3 = null;
        }
        catch (Throwable var2_1) {
            var1_2 = null;
            try {
                if (this.os != null) {
                    this.os.close();
                }
                v0 = null;
            }
            catch (Throwable var4_4) {
                v0 = null;
            }
            var3_6 = v0;
            try {
                if (this.socketIn != null) {
                    this.socketIn.close();
                }
                v1 = null;
            }
            catch (Throwable var6_8) {
                v1 = null;
            }
            var5_10 = v1;
            try {
                if (this.socketOut != null) {
                    this.socketOut.close();
                }
                v2 = null;
            }
            catch (Throwable var8_12) {
                v2 = null;
            }
            var7_14 = v2;
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
                v3 = null;
            }
            catch (Throwable var10_16) {
                v3 = null;
            }
            var9_18 = v3;
            this.socket = null;
            throw var2_1;
        }
        try {}
        catch (Throwable var4_5) {
            v4 = null;
lbl51:
            // 2 sources

            var3_7 = v4;
            try {}
            catch (Throwable var6_9) {
                v5 = null;
lbl55:
                // 2 sources

                var5_11 = v5;
                try {}
                catch (Throwable var8_13) {
                    v6 = null;
lbl59:
                    // 2 sources

                    var7_15 = v6;
                    try {}
                    catch (Throwable var10_17) {
                        v7 = null;
lbl63:
                        // 2 sources

                        var9_19 = v7;
                        this.socket = null;
                        return;
                    }
                    if (this.socket != null) {
                        this.socket.close();
                    }
                    v7 = null;
                    ** GOTO lbl63
                }
                if (this.socketOut != null) {
                    this.socketOut.close();
                }
                v6 = null;
                ** GOTO lbl59
            }
            if (this.socketIn != null) {
                this.socketIn.close();
            }
            v5 = null;
            ** GOTO lbl55
        }
        if (this.os != null) {
            this.os.close();
        }
        v4 = null;
        ** GOTO lbl51
    }

    /*
     * Exception decompiling
     */
    public void connect(IProgressMonitor monitor) throws IOException, CVSAuthenticationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 469->473)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void disconnect() throws IOException {
        if (Policy.DEBUG_SSH_PROTOCOL) {
            System.out.println("Disconnecting.");
        }
        if (!this.connected) return;
        this.connected = false;
        try {
            this.send(1, null);
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.cleanup();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.cleanup();
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            throw new IOException(CVSSSHMessages.Client_notConnected);
        }
        return this.is;
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.connected) {
            throw new IOException(CVSSSHMessages.Client_notConnected);
        }
        return this.os;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void startShell() throws IOException {
        block5: {
            ServerPacket packet = null;
            this.send_SSH_CMSG_REQUEST_PTY();
            try {
                packet = this.skip_SSH_MSG_DEBUG();
                int packetType = packet.getType();
                if (packetType != 14) {
                    throw new IOException(NLS.bind((String)CVSSSHMessages.Client_packetType, (Object[])new Object[]{new Integer(packetType)}));
                }
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                if (packet != null) {
                    packet.close(true);
                }
                throw throwable;
            }
            {
                Object var3_5 = null;
                if (packet == null) break block5;
            }
            packet.close(true);
        }
        this.send(12, null);
    }

    private void executeCommand() throws IOException {
        this.send(13, this.command);
    }

    /*
     * Exception decompiling
     */
    private void login() throws IOException, CVSAuthenticationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 74->77)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void receive_SSH_SMSG_PUBLIC_KEY(ServerPacket packet) throws IOException, CVSAuthenticationException {
        InputStream pis = packet.getInputStream();
        byte[] anti_spoofing_cookie = new byte[8];
        Misc.readFully(pis, anti_spoofing_cookie);
        byte[] server_key_bits = new byte[4];
        Misc.readFully(pis, server_key_bits);
        byte[] server_key_public_exponent = Misc.readMpInt(pis);
        byte[] server_key_public_modulus = Misc.readMpInt(pis);
        byte[] host_key_bits = new byte[4];
        Misc.readFully(pis, host_key_bits);
        byte[] host_key_public_exponent = Misc.readMpInt(pis);
        byte[] host_key_public_modulus = Misc.readMpInt(pis);
        byte[] protocol_flags = new byte[4];
        Misc.readFully(pis, protocol_flags);
        byte[] supported_ciphers_mask = new byte[4];
        Misc.readFully(pis, supported_ciphers_mask);
        byte[] supported_authentications_mask = new byte[4];
        Misc.readFully(pis, supported_authentications_mask);
        pis.close();
        this.send_SSH_CMSG_SESSION_KEY(anti_spoofing_cookie, host_key_bits, server_key_public_modulus, host_key_public_modulus, supported_ciphers_mask, server_key_public_exponent, host_key_public_exponent);
    }

    private void send(int packetType, String s) throws IOException {
        byte[] data = s == null ? new byte[]{} : s.getBytes("UTF-8");
        this.send(packetType, data, 0, data.length);
    }

    private void send(int packetType, byte[] data, int off, int len) throws IOException {
        data = data == null ? null : Misc.lengthEncode(data, off, len);
        ClientPacket packet = new ClientPacket(packetType, data, this.cipher);
        this.socketOut.write(packet.getBytes());
        this.socketOut.flush();
    }

    private void send_SSH_CMSG_REQUEST_PTY() throws IOException {
        int packet_type = 10;
        byte[] termType = Misc.lengthEncode("dumb".getBytes(), 0, 4);
        byte[] row = new byte[4];
        byte[] col = new byte[4];
        byte[] XPixels = new byte[4];
        byte[] YPixels = new byte[4];
        byte[] terminalModes = new byte[1];
        byte[] data = new byte[termType.length + row.length + col.length + XPixels.length + YPixels.length + terminalModes.length];
        int offset = 0;
        System.arraycopy(termType, 0, data, offset, termType.length);
        System.arraycopy(row, 0, data, offset += termType.length, row.length);
        System.arraycopy(col, 0, data, offset += row.length, col.length);
        System.arraycopy(XPixels, 0, data, offset += col.length, XPixels.length);
        System.arraycopy(YPixels, 0, data, offset += XPixels.length, YPixels.length);
        System.arraycopy(terminalModes, 0, data, offset += YPixels.length, terminalModes.length);
        ClientPacket packet = new ClientPacket(packet_type, data, this.cipher);
        this.socketOut.write(packet.getBytes());
        this.socketOut.flush();
    }

    private void send_SSH_CMSG_SESSION_KEY(byte[] anti_spoofing_cookie, byte[] host_key_bits, byte[] server_key_public_modulus, byte[] host_key_public_modulus, byte[] supported_ciphers_mask, byte[] server_key_public_exponent, byte[] host_key_public_exponent) throws IOException, CVSAuthenticationException {
        byte[] result;
        int packet_type = 3;
        byte[] session_id = new byte[host_key_public_modulus.length + server_key_public_modulus.length + anti_spoofing_cookie.length];
        int offset = 0;
        System.arraycopy(host_key_public_modulus, 0, session_id, offset, host_key_public_modulus.length);
        System.arraycopy(server_key_public_modulus, 0, session_id, offset += host_key_public_modulus.length, server_key_public_modulus.length);
        System.arraycopy(anti_spoofing_cookie, 0, session_id, offset += server_key_public_modulus.length, anti_spoofing_cookie.length);
        session_id = Misc.md5(session_id);
        byte cipher_type = 0;
        boolean foundSupportedCipher = false;
        int i = 0;
        while (i < this.preferredCipherTypes.length && !foundSupportedCipher) {
            cipher_type = (byte)this.preferredCipherTypes[i];
            foundSupportedCipher = (supported_ciphers_mask[3] & (byte)(1 << cipher_type)) != 0;
            ++i;
        }
        if (!foundSupportedCipher) {
            throw new IOException(CVSSSHMessages.Client_cipher);
        }
        byte[] session_key = new byte[32];
        byte[] session_key_xored = new byte[32];
        byte[] session_key_encrypted = null;
        Misc.random(session_key, 0, session_key.length, true);
        System.arraycopy(session_key, 0, session_key_xored, 0, session_key.length);
        Misc.xor(session_key_xored, 0, session_id, 0, session_key_xored, 0, session_id.length);
        BigInteger host_e = new BigInteger(1, host_key_public_exponent);
        BigInteger host_n = new BigInteger(1, host_key_public_modulus);
        if (!new KnownHosts().verifyKey(this.host, host_key_bits, host_e, host_n)) {
            throw new CVSAuthenticationException(CVSSSHMessages.Client_hostIdChanged, 2);
        }
        if (new BigInteger(1, server_key_public_modulus).compareTo(host_n) == -1) {
            result = Misc.encryptRSAPkcs1(session_key_xored, server_key_public_exponent, server_key_public_modulus);
            result = Misc.encryptRSAPkcs1(result, host_key_public_exponent, host_key_public_modulus);
        } else {
            result = Misc.encryptRSAPkcs1(session_key_xored, host_key_public_exponent, host_key_public_modulus);
            result = Misc.encryptRSAPkcs1(result, server_key_public_exponent, server_key_public_modulus);
        }
        session_key_encrypted = new byte[result.length + 2];
        session_key_encrypted[1] = (byte)(8 * result.length & 0xFF);
        session_key_encrypted[0] = (byte)(8 * result.length >> 8 & 0xFF);
        int i2 = 0;
        while (i2 < result.length) {
            session_key_encrypted[i2 + 2] = result[i2];
            ++i2;
        }
        byte[] protocol_flags = new byte[4];
        byte[] data = new byte[1 + anti_spoofing_cookie.length + session_key_encrypted.length + protocol_flags.length];
        offset = 0;
        data[offset++] = cipher_type;
        System.arraycopy(anti_spoofing_cookie, 0, data, offset, anti_spoofing_cookie.length);
        System.arraycopy(session_key_encrypted, 0, data, offset += anti_spoofing_cookie.length, session_key_encrypted.length);
        System.arraycopy(protocol_flags, 0, data, offset += session_key_encrypted.length, protocol_flags.length);
        this.cipher = Cipher.getInstance(cipherNames[cipher_type]);
        this.cipher.setKey(session_key);
        ClientPacket packet = new ClientPacket(packet_type, data, null);
        this.socketOut.write(packet.getBytes());
        this.socketOut.flush();
    }

    private ServerPacket skip_SSH_MSG_DEBUG() throws IOException {
        ServerPacket packet = new ServerPacket(this.socketIn, this.cipher);
        while (packet.getType() == 36) {
            packet.close(true);
            packet = new ServerPacket(this.socketIn, this.cipher);
        }
        return packet;
    }

    private class StandardInputStream
    extends InputStream {
        private ServerPacket packet = null;
        private InputStream buffer = null;
        private boolean atEnd = false;
        private boolean closed = false;

        private StandardInputStream() {
        }

        public int available() throws IOException {
            int available;
            if (this.closed) {
                throw new IOException(CVSSSHMessages.closed);
            }
            int n = available = this.buffer == null ? 0 : this.buffer.available();
            if (available == 0 && Client.this.socketIn.available() > 0) {
                this.fill();
                if (this.atEnd) {
                    return 0;
                }
                available = this.buffer.available();
            }
            return available;
        }

        public void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                if (this.packet != null) {
                    this.packet.close(false);
                    this.buffer = null;
                    this.packet = null;
                }
            }
        }

        public int read() throws IOException {
            if (this.closed) {
                throw new IOException(CVSSSHMessages.closed);
            }
            if (this.atEnd) {
                return -1;
            }
            if (this.buffer == null || this.buffer.available() == 0) {
                this.fill();
                if (this.atEnd) {
                    return -1;
                }
            }
            return this.buffer.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (this.closed) {
                throw new IOException(CVSSSHMessages.closed);
            }
            if (this.atEnd) {
                return -1;
            }
            if (this.buffer == null || this.buffer.available() == 0) {
                this.fill();
                if (this.atEnd) {
                    return -1;
                }
            }
            return this.buffer.read(b, off, len);
        }

        private void fill() throws IOException {
            if (this.buffer != null) {
                this.buffer.close();
            }
            this.packet = Client.this.skip_SSH_MSG_DEBUG();
            int packetType = this.packet.getType();
            switch (packetType) {
                case 17: 
                case 18: 
                case 36: {
                    this.buffer = this.packet.getInputStream();
                    Misc.readInt(this.buffer);
                    break;
                }
                case 20: {
                    this.buffer = null;
                    this.atEnd = true;
                    InputStream pis = this.packet.getInputStream();
                    Misc.readInt(pis);
                    pis.close();
                    Client.this.send(33, null);
                    break;
                }
                case 1: {
                    this.buffer = null;
                    this.atEnd = true;
                    this.handleDisconnect(this.packet.getInputStream());
                    break;
                }
                default: {
                    throw new IOException(NLS.bind((String)CVSSSHMessages.Client_packetType, (Object[])new Object[]{new Integer(packetType)}));
                }
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void handleDisconnect(InputStream in) throws IOException {
            String description = null;
            try {
                try {
                    description = Misc.readString(in);
                }
                catch (IOException iOException) {}
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                in.close();
                throw throwable;
            }
            {
                Object var3_5 = null;
            }
            in.close();
            if (description == null) {
                description = CVSSSHMessages.Client_noDisconnectDescription;
            }
            throw new IOException(NLS.bind((String)CVSSSHMessages.Client_disconnectDescription, (Object[])new Object[]{description}));
        }
    }

    private class StandardOutputStream
    extends OutputStream {
        private int MAX_BUFFER_SIZE = 1024;
        private byte[] buffer = new byte[this.MAX_BUFFER_SIZE];
        private int bufpos = 0;
        private boolean closed = false;

        private StandardOutputStream() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void close() throws IOException {
            if (this.closed) return;
            try {
                this.flush();
            }
            catch (Throwable throwable) {
                Object var1_2 = null;
                this.closed = true;
                throw throwable;
            }
            {
                Object var1_3 = null;
                this.closed = true;
                return;
            }
        }

        public void flush() throws IOException {
            if (this.closed) {
                throw new IOException(CVSSSHMessages.closed);
            }
            if (this.bufpos > 0) {
                Client.this.send(16, this.buffer, 0, this.bufpos);
                this.bufpos = 0;
            }
        }

        public void write(int b) throws IOException {
            if (this.closed) {
                throw new IOException(CVSSSHMessages.closed);
            }
            this.buffer[this.bufpos++] = (byte)b;
            if (this.bufpos == this.MAX_BUFFER_SIZE) {
                this.flush();
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (this.closed) {
                throw new IOException(CVSSSHMessages.closed);
            }
            int bytesWritten = 0;
            int totalBytesWritten = 0;
            if (this.bufpos > 0) {
                bytesWritten = Math.min(this.MAX_BUFFER_SIZE - this.bufpos, len);
                System.arraycopy(b, off, this.buffer, this.bufpos, bytesWritten);
                this.bufpos += bytesWritten;
                totalBytesWritten += bytesWritten;
                if (this.bufpos == this.MAX_BUFFER_SIZE) {
                    this.flush();
                }
            }
            while (len - totalBytesWritten >= this.MAX_BUFFER_SIZE) {
                Client.this.send(16, b, off + totalBytesWritten, this.MAX_BUFFER_SIZE);
                totalBytesWritten += this.MAX_BUFFER_SIZE;
            }
            if (totalBytesWritten < len) {
                bytesWritten = len - totalBytesWritten;
                System.arraycopy(b, off + totalBytesWritten, this.buffer, 0, bytesWritten);
                this.bufpos += bytesWritten;
            }
        }
    }
}

