/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.folding;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.php.internal.ui.folding.PHPFoldingStructureProviderDescriptor;
import org.eclipse.php.ui.PHPUiPlugin;
import org.eclipse.php.ui.preferences.PreferenceConstants;
import org.eclipse.wst.sse.ui.internal.projection.IStructuredTextFoldingProvider;

public class PHPFoldingStructureProviderRegistry {
    private static final String EXTENSION_POINT = "foldingStructureProviders";
    private Map fDescriptors;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PHPFoldingStructureProviderDescriptor[] getFoldingProviderDescriptors() {
        PHPFoldingStructureProviderRegistry pHPFoldingStructureProviderRegistry = this;
        synchronized (pHPFoldingStructureProviderRegistry) {
            this.ensureRegistered();
            return this.fDescriptors.values().toArray(new PHPFoldingStructureProviderDescriptor[this.fDescriptors.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PHPFoldingStructureProviderDescriptor getFoldingProviderDescriptor(String string) {
        PHPFoldingStructureProviderRegistry pHPFoldingStructureProviderRegistry = this;
        synchronized (pHPFoldingStructureProviderRegistry) {
            this.ensureRegistered();
            return (PHPFoldingStructureProviderDescriptor)this.fDescriptors.get(string);
        }
    }

    public IStructuredTextFoldingProvider getCurrentFoldingProvider() {
        String string = PreferenceConstants.getPreferenceStore().getString("editor_folding_provider");
        PHPFoldingStructureProviderDescriptor pHPFoldingStructureProviderDescriptor = this.getFoldingProviderDescriptor(string);
        if (pHPFoldingStructureProviderDescriptor != null) {
            try {
                return pHPFoldingStructureProviderDescriptor.createProvider();
            }
            catch (CoreException coreException) {
                PHPUiPlugin.log(coreException);
            }
        }
        return null;
    }

    private void ensureRegistered() {
        if (this.fDescriptors == null) {
            this.reloadExtensions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadExtensions() {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        HashMap<String, PHPFoldingStructureProviderDescriptor> hashMap = new HashMap<String, PHPFoldingStructureProviderDescriptor>();
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(PHPUiPlugin.getPluginId(), EXTENSION_POINT);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            PHPFoldingStructureProviderDescriptor pHPFoldingStructureProviderDescriptor = new PHPFoldingStructureProviderDescriptor(iConfigurationElementArray[n]);
            hashMap.put(pHPFoldingStructureProviderDescriptor.getId(), pHPFoldingStructureProviderDescriptor);
            ++n;
        }
        PHPFoldingStructureProviderRegistry pHPFoldingStructureProviderRegistry = this;
        synchronized (pHPFoldingStructureProviderRegistry) {
            this.fDescriptors = Collections.unmodifiableMap(hashMap);
        }
    }
}

