/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.mapping;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.internal.ui.mapping.CommonMenuManager;
import org.eclipse.team.internal.ui.synchronize.actions.OpenWithActionGroup;
import org.eclipse.team.ui.mapping.MergeActionHandler;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.ui.navigator.IExtensionStateModel;

public class SynchronizationActionProvider
extends CommonActionProvider {
    public static final String MERGE_ACTION_ID = "org.eclipse.team.ui.mergeAction";
    public static final String OVERWRITE_ACTION_ID = "org.eclipse.team.ui.overwriteAction";
    public static final String MARK_AS_MERGE_ACTION_ID = "org.eclipse.team.ui.markAsMergeAction";
    private Map handlers = new HashMap();
    private OpenWithActionGroup openWithActions;

    public void init(ICommonActionExtensionSite site) {
        super.init(site);
        this.initialize();
    }

    protected void initialize() {
        this.initializeOpenActions();
    }

    protected void initializeOpenActions() {
        ICommonViewerWorkbenchSite cvws;
        IWorkbenchPartSite wps;
        ICommonViewerSite cvs = this.getActionSite().getViewSite();
        ISynchronizePageConfiguration configuration = this.getSynchronizePageConfiguration();
        if (cvs instanceof ICommonViewerWorkbenchSite && configuration != null && (wps = (cvws = (ICommonViewerWorkbenchSite)cvs).getSite()) instanceof IViewSite) {
            this.openWithActions = new OpenWithActionGroup(configuration.getSite(), configuration.getParticipant(), false);
        }
    }

    protected final ISynchronizePageConfiguration getSynchronizePageConfiguration() {
        return (ISynchronizePageConfiguration)this.getExtensionStateModel().getProperty("org.eclipse.team.ui.synchronizationPageConfiguration");
    }

    protected final IExtensionStateModel getExtensionStateModel() {
        return this.getActionSite().getExtensionStateModel();
    }

    protected final ISynchronizationContext getSynchronizationContext() {
        return (ISynchronizationContext)this.getExtensionStateModel().getProperty("org.eclipse.team.ui.synchronizationContext");
    }

    protected void registerHandler(String actionId, IHandler handler) {
        this.handlers.put(actionId, handler);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        if (menu instanceof CommonMenuManager) {
            CommonMenuManager manager = (CommonMenuManager)menu;
            Iterator iter = this.handlers.keySet().iterator();
            while (iter.hasNext()) {
                String actionId = (String)iter.next();
                manager.registerHandler(actionId, (IHandler)this.handlers.get(actionId));
            }
        }
        IContributionItem fileGroup = menu.find("file");
        if (this.openWithActions != null && fileGroup != null) {
            this.openWithActions.fillContextMenu(menu, fileGroup.getId());
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        if (this.openWithActions != null) {
            this.openWithActions.fillActionBars(actionBars);
        }
    }

    public void updateActionBars() {
        super.updateActionBars();
        if (this.openWithActions != null) {
            this.openWithActions.updateActionBars();
        }
    }

    public void setContext(ActionContext context) {
        super.setContext(context);
        if (this.openWithActions != null) {
            this.openWithActions.setContext(context);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.openWithActions != null) {
            this.openWithActions.dispose();
        }
        Iterator iter = this.handlers.values().iterator();
        while (iter.hasNext()) {
            IHandler handler = (IHandler)iter.next();
            if (!(handler instanceof MergeActionHandler)) continue;
            MergeActionHandler mah = (MergeActionHandler)handler;
            mah.dispose();
        }
    }

    public ICommonActionExtensionSite getExtensionSite() {
        return this.getActionSite();
    }
}

