/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.search;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.php.PHPUIMessages;
import org.eclipse.php.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.core.phpModel.parser.PHPUserModel;
import org.eclipse.php.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.ui.PHPUiPlugin;
import org.eclipse.php.ui.search.IPHPSearchScope;
import org.eclipse.php.ui.search.PHPSearchResult;
import org.eclipse.php.ui.search.PHPSearchScope;
import org.eclipse.php.ui.search.PHPWorspaceScope;
import org.eclipse.php.ui.search.decorators.PHPClassDataDecorator;
import org.eclipse.php.ui.search.decorators.PHPConstantDataDecorator;
import org.eclipse.php.ui.search.decorators.PHPFunctionDataDecorator;
import org.eclipse.php.ui.util.SearchPattern;
import org.eclipse.search.ui.text.Match;

public class PHPSearchEngine {
    public static IPHPSearchScope createPHPSearchScope(int n, Object[] objectArray) {
        PHPSearchScope pHPSearchScope = new PHPSearchScope(n);
        int n2 = 0;
        int n3 = objectArray.length;
        while (n2 < n3) {
            Object object = objectArray[n2];
            if (object != null) {
                try {
                    if (object instanceof IProject) {
                        pHPSearchScope.add((IProject)object);
                    } else if (object instanceof IResource) {
                        pHPSearchScope.add((IResource)object);
                    }
                }
                catch (Exception exception) {}
            }
            ++n2;
        }
        return pHPSearchScope;
    }

    public static IPHPSearchScope createWorkspaceScope(int n) {
        IWorkspace iWorkspace = PHPUiPlugin.getWorkspace();
        IProject[] iProjectArray = iWorkspace.getRoot().getProjects();
        PHPWorspaceScope pHPWorspaceScope = new PHPWorspaceScope(n);
        int n2 = 0;
        while (n2 < iProjectArray.length) {
            try {
                if (iProjectArray[n2].hasNature("org.eclipse.php.core.PHPNature")) {
                    pHPWorspaceScope.add(iProjectArray[n2]);
                }
            }
            catch (CoreException coreException) {
                PHPUiPlugin.log(coreException);
            }
            ++n2;
        }
        return pHPWorspaceScope;
    }

    public void search(String string, IPHPSearchScope iPHPSearchScope, PHPSearchResult pHPSearchResult, boolean bl, IProgressMonitor iProgressMonitor) {
        PHPClassData[] pHPClassDataArray;
        PHPUserModel pHPUserModel;
        IProject[] iProjectArray = iPHPSearchScope.getFullScopeProjects();
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (iProgressMonitor != null) {
            iProgressMonitor.beginTask(PHPUIMessages.PHPEngine_searching, -1);
        }
        int n = 0;
        while (n < iProjectArray.length) {
            if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            PHPProjectModel pHPProjectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(iProjectArray[n]);
            if (pHPProjectModel == null) {
                return;
            }
            pHPUserModel = pHPProjectModel.getPHPUserModel();
            switch (iPHPSearchScope.getSearchFor()) {
                case 0: {
                    this.addResultsFor(iProjectArray[n], (PHPClassData[])pHPUserModel.getClasses(), string, bl, iPHPSearchScope, pHPSearchResult, iProgressMonitor);
                    break;
                }
                case 1: {
                    this.addResultsFor(iProjectArray[n], (PHPFunctionData[])pHPUserModel.getFunctions(), string, bl, iPHPSearchScope, pHPSearchResult, iProgressMonitor);
                    pHPClassDataArray = (PHPClassData[])pHPUserModel.getClasses();
                    int n2 = 0;
                    while (n2 < pHPClassDataArray.length) {
                        this.addResultsFor(iProjectArray[n], pHPClassDataArray[n2].getFunctions(), string, bl, iPHPSearchScope, pHPSearchResult, iProgressMonitor);
                        ++n2;
                    }
                    break;
                }
                case 2: {
                    this.addResultsFor(iProjectArray[n], (PHPConstantData[])pHPUserModel.getConstants(), string, bl, iPHPSearchScope, pHPSearchResult, iProgressMonitor);
                }
            }
            ++n;
        }
        IProject[] iProjectArray2 = iPHPSearchScope.getPartialScopeProjects();
        int n3 = 0;
        while (n3 < iProjectArray2.length) {
            if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            pHPUserModel = PHPWorkspaceModelManager.getInstance().getModelForProject(iProjectArray2[n3]);
            if (pHPUserModel == null) {
                return;
            }
            pHPClassDataArray = pHPUserModel.getPHPUserModel();
            IPath[] iPathArray = iPHPSearchScope.getPartialResourcesPaths(iProjectArray2[n3]);
            int n4 = 0;
            while (n4 < iPathArray.length) {
                PHPFileData pHPFileData = pHPClassDataArray.getFileData(iPathArray[n4].toString());
                if (pHPFileData != null) {
                    switch (iPHPSearchScope.getSearchFor()) {
                        case 0: {
                            this.addResultsFor(iProjectArray2[n3], pHPFileData.getClasses(), string, bl, iPHPSearchScope, pHPSearchResult, iProgressMonitor);
                            break;
                        }
                        case 1: {
                            this.addResultsFor(iProjectArray2[n3], pHPFileData.getFunctions(), string, bl, iPHPSearchScope, pHPSearchResult, iProgressMonitor);
                            PHPClassData[] pHPClassDataArray2 = pHPFileData.getClasses();
                            int n5 = 0;
                            while (n5 < pHPClassDataArray2.length) {
                                this.addResultsFor(iProjectArray2[n3], pHPClassDataArray2[n5].getFunctions(), string, bl, iPHPSearchScope, pHPSearchResult, iProgressMonitor);
                                ++n5;
                            }
                            break;
                        }
                        case 2: {
                            this.addResultsFor(iProjectArray2[n3], pHPFileData.getConstants(), string, bl, iPHPSearchScope, pHPSearchResult, iProgressMonitor);
                        }
                    }
                }
                ++n4;
            }
            ++n3;
        }
        if (iProgressMonitor != null && !iProgressMonitor.isCanceled()) {
            iProgressMonitor.done();
        }
    }

    private void addResultsFor(IProject iProject, PHPClassData[] pHPClassDataArray, String string, boolean bl, IPHPSearchScope iPHPSearchScope, PHPSearchResult pHPSearchResult, IProgressMonitor iProgressMonitor) {
        int n = 0;
        while (n < pHPClassDataArray.length) {
            if (n % 100 == 0 && iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            PHPClassData pHPClassData = pHPClassDataArray[n];
            if (SearchPattern.match(string, pHPClassData.getName(), bl, true)) {
                int n2 = pHPClassData.getUserData().getStopPosition();
                pHPSearchResult.addMatch(new Match((Object)new PHPClassDataDecorator(pHPClassData, iProject), n2, pHPClassData.getName().length()));
            }
            iProgressMonitor.worked(1);
            ++n;
        }
    }

    private void addResultsFor(IProject iProject, PHPFunctionData[] pHPFunctionDataArray, String string, boolean bl, IPHPSearchScope iPHPSearchScope, PHPSearchResult pHPSearchResult, IProgressMonitor iProgressMonitor) {
        int n = 0;
        while (n < pHPFunctionDataArray.length) {
            if (n % 100 == 0 && iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            PHPFunctionData pHPFunctionData = pHPFunctionDataArray[n];
            if (SearchPattern.match(string, pHPFunctionData.getName(), bl, true)) {
                int n2 = pHPFunctionData.getUserData().getStopPosition();
                pHPSearchResult.addMatch(new Match((Object)new PHPFunctionDataDecorator(pHPFunctionData, iProject), n2, pHPFunctionData.getName().length()));
            }
            iProgressMonitor.worked(1);
            ++n;
        }
    }

    private void addResultsFor(IProject iProject, PHPConstantData[] pHPConstantDataArray, String string, boolean bl, IPHPSearchScope iPHPSearchScope, PHPSearchResult pHPSearchResult, IProgressMonitor iProgressMonitor) {
        int n = 0;
        while (n < pHPConstantDataArray.length) {
            if (n % 100 == 0 && iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            PHPConstantData pHPConstantData = pHPConstantDataArray[n];
            if (SearchPattern.match(string, pHPConstantData.getName(), bl, true)) {
                int n2 = pHPConstantData.getUserData().getStopPosition() + 1;
                pHPSearchResult.addMatch(new Match((Object)new PHPConstantDataDecorator(pHPConstantData, iProject), n2, pHPConstantData.getName().length()));
            }
            iProgressMonitor.worked(1);
            ++n;
        }
    }
}

