/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.php.core.preferences.IPreferencesPropagatorListener;

public abstract class AbstractPreferencesPropagator {
    protected static final String NODES_QUALIFIER = "org.eclipse.php.core";
    protected HashMap listenersMap;
    protected boolean isInstalled;
    protected Object lock = new Object();

    public void addPropagatorListener(IPreferencesPropagatorListener iPreferencesPropagatorListener, String string) {
        ArrayList<IPreferencesPropagatorListener> arrayList = (ArrayList<IPreferencesPropagatorListener>)this.listenersMap.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<IPreferencesPropagatorListener>(5);
            this.listenersMap.put(string, arrayList);
        }
        if (!arrayList.contains(iPreferencesPropagatorListener)) {
            arrayList.add(iPreferencesPropagatorListener);
        }
    }

    public void removePropagatorListener(IPreferencesPropagatorListener iPreferencesPropagatorListener, String string) {
        List list = (List)this.listenersMap.get(string);
        if (list != null) {
            list.remove(iPreferencesPropagatorListener);
        }
    }

    public void setPropagatorListeners(List list, String string) {
        this.listenersMap.put(string, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getPropagatorListeners(String string) {
        Object object = this.lock;
        synchronized (object) {
            return (List)this.listenersMap.get(string);
        }
    }

    protected synchronized void install() {
        if (this.isInstalled) {
            return;
        }
        this.listenersMap = new HashMap();
        this.isInstalled = true;
    }

    protected synchronized void uninstall() {
        if (!this.isInstalled) {
            return;
        }
        this.listenersMap = null;
        this.isInstalled = false;
    }
}

