/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.documentModel.parser;

import java.io.IOException;
import java.io.Reader;
import javax.swing.text.Segment;
import org.eclipse.php.core.documentModel.parser.Scanner;
import org.eclipse.php.core.documentModel.parser.StateStack;
import org.eclipse.php.core.documentModel.parser.regions.PHPRegionTypes;
import org.eclipse.php.core.util.collections.IntHashtable;

public abstract class PhpLexer
implements Scanner,
PHPRegionTypes {
    private static final IntHashtable lexerStates = new IntHashtable(100);
    public static final int ST_PHP_BACKQUOTE = 8;
    public static final int ST_PHP_COMMENT = 16;
    public static final int ST_PHP_DOC_COMMENT = 18;
    public static final int ST_PHP_DOUBLE_QUOTES = 4;
    public static final int ST_PHP_HEREDOC = 12;
    public static final int ST_PHP_IN_SCRIPTING = 2;
    public static final int ST_PHP_LINE_COMMENT = 20;
    public static final int ST_PHP_SINGLE_QUOTE = 6;
    public static final int YYEOF = -1;
    protected boolean asp_tags = true;
    protected int defaultReturnValue = -1;
    protected int firstPos = -1;
    protected String heredoc = null;
    protected int heredoc_len = 0;
    protected StateStack phpStack;

    protected static final boolean isLowerCase(String string) {
        if (string == null) {
            return false;
        }
        int n = 0;
        while (n < string.length()) {
            if (!Character.isLowerCase(string.charAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean isPHPCommentState(String string) {
        return string == null ? false : PhpLexer.isPHPMultiLineCommentState(string) || PhpLexer.isPHPLineCommentState(string) || PhpLexer.isPHPDocState(string);
    }

    public static boolean isPHPDocState(String string) {
        return string == null ? false : string.startsWith("PHPDOC");
    }

    public static boolean isPHPLineCommentState(String string) {
        return string == "PHP_LINE_COMMENT";
    }

    public static boolean isPHPMultiLineCommentState(String string) {
        return string == "PHP_COMMENT" || string == "PHP_COMMENT_START" || string == "PHP_COMMENT_END";
    }

    public static boolean isPHPQuotesState(String string) {
        return string == "PHP_CONSTANT_ENCAPSED_STRING" || string == "PHP_HEREDOC_TAG";
    }

    public static final boolean isPHPRegularState(String string) {
        return !PhpLexer.isPHPCommentState(string) && !PhpLexer.isPHPQuotesState(string);
    }

    protected void beginState(int n) {
        this.yybegin(n);
    }

    private int buildStateKey() {
        int n = this.getYy_lexical_state();
        int n2 = 0;
        while (n2 < this.phpStack.size()) {
            n = 31 * n + this.phpStack.get(n2);
            ++n2;
        }
        if (this.heredoc != null) {
            n2 = 0;
            while (n2 < this.heredoc.length()) {
                n = 31 * n + this.heredoc.charAt(n2);
                ++n2;
            }
        }
        return n;
    }

    public Object createLexicalStateMemento() {
        int n = this.buildStateKey();
        Object object = lexerStates.get(n);
        if (object == null) {
            object = new BasicLexerState();
            if (this.getYy_lexical_state() == 12) {
                object = new HeredocState((BasicLexerState)object);
            }
            lexerStates.put(n, object);
        }
        return object;
    }

    public boolean getAspTags() {
        return this.asp_tags;
    }

    public Object getEndingState() throws IOException {
        this.lexToEnd();
        return this.createLexicalStateMemento();
    }

    public int getFirstIndex() {
        return this.firstPos;
    }

    public int getMarkedPos() {
        return this.getYy_markedPos();
    }

    public abstract int[] getParamenters();

    public void getText(int n, int n2, Segment segment) {
        if (n + n2 > this.getYy_endRead()) {
            throw new RuntimeException("bad segment !!");
        }
        segment.array = this.getYy_buffer();
        segment.offset = n;
        segment.count = n2;
    }

    public int getTokenStart() {
        return this.getYy_startRead() - this.getYy_pushBackPosition();
    }

    protected abstract char[] getYy_buffer();

    protected abstract int getYy_endRead();

    protected abstract int getYy_lexical_state();

    protected abstract int getYy_markedPos();

    protected abstract int getYy_pushBackPosition();

    protected abstract int getYy_startRead();

    public void initialize(int n) {
        this.phpStack = new StateStack();
        this.beginState(n);
    }

    public String lexToEnd() throws IOException {
        String string;
        String string2 = string = this.yylex();
        while (string != null) {
            string2 = string;
            string = this.yylex();
        }
        return string2;
    }

    public String lexToTokenAt(int n) throws IOException {
        if (this.firstPos + n < this.getYy_markedPos()) {
            throw new RuntimeException("Bad offset");
        }
        String string = this.yylex();
        while (this.getYy_markedPos() < this.firstPos + n && string != null) {
            string = this.yylex();
        }
        return string;
    }

    protected void popState() {
        this.yybegin(this.phpStack.popStack());
    }

    protected void pushState(int n) {
        this.phpStack.pushStack(this.getYy_lexical_state());
        this.yybegin(n);
    }

    public abstract void reset(char[] var1, int var2, int var3);

    public abstract void reset(Reader var1, char[] var2, int[] var3);

    public void reset(Segment segment) {
        this.reset(segment.array, segment.offset, segment.count);
    }

    public void setAspTags(boolean bl) {
        this.asp_tags = bl;
    }

    public void setState(Object object) {
        ((Scanner.LexerState)object).restoreState(this);
    }

    public abstract void yybegin(int var1);

    public abstract int yylength();

    public abstract String yytext();

    public abstract int yystate();

    private class BasicLexerState
    implements Scanner.LexerState {
        private final byte lexicalState;
        private StateStack phpStack;

        public BasicLexerState() {
            this.lexicalState = (byte)PhpLexer.this.getYy_lexical_state();
            if (!PhpLexer.this.phpStack.isEmpty()) {
                this.phpStack = PhpLexer.this.phpStack.createClone();
            }
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof BasicLexerState)) {
                return false;
            }
            BasicLexerState basicLexerState = (BasicLexerState)object;
            if (basicLexerState.lexicalState != this.lexicalState) {
                return false;
            }
            if (this.phpStack != null && !this.phpStack.equals(basicLexerState.phpStack)) {
                return false;
            }
            return this.phpStack == basicLexerState.phpStack;
        }

        public boolean equalsCurrentStack(Scanner.LexerState lexerState) {
            StateStack stateStack;
            if (lexerState == this) {
                return true;
            }
            if (lexerState == null) {
                return false;
            }
            if (!(lexerState instanceof BasicLexerState)) {
                return false;
            }
            BasicLexerState basicLexerState = (BasicLexerState)lexerState;
            if (basicLexerState.lexicalState != this.lexicalState) {
                return false;
            }
            StateStack stateStack2 = this.getActiveStack();
            return stateStack2 == (stateStack = basicLexerState.getActiveStack()) || stateStack2 != null && stateStack2.equals(stateStack);
        }

        public boolean equalsTop(Scanner.LexerState lexerState) {
            return lexerState != null && lexerState.getTopState() == this.lexicalState;
        }

        protected StateStack getActiveStack() {
            return this.phpStack;
        }

        public int getTopState() {
            return this.lexicalState;
        }

        public boolean isSubstateOf(int n) {
            if (this.lexicalState == n) {
                return true;
            }
            StateStack stateStack = this.getActiveStack();
            if (stateStack == null) {
                return false;
            }
            return stateStack.contains(n);
        }

        public void restoreState(Scanner scanner) {
            PhpLexer phpLexer = (PhpLexer)scanner;
            if (this.phpStack == null) {
                phpLexer.phpStack.clear();
            } else {
                phpLexer.phpStack.copyFrom(this.phpStack);
            }
            phpLexer.yybegin(this.lexicalState);
        }

        public String toString() {
            StateStack stateStack = this.getActiveStack();
            String string = stateStack == null ? "null" : stateStack.toString();
            return "Stack: " + string + ", currState: " + this.lexicalState;
        }
    }

    private class HeredocState
    implements Scanner.LexerState {
        private String myHeredoc;
        private BasicLexerState theState;

        public HeredocState(BasicLexerState basicLexerState) {
            this.theState = basicLexerState;
            this.myHeredoc = PhpLexer.this.heredoc;
        }

        public boolean equals(Object object) {
            return object != null && object instanceof HeredocState && ((HeredocState)object).theState.equals(this.theState) && ((HeredocState)object).myHeredoc.equals(this.myHeredoc);
        }

        public boolean equalsCurrentStack(Scanner.LexerState lexerState) {
            if (lexerState == this) {
                return true;
            }
            if (lexerState == null) {
                return false;
            }
            if (!(lexerState instanceof HeredocState)) {
                return false;
            }
            return this.theState.equals(((HeredocState)lexerState).theState);
        }

        public boolean equalsTop(Scanner.LexerState lexerState) {
            return this.theState.equalsTop(lexerState);
        }

        public int getTopState() {
            return this.theState.getTopState();
        }

        public boolean isSubstateOf(int n) {
            return this.theState.isSubstateOf(n);
        }

        public void restoreState(Scanner scanner) {
            PhpLexer phpLexer = (PhpLexer)scanner;
            this.theState.restoreState(phpLexer);
            phpLexer.heredoc = this.myHeredoc;
            phpLexer.heredoc_len = this.myHeredoc.length();
        }
    }
}

