/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.phpModel.parser.codeDataDB;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.php.core.phpModel.parser.codeDataDB.CodeDataDB;
import org.eclipse.php.core.phpModel.phpElementData.CodeData;

public class TreeCodeDataDB
implements CodeDataDB {
    private List chachedList = null;
    private final Set sortedData = new TreeSet();
    private final Map treeDatabase = new HashMap(1000);

    public synchronized void addCodeData(CodeData codeData) {
        this.chachedList = null;
        String string = this.getCodeDataIdentifier(codeData.getName());
        ArrayList<CodeData> arrayList = (ArrayList<CodeData>)this.treeDatabase.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<CodeData>();
            this.treeDatabase.put(string, arrayList);
        } else {
            arrayList.remove(codeData);
        }
        arrayList.add(codeData);
        this.sortedData.add(codeData);
    }

    public synchronized List asList() {
        if (this.chachedList != null) {
            return this.chachedList;
        }
        this.chachedList = Arrays.asList(this.sortedData.toArray());
        return this.chachedList;
    }

    public synchronized void clear() {
        this.chachedList = null;
        this.treeDatabase.clear();
        this.sortedData.clear();
    }

    public synchronized List getCodeData(String string) {
        if (string == null) {
            return null;
        }
        return (List)this.treeDatabase.get(this.getCodeDataIdentifier(string));
    }

    private String getCodeDataIdentifier(String string) {
        return string.trim().toLowerCase();
    }

    public synchronized void removeCodeData(CodeData codeData) {
        this.chachedList = null;
        String string = this.getCodeDataIdentifier(codeData.getName());
        ArrayList arrayList = (ArrayList)this.treeDatabase.get(string);
        if (arrayList == null) {
            return;
        }
        arrayList.remove(codeData);
        if (arrayList.isEmpty()) {
            this.treeDatabase.remove(arrayList);
        }
        this.sortedData.remove(codeData);
    }
}

