/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IResource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSStorage;

public class CRLFDetectInputStream
extends FilterInputStream {
    private boolean previousCR;
    private String filename;
    private boolean reported = false;

    protected CRLFDetectInputStream(InputStream in, ICVSStorage file) {
        super(in);
        try {
            this.filename = this.getFileName(file);
        }
        catch (CVSException cVSException) {
            this.filename = file.getName();
        }
    }

    private String getFileName(ICVSStorage storage) throws CVSException {
        String fileName;
        if (storage instanceof ICVSFile) {
            ICVSFile file = (ICVSFile)storage;
            fileName = file.getRepositoryRelativePath();
            if (fileName == null) {
                IResource resource = file.getIResource();
                fileName = resource == null ? file.getName() : file.getIResource().getFullPath().toString();
            }
        } else {
            fileName = storage.getName();
        }
        return fileName;
    }

    public int read() throws IOException {
        int next = this.in.read();
        if (next != -1) {
            this.testForCRLF((byte)next);
        }
        return next;
    }

    public int read(byte[] buffer, int off, int len) throws IOException {
        int count = super.read(buffer, off, len);
        int i = off;
        while (i < count) {
            this.testForCRLF(buffer[i]);
            ++i;
        }
        return count;
    }

    private void testForCRLF(byte next) {
        if (this.reported) {
            return;
        }
        if (this.previousCR && next == 10) {
            CVSProviderPlugin.log(2, NLS.bind((String)CVSMessages.CRLFDetectInputStream_0, (Object[])new String[]{this.filename}), null);
            this.reported = true;
        }
        this.previousCR = next == 13;
    }
}

