/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.search;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.PHPUIMessages;
import org.eclipse.php.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.ui.actions.SelectionConverter;
import org.eclipse.php.ui.PHPUiPlugin;
import org.eclipse.php.ui.editor.PHPStructuredEditor;
import org.eclipse.php.ui.search.IPHPSearchConstants;
import org.eclipse.php.ui.search.IPHPSearchScope;
import org.eclipse.php.ui.search.Messages;
import org.eclipse.php.ui.search.PHPSearchQuery;
import org.eclipse.php.ui.search.PHPSearchScopeFactory;
import org.eclipse.php.ui.search.PatternQuerySpecification;
import org.eclipse.php.ui.search.QuerySpecification;
import org.eclipse.php.ui.search.SearchUtil;
import org.eclipse.php.ui.util.EditorUtility;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;

public class PHPSearchPage
extends DialogPage
implements ISearchPage,
IPHPSearchConstants {
    private static final int HISTORY_SIZE = 12;
    private static final String PAGE_NAME = "PHPSearchPage";
    private static final String STORE_CASE_SENSITIVE = "CASE_SENSITIVE";
    private static final String STORE_HISTORY = "HISTORY";
    private static final String STORE_HISTORY_SIZE = "HISTORY_SIZE";
    private final List fPreviousSearchPatterns;
    private SearchPatternData fInitialData;
    private PHPCodeData fPhpElement;
    private boolean fFirstTime = true;
    private IDialogSettings fDialogSettings;
    private boolean fIsCaseSensitive;
    private Combo fPattern;
    private ISearchPageContainer fContainer;
    private Button fCaseSensitive;
    private Button[] fSearchFor;
    private String[] fSearchForText = new String[]{PHPUIMessages.SearchPage_searchFor_class, PHPUIMessages.SearchPage_searchFor_function, PHPUIMessages.SearchPage_searchFor_constant};

    public PHPSearchPage() {
        this.fPreviousSearchPatterns = new ArrayList();
    }

    public PHPSearchPage(String string) {
        super(string);
        this.fPreviousSearchPatterns = new ArrayList();
    }

    public PHPSearchPage(String string, ImageDescriptor imageDescriptor) {
        super(string, imageDescriptor);
        this.fPreviousSearchPatterns = new ArrayList();
    }

    public boolean performAction() {
        return this.performNewSearch();
    }

    public void setContainer(ISearchPageContainer iSearchPageContainer) {
        this.fContainer = iSearchPageContainer;
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        this.readConfiguration();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 10;
        composite2.setLayout((Layout)gridLayout);
        Control control = this.createExpression(composite2);
        control.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        Label label = new Label(composite2, 0);
        label.setVisible(false);
        GridData gridData = new GridData(4, 4, false, false, 2, 1);
        gridData.heightHint = this.convertHeightInCharsToPixels(1) / 3;
        label.setLayoutData((Object)gridData);
        Control control2 = this.createSearchFor(composite2);
        control2.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (PHPSearchPage.this.getSearchFor() == PHPSearchPage.this.fInitialData.getSearchFor()) {
                    PHPSearchPage.this.fPhpElement = PHPSearchPage.this.fInitialData.getPHPElement();
                } else {
                    PHPSearchPage.this.fPhpElement = null;
                }
                PHPSearchPage.this.doPatternModified();
            }
        };
        this.fSearchFor[0].addSelectionListener((SelectionListener)selectionAdapter);
        this.fSearchFor[1].addSelectionListener((SelectionListener)selectionAdapter);
        this.fSearchFor[2].addSelectionListener((SelectionListener)selectionAdapter);
        this.setControl((Control)composite2);
        Dialog.applyDialogFont((Control)composite2);
    }

    private boolean performNewSearch() {
        Object object;
        Object object2;
        SearchPatternData searchPatternData = this.getPatternData();
        IPHPSearchScope iPHPSearchScope = null;
        String string = "";
        PHPSearchScopeFactory pHPSearchScopeFactory = PHPSearchScopeFactory.getInstance();
        int n = this.getContainer().getSelectedScope();
        switch (n) {
            case 0: {
                string = PHPUIMessages.WorkspaceScope;
                iPHPSearchScope = pHPSearchScopeFactory.createWorkspaceSearchScope(this.getSearchFor());
                break;
            }
            case 1: {
                string = PHPUIMessages.SelectionScope;
                iPHPSearchScope = pHPSearchScopeFactory.createSelectedPHPSearchScope(this.getSearchFor(), this.getContainer().getSelection());
                break;
            }
            case 3: {
                iPHPSearchScope = pHPSearchScopeFactory.createSelectedPHPProjectSearchScope(this.getSearchFor(), this.getContainer().getSelection());
                object2 = PHPSearchScopeFactory.getInstance().getProjects(iPHPSearchScope);
                if (((IProject[])object2).length >= 1) {
                    if (((IProject[])object2).length == 1) {
                        string = Messages.format(PHPUIMessages.EnclosingProjectScope, object2[0].getName());
                        break;
                    }
                    string = Messages.format(PHPUIMessages.EnclosingProjectsScope, object2[0].getName());
                    break;
                }
                string = Messages.format(PHPUIMessages.EnclosingProjectScope, "");
                break;
            }
            case 2: {
                object = this.getContainer().getSelectedWorkingSets();
                if (object == null || ((IWorkingSet[])object).length < 1) {
                    return false;
                }
                string = Messages.format(PHPUIMessages.WorkingSetScope, SearchUtil.toString(object));
                iPHPSearchScope = pHPSearchScopeFactory.createWorkingSetSearchScope(this.getSearchFor(), this.getContainer().getSelectedWorkingSets());
            }
        }
        object2 = null;
        object2 = new PatternQuerySpecification(searchPatternData.getPattern(), searchPatternData.getSearchFor(), searchPatternData.isCaseSensitive(), iPHPSearchScope, string);
        searchPatternData.setPHPElement(null);
        object = new PHPSearchQuery((QuerySpecification)object2);
        NewSearchUI.activateSearchResultView();
        NewSearchUI.runQueryInBackground((ISearchQuery)object);
        return true;
    }

    private String[] getPreviousSearchPatterns() {
        int n = this.fPreviousSearchPatterns.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = ((SearchPatternData)this.fPreviousSearchPatterns.get(n2)).getPattern();
            ++n2;
        }
        return stringArray;
    }

    private int getSearchFor() {
        int n = 0;
        while (n < this.fSearchFor.length) {
            if (this.fSearchFor[n].getSelection()) {
                return n;
            }
            ++n;
        }
        Assert.isTrue((boolean)false, (String)"shouldNeverHappen");
        return -1;
    }

    private String getPattern() {
        return this.fPattern.getText();
    }

    private SearchPatternData findInPrevious(String string) {
        Iterator iterator = this.fPreviousSearchPatterns.iterator();
        while (iterator.hasNext()) {
            SearchPatternData searchPatternData = (SearchPatternData)iterator.next();
            if (!string.equals(searchPatternData.getPattern())) continue;
            return searchPatternData;
        }
        return null;
    }

    private SearchPatternData getPatternData() {
        String string = this.getPattern();
        SearchPatternData searchPatternData = this.findInPrevious(string);
        if (searchPatternData != null) {
            this.fPreviousSearchPatterns.remove(searchPatternData);
        }
        searchPatternData = new SearchPatternData(this.getSearchFor(), 3, string, this.fCaseSensitive.getSelection(), this.fPhpElement, this.getContainer().getSelectedScope(), this.getContainer().getSelectedWorkingSets());
        this.fPreviousSearchPatterns.add(0, searchPatternData);
        return searchPatternData;
    }

    public void setVisible(boolean bl) {
        if (bl && this.fPattern != null) {
            if (this.fFirstTime) {
                this.fFirstTime = false;
                this.fPattern.setItems(this.getPreviousSearchPatterns());
                this.initSelections();
            }
            this.fPattern.setFocus();
        }
        this.updateOKStatus();
        super.setVisible(bl);
    }

    public boolean isValid() {
        return true;
    }

    private Control createExpression(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 16384);
        label.setText(PHPUIMessages.SearchPage_expression_label);
        label.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        this.fPattern = new Combo(composite2, 2052);
        this.fPattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PHPSearchPage.this.handlePatternSelected();
                PHPSearchPage.this.updateOKStatus();
            }
        });
        this.fPattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                PHPSearchPage.this.doPatternModified();
                PHPSearchPage.this.updateOKStatus();
            }
        });
        GridData gridData = new GridData(4, 4, true, false, 1, 1);
        gridData.widthHint = this.convertWidthInCharsToPixels(50);
        this.fPattern.setLayoutData((Object)gridData);
        this.fCaseSensitive = new Button(composite2, 32);
        this.fCaseSensitive.setText(PHPUIMessages.SearchPage_expression_caseSensitive);
        this.fCaseSensitive.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PHPSearchPage.this.fIsCaseSensitive = PHPSearchPage.this.fCaseSensitive.getSelection();
            }
        });
        this.fCaseSensitive.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        return composite2;
    }

    final void updateOKStatus() {
        boolean bl = this.isValidSearchPattern();
        this.getContainer().setPerformActionEnabled(bl);
    }

    private boolean isValidSearchPattern() {
        return this.getPattern().length() != 0;
    }

    public void dispose() {
        this.writeConfiguration();
        super.dispose();
    }

    private void doPatternModified() {
        if (this.fInitialData != null && this.getPattern().equals(this.fInitialData.getPattern()) && this.fInitialData.getPHPElement() != null && this.fInitialData.getSearchFor() == this.getSearchFor()) {
            this.fCaseSensitive.setEnabled(false);
            this.fCaseSensitive.setSelection(true);
            this.fPhpElement = this.fInitialData.getPHPElement();
        } else {
            this.fCaseSensitive.setEnabled(true);
            this.fCaseSensitive.setSelection(this.fIsCaseSensitive);
            this.fPhpElement = null;
        }
    }

    private void handlePatternSelected() {
        int n = this.fPattern.getSelectionIndex();
        if (n < 0 || n >= this.fPreviousSearchPatterns.size()) {
            return;
        }
        SearchPatternData searchPatternData = (SearchPatternData)this.fPreviousSearchPatterns.get(n);
        this.setSearchFor(searchPatternData.getSearchFor());
        this.fPattern.setText(searchPatternData.getPattern());
        this.fIsCaseSensitive = searchPatternData.isCaseSensitive();
        this.fPhpElement = searchPatternData.getPHPElement();
        this.fCaseSensitive.setEnabled(this.fPhpElement == null);
        this.fCaseSensitive.setSelection(searchPatternData.isCaseSensitive());
        if (searchPatternData.getWorkingSets() != null) {
            this.getContainer().setSelectedWorkingSets(searchPatternData.getWorkingSets());
        } else {
            this.getContainer().setSelectedScope(searchPatternData.getScope());
        }
        this.fInitialData = searchPatternData;
    }

    private void setSearchFor(int n) {
        int n2 = 0;
        while (n2 < this.fSearchFor.length) {
            this.fSearchFor[n2].setSelection(n == n2);
            ++n2;
        }
    }

    private Control createSearchFor(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(PHPUIMessages.SearchPage_searchFor_label);
        group.setLayout((Layout)new GridLayout(3, true));
        this.fSearchFor = new Button[this.fSearchForText.length];
        int n = 0;
        while (n < this.fSearchForText.length) {
            Button button = new Button((Composite)group, 16);
            button.setText(this.fSearchForText[n]);
            button.setSelection(n == 1);
            button.setLayoutData((Object)new GridData());
            this.fSearchFor[n] = button;
            ++n;
        }
        Label label = new Label((Composite)group, 0);
        label.setVisible(false);
        label.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        return group;
    }

    private void initSelections() {
        PHPCodeData[] pHPCodeDataArray;
        ISelection iSelection = this.getContainer().getSelection();
        SearchPatternData searchPatternData = null;
        if (iSelection instanceof ITextSelection) {
            IEditorPart iEditorPart = this.getActiveEditor();
            PHPStructuredEditor pHPStructuredEditor = EditorUtility.getPHPStructuredEditor((IWorkbenchPart)iEditorPart);
            if (pHPStructuredEditor != null) {
                try {
                    PHPCodeData[] pHPCodeDataArray2 = SelectionConverter.codeResolve(pHPStructuredEditor);
                    if (pHPCodeDataArray2 != null && pHPCodeDataArray2.length > 0) {
                        searchPatternData = this.determineInitValuesFrom(pHPCodeDataArray2[0]);
                    }
                }
                catch (Exception exception) {}
            }
            if (searchPatternData == null) {
                searchPatternData = this.trySimpleTextSelection((ITextSelection)iSelection);
            }
        } else if (iSelection instanceof IStructuredSelection && (pHPCodeDataArray = SelectionConverter.getElements((IStructuredSelection)iSelection)) != null && pHPCodeDataArray.length > 0) {
            searchPatternData = this.determineInitValuesFrom(pHPCodeDataArray[0]);
        }
        if (searchPatternData == null) {
            searchPatternData = this.getDefaultInitValues();
        }
        this.fInitialData = searchPatternData;
        this.fPhpElement = searchPatternData.getPHPElement();
        this.fCaseSensitive.setSelection(searchPatternData.isCaseSensitive());
        this.fCaseSensitive.setEnabled(this.fPhpElement == null);
        this.setSearchFor(searchPatternData.getSearchFor());
        this.fPattern.setText(searchPatternData.getPattern());
    }

    private SearchPatternData determineInitValuesFrom(PHPCodeData pHPCodeData) {
        if (pHPCodeData instanceof PHPClassData) {
            return new SearchPatternData(0, 3, false, pHPCodeData.getName(), pHPCodeData);
        }
        if (pHPCodeData instanceof PHPFunctionData) {
            return new SearchPatternData(1, 3, false, pHPCodeData.getName(), pHPCodeData);
        }
        if (pHPCodeData instanceof PHPConstantData) {
            return new SearchPatternData(2, 3, true, pHPCodeData.getName(), pHPCodeData);
        }
        return new SearchPatternData(0, 3, false, pHPCodeData.getName(), pHPCodeData);
    }

    private SearchPatternData trySimpleTextSelection(ITextSelection iTextSelection) {
        String string = iTextSelection.getText();
        if (string != null && string.length() > 0) {
            int n = 0;
            while (n < string.length() && !PHPSearchPage.isLineDelimiterChar(string.charAt(n))) {
                ++n;
            }
            if (n > 0) {
                return new SearchPatternData(1, 3, this.fIsCaseSensitive, string.substring(0, n), null);
            }
        }
        return null;
    }

    private static boolean isLineDelimiterChar(char c) {
        return c == '\n' || c == '\r';
    }

    private SearchPatternData getDefaultInitValues() {
        if (!this.fPreviousSearchPatterns.isEmpty()) {
            return (SearchPatternData)this.fPreviousSearchPatterns.get(0);
        }
        return new SearchPatternData(1, 3, this.fIsCaseSensitive, "", null);
    }

    private ISearchPageContainer getContainer() {
        return this.fContainer;
    }

    private IEditorPart getActiveEditor() {
        IWorkbenchPage iWorkbenchPage = PHPUiPlugin.getActivePage();
        if (iWorkbenchPage != null) {
            return iWorkbenchPage.getActiveEditor();
        }
        return null;
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings iDialogSettings = PHPUiPlugin.getDefault().getDialogSettings();
        this.fDialogSettings = iDialogSettings.getSection(PAGE_NAME);
        if (this.fDialogSettings == null) {
            this.fDialogSettings = iDialogSettings.addNewSection(PAGE_NAME);
        }
        return this.fDialogSettings;
    }

    private void readConfiguration() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        this.fIsCaseSensitive = iDialogSettings.getBoolean(STORE_CASE_SENSITIVE);
        try {
            int n = iDialogSettings.getInt(STORE_HISTORY_SIZE);
            int n2 = 0;
            while (n2 < n) {
                SearchPatternData searchPatternData;
                IDialogSettings iDialogSettings2 = iDialogSettings.getSection(STORE_HISTORY + n2);
                if (iDialogSettings2 != null && (searchPatternData = SearchPatternData.create(iDialogSettings2)) != null) {
                    this.fPreviousSearchPatterns.add(searchPatternData);
                }
                ++n2;
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }

    private void writeConfiguration() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        iDialogSettings.put(STORE_CASE_SENSITIVE, this.fIsCaseSensitive);
        int n = Math.min(this.fPreviousSearchPatterns.size(), 12);
        iDialogSettings.put(STORE_HISTORY_SIZE, n);
        int n2 = 0;
        while (n2 < n) {
            IDialogSettings iDialogSettings2 = iDialogSettings.addNewSection(STORE_HISTORY + n2);
            SearchPatternData searchPatternData = (SearchPatternData)this.fPreviousSearchPatterns.get(n2);
            searchPatternData.store(iDialogSettings2);
            ++n2;
        }
    }

    private static class SearchPatternData {
        private int searchFor;
        private int limitTo;
        private String pattern;
        private boolean isCaseSensitive;
        private PHPCodeData phpElement;
        private int scope;
        private IWorkingSet[] workingSets;

        public SearchPatternData(int n, int n2, boolean bl, String string, PHPCodeData pHPCodeData) {
            this(n, n2, string, bl, pHPCodeData, 0, null);
        }

        public SearchPatternData(int n, int n2, String string, boolean bl, PHPCodeData pHPCodeData, int n3, IWorkingSet[] iWorkingSetArray) {
            this.searchFor = n;
            this.limitTo = n2;
            this.pattern = string;
            this.isCaseSensitive = bl;
            this.phpElement = pHPCodeData;
            this.scope = n3;
            this.workingSets = iWorkingSetArray;
        }

        public void setPHPElement(PHPCodeData pHPCodeData) {
            this.phpElement = pHPCodeData;
        }

        public PHPCodeData getPHPElement() {
            return this.phpElement;
        }

        public boolean isCaseSensitive() {
            return this.isCaseSensitive;
        }

        public String getPattern() {
            return this.pattern;
        }

        public int getScope() {
            return this.scope;
        }

        public int getSearchFor() {
            return this.searchFor;
        }

        public IWorkingSet[] getWorkingSets() {
            return this.workingSets;
        }

        public void store(IDialogSettings iDialogSettings) {
            iDialogSettings.put("searchFor", this.searchFor);
            iDialogSettings.put("scope", this.scope);
            iDialogSettings.put("pattern", this.pattern);
            iDialogSettings.put("limitTo", this.limitTo);
            iDialogSettings.put("phpElement", this.phpElement != null ? this.phpElement.getName() : "");
            iDialogSettings.put("isCaseSensitive", this.isCaseSensitive);
            if (this.workingSets != null) {
                String[] stringArray = new String[this.workingSets.length];
                int n = 0;
                while (n < this.workingSets.length) {
                    stringArray[n] = this.workingSets[n].getId();
                    ++n;
                }
                iDialogSettings.put("workingSets", stringArray);
            } else {
                iDialogSettings.put("workingSets", new String[0]);
            }
        }

        public static SearchPatternData create(IDialogSettings iDialogSettings) {
            int n;
            String string = iDialogSettings.get("pattern");
            if (string.length() == 0) {
                return null;
            }
            String[] stringArray = iDialogSettings.getArray("workingSets");
            IWorkingSet[] iWorkingSetArray = null;
            if (stringArray != null && stringArray.length > 0) {
                IWorkingSetManager iWorkingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
                iWorkingSetArray = new IWorkingSet[stringArray.length];
                n = 0;
                while (iWorkingSetArray != null && n < stringArray.length) {
                    iWorkingSetArray[n] = iWorkingSetManager.getWorkingSet(stringArray[n]);
                    if (iWorkingSetArray[n] == null) {
                        iWorkingSetArray = null;
                    }
                    ++n;
                }
            }
            try {
                int n2 = iDialogSettings.getInt("searchFor");
                n = iDialogSettings.getInt("scope");
                int n3 = iDialogSettings.getInt("limitTo");
                boolean bl = iDialogSettings.getBoolean("isCaseSensitive");
                return new SearchPatternData(n2, n3, string, bl, null, n, iWorkingSetArray);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
    }
}

