/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class JavaProjectWizardFirstPage
extends WizardPage {
    private NameGroup fNameGroup;
    private LocationGroup fLocationGroup;
    private LayoutGroup fLayoutGroup;
    private JREGroup fJREGroup;
    private DetectGroup fDetectGroup;
    private Validator fValidator;
    private String fInitialName;
    private static final String PAGE_NAME = NewWizardMessages.JavaProjectWizardFirstPage_page_pageName;

    public JavaProjectWizardFirstPage() {
        super(PAGE_NAME);
        this.setPageComplete(false);
        this.setTitle(NewWizardMessages.JavaProjectWizardFirstPage_page_title);
        this.setDescription(NewWizardMessages.JavaProjectWizardFirstPage_page_description);
        this.fInitialName = "";
        this.initializeDefaultVM();
    }

    private void initializeDefaultVM() {
        JavaRuntime.getDefaultVMInstall();
    }

    public void setName(String name) {
        this.fInitialName = name;
        if (this.fNameGroup != null) {
            this.fNameGroup.setName(name);
        }
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)this.initGridLayout(new GridLayout(1, false), true));
        composite.setLayoutData((Object)new GridData(256));
        this.fNameGroup = new NameGroup(composite, this.fInitialName);
        this.fLocationGroup = new LocationGroup(composite);
        this.fJREGroup = new JREGroup(composite);
        this.fLayoutGroup = new LayoutGroup(composite);
        this.fDetectGroup = new DetectGroup(composite);
        this.fNameGroup.addObserver(this.fLocationGroup);
        this.fDetectGroup.addObserver(this.fLayoutGroup);
        this.fDetectGroup.addObserver(this.fJREGroup);
        this.fLocationGroup.addObserver(this.fDetectGroup);
        this.fNameGroup.notifyObservers();
        this.fValidator = new Validator();
        this.fNameGroup.addObserver(this.fValidator);
        this.fLocationGroup.addObserver(this.fValidator);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.new_javaproject_wizard_page_context");
    }

    public IPath getLocationPath() {
        return this.fLocationGroup.getLocation();
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.fNameGroup.getName());
    }

    public boolean isInWorkspace() {
        return this.fLocationGroup.isInWorkspace();
    }

    public String getProjectName() {
        return this.fNameGroup.getName();
    }

    public boolean getDetect() {
        return this.fDetectGroup.mustDetect();
    }

    public boolean isSrcBin() {
        return this.fLayoutGroup.isSrcBin();
    }

    public IVMInstall getJVM() {
        return this.fJREGroup.getSelectedJVM();
    }

    public String getCompilerCompliance() {
        return this.fJREGroup.getSelectedCompilerCompliance();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fNameGroup.postSetFocus();
        }
    }

    protected GridLayout initGridLayout(GridLayout layout, boolean margins) {
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        if (margins) {
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        } else {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        return layout;
    }

    protected GridData setButtonLayoutData(Button button) {
        return super.setButtonLayoutData(button);
    }

    private final class DetectGroup
    extends Observable
    implements Observer,
    SelectionListener {
        private final Link fHintText;
        private boolean fDetect;

        public DetectGroup(Composite composite) {
            Link jre50Text = new Link(composite, 64);
            jre50Text.setFont(composite.getFont());
            jre50Text.addSelectionListener((SelectionListener)this);
            GridData gridData = new GridData(4, 4, true, true);
            gridData.widthHint = JavaProjectWizardFirstPage.this.convertWidthInCharsToPixels(50);
            jre50Text.setLayoutData((Object)gridData);
            this.fHintText = jre50Text;
            this.handlePossibleJVMChange();
        }

        public void handlePossibleJVMChange() {
            IVMInstall selectedJVM;
            String selectedCompliance = JavaProjectWizardFirstPage.this.fJREGroup.getSelectedCompilerCompliance();
            if (selectedCompliance == null) {
                selectedCompliance = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance");
            }
            if ((selectedJVM = JavaProjectWizardFirstPage.this.fJREGroup.getSelectedJVM()) == null) {
                selectedJVM = JavaRuntime.getDefaultVMInstall();
            }
            String jvmCompliance = "1.4";
            if (selectedJVM instanceof IVMInstall2) {
                jvmCompliance = JavaModelUtil.getCompilerCompliance((IVMInstall2)selectedJVM, "1.4");
            }
            if (!selectedCompliance.equals(jvmCompliance) && (JavaModelUtil.is50OrHigher(selectedCompliance) || JavaModelUtil.is50OrHigher(jvmCompliance))) {
                if (selectedCompliance.equals("1.5")) {
                    selectedCompliance = "5.0";
                } else if (selectedCompliance.equals("1.6")) {
                    selectedCompliance = "6.0";
                }
                this.fHintText.setText(Messages.format(NewWizardMessages.JavaProjectWizardFirstPage_DetectGroup_jre_message, new String[]{selectedCompliance, jvmCompliance}));
                this.fHintText.setVisible(true);
            } else {
                this.fHintText.setVisible(false);
            }
        }

        public void update(Observable o, Object arg) {
            if (o instanceof LocationGroup) {
                boolean oldDetectState = this.fDetect;
                if (JavaProjectWizardFirstPage.this.fLocationGroup.isInWorkspace()) {
                    String name = JavaProjectWizardFirstPage.this.getProjectName();
                    if (name.length() == 0 || JavaPlugin.getWorkspace().getRoot().findMember(name) != null) {
                        this.fDetect = false;
                    } else {
                        File directory = JavaProjectWizardFirstPage.this.fLocationGroup.getLocation().append(JavaProjectWizardFirstPage.this.getProjectName()).toFile();
                        this.fDetect = directory.isDirectory();
                    }
                } else {
                    File directory = JavaProjectWizardFirstPage.this.fLocationGroup.getLocation().toFile();
                    this.fDetect = directory.isDirectory();
                }
                if (oldDetectState != this.fDetect) {
                    this.setChanged();
                    this.notifyObservers();
                    if (this.fDetect) {
                        this.fHintText.setVisible(true);
                        this.fHintText.setText(NewWizardMessages.JavaProjectWizardFirstPage_DetectGroup_message);
                    } else {
                        this.handlePossibleJVMChange();
                    }
                }
            }
        }

        public boolean mustDetect() {
            return this.fDetect;
        }

        public void widgetSelected(SelectionEvent e) {
            this.widgetDefaultSelected(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            String jreID = "org.eclipse.jdt.debug.ui.preferences.VMPreferencePage";
            String complianceId = "org.eclipse.jdt.ui.preferences.CompliancePreferencePage";
            HashMap<String, Boolean> data = new HashMap<String, Boolean>();
            data.put("PropertyAndPreferencePage.nolink", Boolean.TRUE);
            PreferencesUtil.createPreferenceDialogOn((Shell)JavaProjectWizardFirstPage.this.getShell(), (String)complianceId, (String[])new String[]{jreID, complianceId}, data).open();
            JavaProjectWizardFirstPage.this.fJREGroup.handlePossibleJVMChange();
            this.handlePossibleJVMChange();
        }
    }

    private final class JREGroup
    implements Observer,
    SelectionListener,
    IDialogFieldListener {
        private final SelectionButtonDialogField fUseDefaultJRE;
        private final SelectionButtonDialogField fUseProjectJRE;
        private final ComboDialogField fJRECombo;
        private final Group fGroup;
        private String[] fComplianceLabels;
        private String[] fComplianceData;
        private final Link fPreferenceLink;
        private IVMInstall[] fInstalledJVMs;

        public JREGroup(Composite composite) {
            this.fGroup = new Group(composite, 0);
            this.fGroup.setFont(composite.getFont());
            this.fGroup.setLayoutData((Object)new GridData(768));
            this.fGroup.setLayout((Layout)JavaProjectWizardFirstPage.this.initGridLayout(new GridLayout(3, false), true));
            this.fGroup.setText(NewWizardMessages.JavaProjectWizardFirstPage_JREGroup_title);
            this.fUseDefaultJRE = new SelectionButtonDialogField(16);
            this.fUseDefaultJRE.setLabelText(this.getDefaultJVMLabel());
            this.fUseDefaultJRE.doFillIntoGrid((Composite)this.fGroup, 2);
            this.fPreferenceLink = new Link((Composite)this.fGroup, 0);
            this.fPreferenceLink.setFont(this.fGroup.getFont());
            this.fPreferenceLink.setText(NewWizardMessages.JavaProjectWizardFirstPage_JREGroup_link_description);
            this.fPreferenceLink.setLayoutData((Object)new GridData(3, 2, false, false));
            this.fPreferenceLink.addSelectionListener((SelectionListener)this);
            this.fUseProjectJRE = new SelectionButtonDialogField(16);
            this.fUseProjectJRE.setLabelText(NewWizardMessages.JavaProjectWizardFirstPage_JREGroup_specific_compliance);
            this.fUseProjectJRE.doFillIntoGrid((Composite)this.fGroup, 1);
            this.fUseProjectJRE.setDialogFieldListener(this);
            this.fJRECombo = new ComboDialogField(8);
            this.fillInstalledJREs(this.fJRECombo);
            this.fJRECombo.setDialogFieldListener(this);
            Combo comboControl = this.fJRECombo.getComboControl((Composite)this.fGroup);
            comboControl.setLayoutData((Object)new GridData(1, 2, true, false));
            comboControl.setVisibleItemCount(20);
            DialogField.createEmptySpace((Composite)this.fGroup);
            this.fUseDefaultJRE.setSelection(true);
            this.fJRECombo.setEnabled(this.fUseProjectJRE.isSelected());
        }

        private void fillInstalledJREs(ComboDialogField comboField) {
            String selectedItem = null;
            int selectionIndex = -1;
            if (this.fUseProjectJRE.isSelected() && (selectionIndex = comboField.getSelectionIndex()) != -1) {
                selectedItem = comboField.getItems()[selectionIndex];
            }
            this.fInstalledJVMs = this.getWorkspaceJREs();
            Arrays.sort(this.fInstalledJVMs, new Comparator(this){
                final /* synthetic */ JREGroup this$1;
                {
                    this.this$1 = jREGroup;
                }

                public int compare(Object arg0, Object arg1) {
                    IVMInstall i0 = (IVMInstall)arg0;
                    IVMInstall i1 = (IVMInstall)arg1;
                    if (i1 instanceof IVMInstall2 && i0 instanceof IVMInstall2) {
                        String cc0 = JavaModelUtil.getCompilerCompliance((IVMInstall2)i0, "1.4");
                        String cc1 = JavaModelUtil.getCompilerCompliance((IVMInstall2)i1, "1.4");
                        int result = cc1.compareTo(cc0);
                        if (result == 0) {
                            result = i0.getName().compareTo(i1.getName());
                        }
                        return result;
                    }
                    return i0.getName().compareTo(i1.getName());
                }
            });
            selectionIndex = -1;
            this.fComplianceLabels = new String[this.fInstalledJVMs.length];
            this.fComplianceData = new String[this.fInstalledJVMs.length];
            int i = 0;
            while (i < this.fInstalledJVMs.length) {
                this.fComplianceLabels[i] = this.fInstalledJVMs[i].getName();
                if (selectedItem != null && this.fComplianceLabels[i].equals(selectedItem)) {
                    selectionIndex = i;
                }
                this.fComplianceData[i] = this.fInstalledJVMs[i] instanceof IVMInstall2 ? JavaModelUtil.getCompilerCompliance((IVMInstall2)this.fInstalledJVMs[i], "1.4") : "1.4";
                ++i;
            }
            comboField.setItems(this.fComplianceLabels);
            if (selectionIndex == -1) {
                this.fJRECombo.selectItem(this.getDefaultJVMName());
            } else {
                this.fJRECombo.selectItem(selectedItem);
            }
        }

        private IVMInstall[] getWorkspaceJREs() {
            ArrayList<VMStandin> standins = new ArrayList<VMStandin>();
            IVMInstallType[] types = JavaRuntime.getVMInstallTypes();
            int i = 0;
            while (i < types.length) {
                IVMInstallType type = types[i];
                IVMInstall[] installs = type.getVMInstalls();
                int j = 0;
                while (j < installs.length) {
                    IVMInstall install = installs[j];
                    standins.add(new VMStandin(install));
                    ++j;
                }
                ++i;
            }
            return standins.toArray(new IVMInstall[standins.size()]);
        }

        private String getDefaultJVMName() {
            return JavaRuntime.getDefaultVMInstall().getName();
        }

        private String getDefaultJVMLabel() {
            return Messages.format(NewWizardMessages.JavaProjectWizardFirstPage_JREGroup_default_compliance, this.getDefaultJVMName());
        }

        public void update(Observable o, Object arg) {
            this.updateEnableState();
        }

        private void updateEnableState() {
            boolean detect = JavaProjectWizardFirstPage.this.fDetectGroup.mustDetect();
            this.fUseDefaultJRE.setEnabled(!detect);
            this.fUseProjectJRE.setEnabled(!detect);
            this.fJRECombo.setEnabled(!detect && this.fUseProjectJRE.isSelected());
            this.fPreferenceLink.setEnabled(!detect);
            this.fGroup.setEnabled(!detect);
        }

        public void widgetSelected(SelectionEvent e) {
            this.widgetDefaultSelected(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            String jreID = "org.eclipse.jdt.debug.ui.preferences.VMPreferencePage";
            String complianceId = "org.eclipse.jdt.ui.preferences.CompliancePreferencePage";
            HashMap<String, Boolean> data = new HashMap<String, Boolean>();
            data.put("PropertyAndPreferencePage.nolink", Boolean.TRUE);
            PreferencesUtil.createPreferenceDialogOn((Shell)JavaProjectWizardFirstPage.this.getShell(), (String)jreID, (String[])new String[]{jreID, complianceId}, data).open();
            this.handlePossibleJVMChange();
            JavaProjectWizardFirstPage.this.fDetectGroup.handlePossibleJVMChange();
        }

        public void handlePossibleJVMChange() {
            this.fUseDefaultJRE.setLabelText(this.getDefaultJVMLabel());
            this.fillInstalledJREs(this.fJRECombo);
        }

        public void dialogFieldChanged(DialogField field) {
            this.updateEnableState();
            JavaProjectWizardFirstPage.this.fDetectGroup.handlePossibleJVMChange();
        }

        public boolean isUseSpecific() {
            return this.fUseProjectJRE.isSelected();
        }

        public IVMInstall getSelectedJVM() {
            int index;
            if (this.fUseProjectJRE.isSelected() && (index = this.fJRECombo.getSelectionIndex()) >= 0 && index < this.fComplianceData.length) {
                return this.fInstalledJVMs[index];
            }
            return null;
        }

        public String getSelectedCompilerCompliance() {
            int index;
            if (this.fUseProjectJRE.isSelected() && (index = this.fJRECombo.getSelectionIndex()) >= 0 && index < this.fComplianceData.length) {
                return this.fComplianceData[index];
            }
            return null;
        }
    }

    private final class LayoutGroup
    implements Observer,
    SelectionListener {
        private final SelectionButtonDialogField fStdRadio;
        private final SelectionButtonDialogField fSrcBinRadio;
        private final Group fGroup;
        private final Link fPreferenceLink;

        public LayoutGroup(Composite composite) {
            this.fGroup = new Group(composite, 0);
            this.fGroup.setFont(composite.getFont());
            this.fGroup.setLayoutData((Object)new GridData(768));
            this.fGroup.setLayout((Layout)JavaProjectWizardFirstPage.this.initGridLayout(new GridLayout(3, false), true));
            this.fGroup.setText(NewWizardMessages.JavaProjectWizardFirstPage_LayoutGroup_title);
            this.fStdRadio = new SelectionButtonDialogField(16);
            this.fStdRadio.setLabelText(NewWizardMessages.JavaProjectWizardFirstPage_LayoutGroup_option_oneFolder);
            this.fSrcBinRadio = new SelectionButtonDialogField(16);
            this.fSrcBinRadio.setLabelText(NewWizardMessages.JavaProjectWizardFirstPage_LayoutGroup_option_separateFolders);
            this.fStdRadio.doFillIntoGrid((Composite)this.fGroup, 3);
            LayoutUtil.setHorizontalGrabbing((Control)this.fStdRadio.getSelectionButton(null));
            this.fSrcBinRadio.doFillIntoGrid((Composite)this.fGroup, 2);
            this.fPreferenceLink = new Link((Composite)this.fGroup, 0);
            this.fPreferenceLink.setText(NewWizardMessages.JavaProjectWizardFirstPage_LayoutGroup_link_description);
            this.fPreferenceLink.setLayoutData((Object)new GridData(3, 3, false, false));
            this.fPreferenceLink.addSelectionListener((SelectionListener)this);
            boolean useSrcBin = PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.jdt.ui.wizards.srcBinFoldersInNewProjects");
            this.fSrcBinRadio.setSelection(useSrcBin);
            this.fStdRadio.setSelection(!useSrcBin);
        }

        public void update(Observable o, Object arg) {
            boolean detect = JavaProjectWizardFirstPage.this.fDetectGroup.mustDetect();
            this.fStdRadio.setEnabled(!detect);
            this.fSrcBinRadio.setEnabled(!detect);
            this.fPreferenceLink.setEnabled(!detect);
            this.fGroup.setEnabled(!detect);
        }

        public boolean isSrcBin() {
            return this.fSrcBinRadio.isSelected();
        }

        public void widgetSelected(SelectionEvent e) {
            this.widgetDefaultSelected(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            String id = "org.eclipse.jdt.ui.preferences.BuildPathPreferencePage";
            PreferencesUtil.createPreferenceDialogOn((Shell)JavaProjectWizardFirstPage.this.getShell(), (String)id, (String[])new String[]{id}, null).open();
            JavaProjectWizardFirstPage.this.fDetectGroup.handlePossibleJVMChange();
            JavaProjectWizardFirstPage.this.fJREGroup.handlePossibleJVMChange();
        }
    }

    private final class LocationGroup
    extends Observable
    implements Observer,
    IStringButtonAdapter,
    IDialogFieldListener {
        protected final SelectionButtonDialogField fWorkspaceRadio;
        protected final SelectionButtonDialogField fExternalRadio;
        protected final StringButtonDialogField fLocation;
        private String fPreviousExternalLocation;
        private static final String DIALOGSTORE_LAST_EXTERNAL_LOC = "org.eclipse.jdt.ui.last.external.project";

        public LocationGroup(Composite composite) {
            Group group = new Group(composite, 0);
            group.setLayoutData((Object)new GridData(768));
            group.setLayout((Layout)JavaProjectWizardFirstPage.this.initGridLayout(new GridLayout(3, false), true));
            group.setText(NewWizardMessages.JavaProjectWizardFirstPage_LocationGroup_title);
            this.fWorkspaceRadio = new SelectionButtonDialogField(16);
            this.fWorkspaceRadio.setDialogFieldListener(this);
            this.fWorkspaceRadio.setLabelText(NewWizardMessages.JavaProjectWizardFirstPage_LocationGroup_workspace_desc);
            this.fExternalRadio = new SelectionButtonDialogField(16);
            this.fExternalRadio.setLabelText(NewWizardMessages.JavaProjectWizardFirstPage_LocationGroup_external_desc);
            this.fLocation = new StringButtonDialogField(this);
            this.fLocation.setDialogFieldListener(this);
            this.fLocation.setLabelText(NewWizardMessages.JavaProjectWizardFirstPage_LocationGroup_locationLabel_desc);
            this.fLocation.setButtonLabel(NewWizardMessages.JavaProjectWizardFirstPage_LocationGroup_browseButton_desc);
            this.fExternalRadio.attachDialogField(this.fLocation);
            this.fWorkspaceRadio.setSelection(true);
            this.fExternalRadio.setSelection(false);
            this.fPreviousExternalLocation = "";
            this.fWorkspaceRadio.doFillIntoGrid((Composite)group, 3);
            this.fExternalRadio.doFillIntoGrid((Composite)group, 3);
            this.fLocation.doFillIntoGrid((Composite)group, 3);
            LayoutUtil.setHorizontalGrabbing((Control)this.fLocation.getTextControl(null));
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        protected String getDefaultPath(String name) {
            IPath path = Platform.getLocation().append(name);
            return path.toOSString();
        }

        public void update(Observable o, Object arg) {
            if (this.isInWorkspace()) {
                this.fLocation.setText(this.getDefaultPath(JavaProjectWizardFirstPage.this.fNameGroup.getName()));
            }
            this.fireEvent();
        }

        public IPath getLocation() {
            if (this.isInWorkspace()) {
                return Platform.getLocation();
            }
            return Path.fromOSString((String)this.fLocation.getText().trim());
        }

        public boolean isInWorkspace() {
            return this.fWorkspaceRadio.isSelected();
        }

        public void changeControlPressed(DialogField field) {
            String selectedDirectory;
            File path;
            String prevLocation;
            DirectoryDialog dialog = new DirectoryDialog(JavaProjectWizardFirstPage.this.getShell());
            dialog.setMessage(NewWizardMessages.JavaProjectWizardFirstPage_directory_message);
            String directoryName = this.fLocation.getText().trim();
            if (directoryName.length() == 0 && (prevLocation = JavaPlugin.getDefault().getDialogSettings().get(DIALOGSTORE_LAST_EXTERNAL_LOC)) != null) {
                directoryName = prevLocation;
            }
            if (directoryName.length() > 0 && (path = new File(directoryName)).exists()) {
                dialog.setFilterPath(directoryName);
            }
            if ((selectedDirectory = dialog.open()) != null) {
                this.fLocation.setText(selectedDirectory);
                JavaPlugin.getDefault().getDialogSettings().put(DIALOGSTORE_LAST_EXTERNAL_LOC, selectedDirectory);
            }
        }

        public void dialogFieldChanged(DialogField field) {
            if (field == this.fWorkspaceRadio) {
                boolean checked = this.fWorkspaceRadio.isSelected();
                if (checked) {
                    this.fPreviousExternalLocation = this.fLocation.getText();
                    this.fLocation.setText(this.getDefaultPath(JavaProjectWizardFirstPage.this.fNameGroup.getName()));
                } else {
                    this.fLocation.setText(this.fPreviousExternalLocation);
                }
            }
            this.fireEvent();
        }
    }

    private final class NameGroup
    extends Observable
    implements IDialogFieldListener {
        protected final StringDialogField fNameField;

        public NameGroup(Composite composite, String initialName) {
            Composite nameComposite = new Composite(composite, 0);
            nameComposite.setFont(composite.getFont());
            nameComposite.setLayout((Layout)JavaProjectWizardFirstPage.this.initGridLayout(new GridLayout(2, false), false));
            nameComposite.setLayoutData((Object)new GridData(768));
            this.fNameField = new StringDialogField();
            this.fNameField.setLabelText(NewWizardMessages.JavaProjectWizardFirstPage_NameGroup_label_text);
            this.fNameField.setDialogFieldListener(this);
            this.setName(initialName);
            this.fNameField.doFillIntoGrid(nameComposite, 2);
            LayoutUtil.setHorizontalGrabbing((Control)this.fNameField.getTextControl(null));
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        public String getName() {
            return this.fNameField.getText().trim();
        }

        public void postSetFocus() {
            this.fNameField.postSetFocusOnDialogField(JavaProjectWizardFirstPage.this.getShell().getDisplay());
        }

        public void setName(String name) {
            this.fNameField.setText(name);
        }

        public void dialogFieldChanged(DialogField field) {
            this.fireEvent();
        }
    }

    private final class Validator
    implements Observer {
        private Validator() {
        }

        public void update(Observable o, Object arg) {
            IStatus locationStatus;
            IWorkspace workspace = JavaPlugin.getWorkspace();
            String name = JavaProjectWizardFirstPage.this.fNameGroup.getName();
            if (name.length() == 0) {
                JavaProjectWizardFirstPage.this.setErrorMessage(null);
                JavaProjectWizardFirstPage.this.setMessage(NewWizardMessages.JavaProjectWizardFirstPage_Message_enterProjectName);
                JavaProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            IStatus nameStatus = workspace.validateName(name, 4);
            if (!nameStatus.isOK()) {
                JavaProjectWizardFirstPage.this.setErrorMessage(nameStatus.getMessage());
                JavaProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            IProject handle = JavaProjectWizardFirstPage.this.getProjectHandle();
            if (handle.exists()) {
                JavaProjectWizardFirstPage.this.setErrorMessage(NewWizardMessages.JavaProjectWizardFirstPage_Message_projectAlreadyExists);
                JavaProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            String location = JavaProjectWizardFirstPage.this.fLocationGroup.getLocation().toOSString();
            if (location.length() == 0) {
                JavaProjectWizardFirstPage.this.setErrorMessage(null);
                JavaProjectWizardFirstPage.this.setMessage(NewWizardMessages.JavaProjectWizardFirstPage_Message_enterLocation);
                JavaProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            if (!Path.EMPTY.isValidPath(location)) {
                JavaProjectWizardFirstPage.this.setErrorMessage(NewWizardMessages.JavaProjectWizardFirstPage_Message_invalidDirectory);
                JavaProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            IPath projectPath = Path.fromOSString((String)location);
            if (!JavaProjectWizardFirstPage.this.fLocationGroup.isInWorkspace() && Platform.getLocation().isPrefixOf(projectPath)) {
                JavaProjectWizardFirstPage.this.setErrorMessage(NewWizardMessages.JavaProjectWizardFirstPage_Message_cannotCreateInWorkspace);
                JavaProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            if (!JavaProjectWizardFirstPage.this.fLocationGroup.isInWorkspace() && !(locationStatus = workspace.validateProjectLocation(handle, projectPath)).isOK()) {
                JavaProjectWizardFirstPage.this.setErrorMessage(locationStatus.getMessage());
                JavaProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            JavaProjectWizardFirstPage.this.setPageComplete(true);
            JavaProjectWizardFirstPage.this.setErrorMessage(null);
            JavaProjectWizardFirstPage.this.setMessage(null);
        }
    }
}

