/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.ui.IWorkingSet;

public class ReorgUtils {
    private static final ISourceRange fgUnknownRange = new SourceRange(-1, 0);

    private ReorgUtils() {
    }

    public static boolean isArchiveMember(IJavaElement[] elements) {
        int i = 0;
        while (i < elements.length) {
            IJavaElement element = elements[i];
            IPackageFragmentRoot root = (IPackageFragmentRoot)element.getAncestor(3);
            if (root != null && root.isArchive()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean containsOnlyProjects(List elements) {
        if (elements.isEmpty()) {
            return false;
        }
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            if (ReorgUtils.isProject(iter.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean isProject(Object element) {
        return element instanceof IJavaProject || element instanceof IProject;
    }

    public static boolean isInsideCompilationUnit(IJavaElement element) {
        return !(element instanceof ICompilationUnit) && ReorgUtils.hasAncestorOfType(element, 5);
    }

    public static boolean isInsideClassFile(IJavaElement element) {
        return !(element instanceof IClassFile) && ReorgUtils.hasAncestorOfType(element, 6);
    }

    public static boolean hasAncestorOfType(IJavaElement element, int type) {
        return element.getAncestor(type) != null;
    }

    public static ICompilationUnit getCompilationUnit(IJavaElement javaElement) {
        if (javaElement instanceof ICompilationUnit) {
            return (ICompilationUnit)javaElement;
        }
        return (ICompilationUnit)javaElement.getAncestor(5);
    }

    public static ICompilationUnit[] getCompilationUnits(IJavaElement[] javaElements) {
        ICompilationUnit[] result = new ICompilationUnit[javaElements.length];
        int i = 0;
        while (i < javaElements.length) {
            result[i] = ReorgUtils.getCompilationUnit(javaElements[i]);
            ++i;
        }
        return result;
    }

    public static IResource getResource(IJavaElement element) {
        if (element instanceof ICompilationUnit) {
            return ((ICompilationUnit)element).getPrimary().getResource();
        }
        return element.getResource();
    }

    public static IResource[] getResources(IJavaElement[] elements) {
        IResource[] result = new IResource[elements.length];
        int i = 0;
        while (i < elements.length) {
            result[i] = ReorgUtils.getResource(elements[i]);
            ++i;
        }
        return result;
    }

    public static String getName(IResource resource) {
        String pattern = ReorgUtils.createNamePattern(resource);
        Object[] args = ReorgUtils.createNameArguments(resource);
        return Messages.format(pattern, args);
    }

    private static String createNamePattern(IResource resource) {
        switch (resource.getType()) {
            case 1: {
                return RefactoringCoreMessages.ReorgUtils_0;
            }
            case 2: {
                return RefactoringCoreMessages.ReorgUtils_1;
            }
            case 4: {
                return RefactoringCoreMessages.ReorgUtils_2;
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private static String[] createNameArguments(IResource resource) {
        return new String[]{resource.getName()};
    }

    public static String getName(IJavaElement element) throws JavaModelException {
        String pattern = ReorgUtils.createNamePattern(element);
        Object[] args = ReorgUtils.createNameArguments(element);
        return Messages.format(pattern, args);
    }

    private static String[] createNameArguments(IJavaElement element) throws JavaModelException {
        switch (element.getElementType()) {
            case 6: {
                return new String[]{element.getElementName()};
            }
            case 5: {
                return new String[]{element.getElementName()};
            }
            case 8: {
                return new String[]{element.getElementName()};
            }
            case 12: {
                return new String[0];
            }
            case 13: {
                return new String[]{element.getElementName()};
            }
            case 10: {
                return new String[0];
            }
            case 2: {
                return new String[]{element.getElementName()};
            }
            case 9: {
                return new String[]{element.getElementName()};
            }
            case 11: {
                if (JavaElementUtil.isDefaultPackage(element)) {
                    return new String[0];
                }
                return new String[]{element.getElementName()};
            }
            case 4: {
                return new String[]{element.getElementName()};
            }
            case 3: {
                return new String[]{element.getElementName()};
            }
            case 7: {
                IType type = (IType)element;
                String name = type.getElementName();
                if (name.length() == 0 && type.isAnonymous()) {
                    String superclassName = Signature.getSimpleName((String)type.getSuperclassName());
                    return new String[]{Messages.format(RefactoringCoreMessages.ReorgUtils_19, superclassName)};
                }
                return new String[]{element.getElementName()};
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private static String createNamePattern(IJavaElement element) throws JavaModelException {
        switch (element.getElementType()) {
            case 6: {
                return RefactoringCoreMessages.ReorgUtils_3;
            }
            case 5: {
                return RefactoringCoreMessages.ReorgUtils_4;
            }
            case 8: {
                return RefactoringCoreMessages.ReorgUtils_5;
            }
            case 12: {
                return RefactoringCoreMessages.ReorgUtils_6;
            }
            case 13: {
                return RefactoringCoreMessages.ReorgUtils_7;
            }
            case 10: {
                return RefactoringCoreMessages.ReorgUtils_8;
            }
            case 2: {
                return RefactoringCoreMessages.ReorgUtils_9;
            }
            case 9: {
                if (((IMethod)element).isConstructor()) {
                    return RefactoringCoreMessages.ReorgUtils_10;
                }
                return RefactoringCoreMessages.ReorgUtils_11;
            }
            case 11: {
                return RefactoringCoreMessages.ReorgUtils_12;
            }
            case 4: {
                if (JavaElementUtil.isDefaultPackage(element)) {
                    return RefactoringCoreMessages.ReorgUtils_13;
                }
                return RefactoringCoreMessages.ReorgUtils_14;
            }
            case 3: {
                if (ReorgUtils.isSourceFolder(element)) {
                    return RefactoringCoreMessages.ReorgUtils_15;
                }
                if (ReorgUtils.isClassFolder(element)) {
                    return RefactoringCoreMessages.ReorgUtils_16;
                }
                return RefactoringCoreMessages.ReorgUtils_17;
            }
            case 7: {
                IType type = (IType)element;
                if (type.getElementName().length() == 0 && type.isAnonymous()) {
                    return RefactoringCoreMessages.ReorgUtils_20;
                }
                return RefactoringCoreMessages.ReorgUtils_18;
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public static IResource[] getResources(List elements) {
        ArrayList resources = new ArrayList(elements.size());
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof IResource)) continue;
            resources.add(element);
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    public static IJavaElement[] getJavaElements(List elements) {
        ArrayList resources = new ArrayList(elements.size());
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof IJavaElement)) continue;
            resources.add(element);
        }
        return resources.toArray(new IJavaElement[resources.size()]);
    }

    public static IWorkingSet[] getWorkingSets(List elements) {
        ArrayList result = new ArrayList(1);
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof IWorkingSet)) continue;
            result.add(element);
        }
        return result.toArray(new IWorkingSet[result.size()]);
    }

    public static boolean isDeletedFromEditor(IJavaElement elem) {
        if (!ReorgUtils.isInsideCompilationUnit(elem)) {
            return false;
        }
        if (elem instanceof IMember && ((IMember)elem).isBinary()) {
            return false;
        }
        ICompilationUnit cu = ReorgUtils.getCompilationUnit(elem);
        if (cu == null) {
            return false;
        }
        ICompilationUnit wc = cu;
        if (cu.equals(wc)) {
            return false;
        }
        IJavaElement wcElement = JavaModelUtil.findInCompilationUnit(wc, elem);
        return wcElement == null || !wcElement.exists();
    }

    public static boolean hasSourceAvailable(IMember member) throws JavaModelException {
        return !member.isBinary() || member.getSourceRange() != null && !fgUnknownRange.equals(member.getSourceRange());
    }

    public static IResource[] setMinus(IResource[] setToRemoveFrom, IResource[] elementsToRemove) {
        HashSet<IResource> setMinus = new HashSet<IResource>(setToRemoveFrom.length - setToRemoveFrom.length);
        setMinus.addAll(Arrays.asList(setToRemoveFrom));
        setMinus.removeAll(Arrays.asList(elementsToRemove));
        return setMinus.toArray(new IResource[setMinus.size()]);
    }

    public static IJavaElement[] setMinus(IJavaElement[] setToRemoveFrom, IJavaElement[] elementsToRemove) {
        HashSet<IJavaElement> setMinus = new HashSet<IJavaElement>(setToRemoveFrom.length - setToRemoveFrom.length);
        setMinus.addAll(Arrays.asList(setToRemoveFrom));
        setMinus.removeAll(Arrays.asList(elementsToRemove));
        return setMinus.toArray(new IJavaElement[setMinus.size()]);
    }

    public static IJavaElement[] union(IJavaElement[] set1, IJavaElement[] set2) {
        ArrayList union = new ArrayList(set1.length + set2.length);
        ReorgUtils.addAll(set1, union);
        ReorgUtils.addAll(set2, union);
        return union.toArray(new IJavaElement[union.size()]);
    }

    public static IResource[] union(IResource[] set1, IResource[] set2) {
        ArrayList union = new ArrayList(set1.length + set2.length);
        ReorgUtils.addAll(ReorgUtils.getNotNulls(set1), union);
        ReorgUtils.addAll(ReorgUtils.getNotNulls(set2), union);
        return union.toArray(new IResource[union.size()]);
    }

    private static void addAll(Object[] array, List list) {
        int i = 0;
        while (i < array.length) {
            if (!list.contains(array[i])) {
                list.add(array[i]);
            }
            ++i;
        }
    }

    public static Set union(Set set1, Set set2) {
        HashSet union = new HashSet(set1.size() + set2.size());
        union.addAll(set1);
        union.addAll(set2);
        return union;
    }

    public static IType[] getMainTypes(IJavaElement[] javaElements) throws JavaModelException {
        ArrayList<IJavaElement> result = new ArrayList<IJavaElement>();
        int i = 0;
        while (i < javaElements.length) {
            IJavaElement element = javaElements[i];
            if (element instanceof IType && JavaElementUtil.isMainType((IType)element)) {
                result.add(element);
            }
            ++i;
        }
        return result.toArray(new IType[result.size()]);
    }

    public static IFolder[] getFolders(IResource[] resources) {
        Set result = ReorgUtils.getResourcesOfType(resources, 2);
        return result.toArray(new IFolder[result.size()]);
    }

    public static IFile[] getFiles(IResource[] resources) {
        Set result = ReorgUtils.getResourcesOfType(resources, 1);
        return result.toArray(new IFile[result.size()]);
    }

    public static Set getResourcesOfType(IResource[] resources, int typeMask) {
        HashSet<IResource> result = new HashSet<IResource>(resources.length);
        int i = 0;
        while (i < resources.length) {
            if (ReorgUtils.isOfType(resources[i], typeMask)) {
                result.add(resources[i]);
            }
            ++i;
        }
        return result;
    }

    public static List getElementsOfType(IJavaElement[] javaElements, int type) {
        ArrayList<IJavaElement> result = new ArrayList<IJavaElement>(javaElements.length);
        int i = 0;
        while (i < javaElements.length) {
            if (ReorgUtils.isOfType(javaElements[i], type)) {
                result.add(javaElements[i]);
            }
            ++i;
        }
        return result;
    }

    public static boolean hasElementsNotOfType(IResource[] resources, int typeMask) {
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource != null && !ReorgUtils.isOfType(resource, typeMask)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasElementsNotOfType(IJavaElement[] javaElements, int type) {
        int i = 0;
        while (i < javaElements.length) {
            IJavaElement element = javaElements[i];
            if (element != null && !ReorgUtils.isOfType(element, type)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasElementsOfType(IJavaElement[] javaElements, int type) {
        int i = 0;
        while (i < javaElements.length) {
            IJavaElement element = javaElements[i];
            if (element != null && ReorgUtils.isOfType(element, type)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasElementsOfType(IJavaElement[] javaElements, int[] types) {
        int i = 0;
        while (i < types.length) {
            if (ReorgUtils.hasElementsOfType(javaElements, types[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasElementsOfType(IResource[] resources, int typeMask) {
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource != null && ReorgUtils.isOfType(resource, typeMask)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isOfType(IJavaElement element, int type) {
        return element.getElementType() == type;
    }

    private static boolean isOfType(IResource resource, int type) {
        return resource != null && ReorgUtils.isFlagSet(resource.getType(), type);
    }

    private static boolean isFlagSet(int flags, int flag) {
        return (flags & flag) != 0;
    }

    public static boolean isSourceFolder(IJavaElement javaElement) throws JavaModelException {
        return javaElement instanceof IPackageFragmentRoot && ((IPackageFragmentRoot)javaElement).getKind() == 1;
    }

    public static boolean isClassFolder(IJavaElement javaElement) throws JavaModelException {
        return javaElement instanceof IPackageFragmentRoot && ((IPackageFragmentRoot)javaElement).getKind() == 2;
    }

    public static boolean isPackageFragmentRoot(IJavaProject javaProject) throws JavaModelException {
        return ReorgUtils.getCorrespondingPackageFragmentRoot(javaProject) != null;
    }

    private static boolean isPackageFragmentRootCorrespondingToProject(IPackageFragmentRoot root) {
        return root.getResource() instanceof IProject;
    }

    public static IPackageFragmentRoot getCorrespondingPackageFragmentRoot(IJavaProject p) throws JavaModelException {
        IPackageFragmentRoot[] roots = p.getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            if (ReorgUtils.isPackageFragmentRootCorrespondingToProject(roots[i])) {
                return roots[i];
            }
            ++i;
        }
        return null;
    }

    public static boolean containsLinkedResources(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            if (resources[i] != null && resources[i].isLinked()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean containsLinkedResources(IJavaElement[] javaElements) {
        int i = 0;
        while (i < javaElements.length) {
            IResource res = ReorgUtils.getResource(javaElements[i]);
            if (res != null && res.isLinked()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean canBeDestinationForLinkedResources(IResource resource) {
        return resource.isAccessible() && resource instanceof IProject;
    }

    public static boolean canBeDestinationForLinkedResources(IJavaElement javaElement) {
        if (javaElement instanceof IPackageFragmentRoot) {
            return ReorgUtils.isPackageFragmentRootCorrespondingToProject((IPackageFragmentRoot)javaElement);
        }
        return javaElement instanceof IJavaProject;
    }

    public static boolean isParentInWorkspaceOrOnDisk(IPackageFragment pack, IPackageFragmentRoot root) {
        if (pack == null) {
            return false;
        }
        IJavaElement packParent = pack.getParent();
        if (packParent == null) {
            return false;
        }
        if (packParent.equals(root)) {
            return true;
        }
        IResource packageResource = ResourceUtil.getResource(pack);
        IResource packageRootResource = ResourceUtil.getResource(root);
        return ReorgUtils.isParentInWorkspaceOrOnDisk(packageResource, packageRootResource);
    }

    public static boolean isParentInWorkspaceOrOnDisk(IPackageFragmentRoot root, IJavaProject javaProject) {
        if (root == null) {
            return false;
        }
        IJavaElement rootParent = root.getParent();
        if (rootParent == null) {
            return false;
        }
        if (rootParent.equals(root)) {
            return true;
        }
        IResource packageResource = ResourceUtil.getResource(root);
        IResource packageRootResource = ResourceUtil.getResource(javaProject);
        return ReorgUtils.isParentInWorkspaceOrOnDisk(packageResource, packageRootResource);
    }

    public static boolean isParentInWorkspaceOrOnDisk(ICompilationUnit cu, IPackageFragment dest) {
        if (cu == null) {
            return false;
        }
        IJavaElement cuParent = cu.getParent();
        if (cuParent == null) {
            return false;
        }
        if (cuParent.equals(dest)) {
            return true;
        }
        IResource cuResource = ResourceUtil.getResource(cu);
        IResource packageResource = ResourceUtil.getResource(dest);
        return ReorgUtils.isParentInWorkspaceOrOnDisk(cuResource, packageResource);
    }

    public static boolean isParentInWorkspaceOrOnDisk(IResource res, IResource maybeParent) {
        if (res == null) {
            return false;
        }
        return ReorgUtils.areEqualInWorkspaceOrOnDisk((IResource)res.getParent(), maybeParent);
    }

    public static boolean areEqualInWorkspaceOrOnDisk(IResource r1, IResource r2) {
        if (r1 == null || r2 == null) {
            return false;
        }
        if (r1.equals((Object)r2)) {
            return true;
        }
        URI r1Location = r1.getLocationURI();
        URI r2Location = r2.getLocationURI();
        if (r1Location == null || r2Location == null) {
            return false;
        }
        return r1Location.equals(r2Location);
    }

    public static IResource[] getNotNulls(IResource[] resources) {
        ArrayList<IResource> result = new ArrayList<IResource>(resources.length);
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource != null && !result.contains(resource)) {
                result.add(resource);
            }
            ++i;
        }
        return result.toArray(new IResource[result.size()]);
    }

    public static IResource[] getNotLinked(IResource[] resources) {
        ArrayList<IResource> result = new ArrayList<IResource>(resources.length);
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource != null && !result.contains(resource) && !resource.isLinked()) {
                result.add(resource);
            }
            ++i;
        }
        return result.toArray(new IResource[result.size()]);
    }

    public static Map groupByCompilationUnit(List javaElements) {
        HashMap result = new HashMap();
        Iterator iter = javaElements.iterator();
        while (iter.hasNext()) {
            IJavaElement element = (IJavaElement)iter.next();
            ICompilationUnit cu = ReorgUtils.getCompilationUnit(element);
            if (cu == null) continue;
            if (!result.containsKey(cu)) {
                result.put(cu, new ArrayList(1));
            }
            ((List)result.get(cu)).add(element);
        }
        return result;
    }

    public static void splitIntoJavaElementsAndResources(Object[] elements, List javaElementResult, List resourceResult) {
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            if (element instanceof IJavaElement) {
                javaElementResult.add(element);
            } else if (element instanceof IResource) {
                IResource resource = (IResource)element;
                IJavaElement jElement = JavaCore.create((IResource)resource);
                if (jElement != null && jElement.exists()) {
                    javaElementResult.add(jElement);
                } else {
                    resourceResult.add(resource);
                }
            }
            ++i;
        }
    }

    public static boolean containsElementOrParent(Set elements, IJavaElement element) {
        if (elements.contains(element)) {
            return true;
        }
        IJavaElement parent = element.getParent();
        while (parent != null) {
            if (elements.contains(parent)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public static boolean containsElementOrParent(Set elements, IResource element) {
        if (elements.contains(element)) {
            return true;
        }
        IContainer parent = element.getParent();
        while (parent != null) {
            if (elements.contains(parent)) {
                return true;
            }
            IJavaElement parentAsJavaElement = JavaCore.create((IResource)parent);
            if (parentAsJavaElement != null && parentAsJavaElement.exists() && elements.contains(parentAsJavaElement)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }
}

