/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.scripting;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringLocationControl;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;
import org.eclipse.ltk.internal.ui.refactoring.scripting.ScriptingMessages;
import org.eclipse.ltk.internal.ui.refactoring.util.SWTUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;

public class RefactoringScriptLocationControl
extends Composite {
    protected static final String SETTING_CLIPBOARD = "org.eclipse.ltk.ui.refactoring.useClipboard";
    protected static final String SETTING_HISTORY = "org.eclipse.ltk.ui.refactoring.scriptHistory";
    protected Button fExternalBrowseButton = null;
    protected RefactoringLocationControl fExternalLocationControl = null;
    protected Button fFromClipboardButton = null;
    protected Button fFromExternalLocationButton = null;
    protected URI fScriptLocation = null;
    protected final IWizard fWizard;

    public RefactoringScriptLocationControl(IWizard wizard, Composite parent) {
        super(parent, 0);
        Assert.isNotNull((Object)wizard);
        this.fWizard = wizard;
        this.setLayoutData(this.createGridData(768, 6, 0));
        this.setLayout((Layout)new GridLayout(3, false));
        boolean clipboard = false;
        final IDialogSettings settings = this.fWizard.getDialogSettings();
        if (settings != null) {
            clipboard = settings.getBoolean(SETTING_CLIPBOARD);
        }
        this.fFromClipboardButton = new Button((Composite)this, 16);
        this.fFromClipboardButton.setText(ScriptingMessages.ScriptLocationControl_clipboard_label);
        this.fFromClipboardButton.setLayoutData((Object)this.createGridData(32, 3, 0));
        this.fFromClipboardButton.setSelection(clipboard);
        this.fFromClipboardButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent event) {
                boolean selection = RefactoringScriptLocationControl.this.fFromClipboardButton.getSelection();
                RefactoringScriptLocationControl.this.fExternalLocationControl.setEnabled(!selection);
                RefactoringScriptLocationControl.this.fExternalBrowseButton.setEnabled(!selection);
                RefactoringScriptLocationControl.this.handleClipboardScriptChanged();
            }
        });
        this.fFromExternalLocationButton = new Button((Composite)this, 16);
        this.fFromExternalLocationButton.setText(ScriptingMessages.ScriptLocationControl_location_label);
        this.fFromExternalLocationButton.setLayoutData((Object)this.createGridData(32, 1, 0));
        this.fFromExternalLocationButton.setSelection(!clipboard);
        this.fFromExternalLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent event) {
                RefactoringScriptLocationControl.this.handleExternalLocationChanged();
            }
        });
        this.fExternalLocationControl = new RefactoringLocationControl(this.fWizard, this, SETTING_HISTORY);
        this.fExternalLocationControl.setLayoutData(this.createGridData(768, 1, 0));
        this.fExternalLocationControl.setEnabled(!clipboard);
        this.fExternalLocationControl.getControl().addModifyListener(new ModifyListener(){

            public final void modifyText(ModifyEvent event) {
                RefactoringScriptLocationControl.this.handleExternalLocationChanged();
            }
        });
        this.fExternalLocationControl.getControl().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RefactoringScriptLocationControl.this.handleExternalLocationChanged();
            }
        });
        if (!clipboard) {
            this.fExternalLocationControl.setFocus();
        }
        this.fExternalBrowseButton = new Button((Composite)this, 8);
        this.fExternalBrowseButton.setText(ScriptingMessages.ScriptLocationControl_browse_label);
        this.fExternalBrowseButton.setEnabled(!clipboard);
        this.fExternalBrowseButton.setLayoutData((Object)this.createGridData(256, 1, 0));
        SWTUtil.setButtonDimensionHint(this.fExternalBrowseButton);
        this.fExternalBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent event) {
                RefactoringScriptLocationControl.this.handleBrowseExternalLocation();
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public final void widgetDisposed(DisposeEvent event) {
                if (settings != null) {
                    settings.put(RefactoringScriptLocationControl.SETTING_CLIPBOARD, RefactoringScriptLocationControl.this.fFromClipboardButton.getSelection());
                }
            }
        });
    }

    protected GridData createGridData(int flag, int hspan, int indent) {
        GridData data = new GridData(flag);
        data.horizontalIndent = indent;
        data.horizontalSpan = hspan;
        return data;
    }

    public URI getRefactoringScript() {
        return this.fScriptLocation;
    }

    protected void handleBrowseExternalLocation() {
        FileDialog file = new FileDialog(this.getShell(), 4096);
        file.setText(ScriptingMessages.ScriptLocationControl_browse_caption);
        file.setFilterNames(new String[]{ScriptingMessages.ScriptLocationControl_filter_name_script, ScriptingMessages.ScriptLocationControl_filter_name_wildcard});
        file.setFilterExtensions(new String[]{ScriptingMessages.ScriptLocationControl_filter_extension_script, ScriptingMessages.ScriptLocationControl_filter_extension_wildcard});
        String path = file.open();
        if (path != null) {
            this.fExternalLocationControl.setText(path);
        }
    }

    protected void handleClipboardScriptChanged() {
    }

    protected void handleExternalLocationChanged() {
        String text = this.fExternalLocationControl.getText();
        this.fScriptLocation = text != null && !"".equals(text) ? new File(text).toURI() : null;
    }

    public void loadHistory() {
        this.fExternalLocationControl.loadHistory();
    }

    public void saveHistory() {
        this.fExternalLocationControl.saveHistory();
    }

    public void setRefactoringScript(URI uri) {
        if (this.fExternalLocationControl != null) {
            this.fExternalLocationControl.setEnabled(true);
        }
        if (this.fExternalBrowseButton != null) {
            this.fExternalBrowseButton.setEnabled(true);
        }
        if (uri == null) {
            this.fExternalLocationControl.setText("");
        } else {
            try {
                String path = new File(uri).getCanonicalPath();
                if (path != null && !"".equals(path)) {
                    this.fExternalLocationControl.setText(path);
                }
                this.handleExternalLocationChanged();
            }
            catch (IOException exception) {
                RefactoringUIPlugin.log(exception);
            }
        }
    }
}

