/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.internal.ide.IDEInternalWorkbenchImages;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerView;
import org.eclipse.ui.views.markers.internal.Util;

public class MarkerResolutionDialog
extends TitleAreaDialog {
    private IMarker originalMarker;
    private IMarkerResolution[] resolutions;
    private CheckboxTableViewer markersTable;
    private ListViewer resolutionsList;
    private ProgressMonitorPart progressPart;
    private MarkerView markerView;
    private ViewerSorter resolutionsSorter;
    private boolean calculatingResolutions;
    private boolean progressCancelled = false;
    private Button addMatching;
    private Hashtable markerMap = new Hashtable(0);

    public MarkerResolutionDialog(Shell shell, IMarker marker, IMarkerResolution[] newResolutions, MarkerView view) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.initializeResolutionsSorter();
        this.resolutionsSorter.sort((Viewer)view.getViewer(), (Object[])newResolutions);
        this.resolutions = newResolutions;
        this.originalMarker = marker;
        this.markerView = view;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(MarkerMessages.resolveMarkerAction_dialogTitle);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitleImage(JFaceResources.getResources().createImageWithDefault(IDEInternalWorkbenchImages.getImageDescriptor("IMG_DLGBAN_QUICKFIX_DLG")));
        Composite mainArea = (Composite)super.createDialogArea(parent);
        Composite control = new Composite(mainArea, 0);
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        FormLayout layout = new FormLayout();
        layout.marginLeft = 4;
        layout.marginTop = 4;
        layout.marginRight = 4;
        layout.marginBottom = 4;
        layout.spacing = 4;
        control.setLayout((Layout)layout);
        this.initializeDialogUnits((Control)control);
        Label resolutionsLabel = new Label(control, 0);
        resolutionsLabel.setText(MarkerMessages.MarkerResolutionDialog_Resolutions_List_Title);
        FormData resolutionsLabelData = new FormData();
        resolutionsLabelData.top = new FormAttachment(0);
        resolutionsLabelData.left = new FormAttachment(0);
        resolutionsLabel.setLayoutData((Object)resolutionsLabelData);
        this.resolutionsList = new ListViewer(control, 2052);
        this.resolutionsList.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return MarkerResolutionDialog.this.resolutions;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.resolutionsList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IMarkerResolution)element).getLabel();
            }
        });
        this.resolutionsList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                WorkbenchMarkerResolution resolution = MarkerResolutionDialog.this.getSelectedWorkbenchResolution();
                if (resolution == null || MarkerResolutionDialog.this.markerMap.containsKey(resolution)) {
                    MarkerResolutionDialog.this.addMatching.setEnabled(false);
                } else {
                    MarkerResolutionDialog.this.addMatching.setEnabled(true);
                }
                MarkerResolutionDialog.this.markersTable.refresh();
            }
        });
        this.resolutionsList.setInput((Object)this);
        this.resolutionsList.setSorter(this.resolutionsSorter);
        FormData listData = new FormData();
        listData.top = new FormAttachment((Control)resolutionsLabel, 0);
        listData.left = new FormAttachment(0);
        listData.right = new FormAttachment(100, 0);
        listData.height = this.convertHeightInCharsToPixels(10);
        this.resolutionsList.getControl().setLayoutData((Object)listData);
        Label title = new Label(control, 0);
        title.setText(MarkerMessages.MarkerResolutionDialog_Problems_List_Title);
        FormData labelData = new FormData();
        labelData.top = new FormAttachment(this.resolutionsList.getControl(), 0);
        labelData.left = new FormAttachment(0);
        title.setLayoutData((Object)labelData);
        Composite buttons = this.createTableButtons(control);
        FormData buttonData = new FormData();
        buttonData.top = new FormAttachment((Control)title, 0);
        buttonData.right = new FormAttachment(100);
        buttonData.height = this.convertHeightInCharsToPixels(10);
        buttons.setLayoutData((Object)buttonData);
        this.createMarkerTable(control);
        FormData tableData = new FormData();
        tableData.top = new FormAttachment((Control)buttons, 0, 128);
        tableData.left = new FormAttachment(0);
        tableData.right = new FormAttachment((Control)buttons, 0);
        tableData.height = this.convertHeightInCharsToPixels(10);
        this.markersTable.getControl().setLayoutData((Object)tableData);
        this.progressPart = new ProgressMonitorPart(control, (Layout)new GridLayout());
        FormData progressData = new FormData();
        progressData.top = new FormAttachment(this.markersTable.getControl(), 0);
        progressData.left = new FormAttachment(0);
        progressData.right = new FormAttachment(100, 0);
        this.progressPart.setLayoutData((Object)progressData);
        Dialog.applyDialogFont((Control)control);
        this.markerView.getTree();
        this.setMessage(NLS.bind((String)MarkerMessages.MarkerResolutionDialog_Description, (Object)Util.getProperty("message", this.originalMarker)));
        return mainArea;
    }

    private void initializeResolutionsSorter() {
        this.resolutionsSorter = new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((IMarkerResolution)e1).getLabel().compareTo(((IMarkerResolution)e1).getLabel());
            }
        };
    }

    private Composite createTableButtons(Composite control) {
        Composite buttonComposite = new Composite(control, 0);
        buttonComposite.setLayout((Layout)new GridLayout());
        Button selectAll = new Button(buttonComposite, 8);
        selectAll.setText(MarkerMessages.selectAllAction_title);
        selectAll.setLayoutData((Object)new GridData(4, 0, false, false));
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MarkerResolutionDialog.this.markersTable.setAllChecked(true);
                MarkerResolutionDialog.this.setComplete(!MarkerResolutionDialog.this.resolutionsList.getSelection().isEmpty());
            }
        });
        Button deselectAll = new Button(buttonComposite, 8);
        deselectAll.setText(MarkerMessages.filtersDialog_deselectAll);
        deselectAll.setLayoutData((Object)new GridData(4, 0, false, false));
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MarkerResolutionDialog.this.markersTable.setAllChecked(false);
                MarkerResolutionDialog.this.setComplete(false);
            }
        });
        this.addMatching = new Button(buttonComposite, 8);
        this.addMatching.setText(MarkerMessages.MarkerResolutionDialog_AddOthers);
        this.addMatching.setLayoutData((Object)new GridData(4, 0, false, false));
        this.addMatching.setEnabled(true);
        this.addMatching.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                WorkbenchMarkerResolution selected = MarkerResolutionDialog.this.getSelectedWorkbenchResolution();
                if (selected == null) {
                    return;
                }
                if (MarkerResolutionDialog.this.addMatchingMarkers(selected)) {
                    MarkerResolutionDialog.this.addMatching.setEnabled(false);
                }
            }
        });
        return buttonComposite;
    }

    private WorkbenchMarkerResolution getSelectedWorkbenchResolution() {
        IMarkerResolution selection = this.getSelectedResolution();
        if (selection == null || !(selection instanceof WorkbenchMarkerResolution)) {
            return null;
        }
        return (WorkbenchMarkerResolution)selection;
    }

    private IMarkerResolution getSelectedResolution() {
        ISelection selection = this.resolutionsList.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        Object first = ((IStructuredSelection)selection).getFirstElement();
        return (IMarkerResolution)first;
    }

    protected boolean addMatchingMarkers(final WorkbenchMarkerResolution resolution) {
        this.calculatingResolutions = true;
        this.progressPart.beginTask(MarkerMessages.MarkerResolutionDialog_CalculatingTask, 100);
        this.progressPart.worked(10);
        if (this.progressCancelled()) {
            this.calculatingResolutions = false;
            return false;
        }
        this.progressPart.subTask(NLS.bind((String)MarkerMessages.MarkerResolutionDialog_WorkingSubTask, (Object)resolution.getLabel()));
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                IMarker[] others = resolution.findOtherMarkers(MarkerResolutionDialog.this.markerView.getCurrentMarkers().getIMarkers());
                ArrayList<IMarker> currentMarkers = new ArrayList<IMarker>();
                currentMarkers.add(MarkerResolutionDialog.this.originalMarker);
                int i = 0;
                while (i < others.length) {
                    currentMarkers.add(others[i]);
                    ++i;
                }
                MarkerResolutionDialog.this.markerMap.put(resolution, currentMarkers);
                MarkerResolutionDialog.this.progressPart.worked(90);
                MarkerResolutionDialog.this.progressPart.done();
                MarkerResolutionDialog.this.progressCancelled = false;
                MarkerResolutionDialog.this.calculatingResolutions = false;
                MarkerResolutionDialog.this.markersTable.refresh();
            }
        });
        return true;
    }

    private boolean progressCancelled() {
        this.getShell().getDisplay().readAndDispatch();
        if (this.progressCancelled) {
            this.progressCancelled = false;
            this.calculatingResolutions = false;
            this.progressPart.done();
            return true;
        }
        return false;
    }

    private void createMarkerTable(Composite control) {
        this.markersTable = CheckboxTableViewer.newCheckList((Composite)control, (int)2560);
        this.createTableColumns();
        this.markersTable.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                IMarkerResolution selected = MarkerResolutionDialog.this.getSelectedResolution();
                if (selected == null) {
                    return new Object[0];
                }
                if (MarkerResolutionDialog.this.markerMap.containsKey(selected)) {
                    return ((Collection)MarkerResolutionDialog.this.markerMap.get(selected)).toArray();
                }
                return new IMarker[]{MarkerResolutionDialog.this.originalMarker};
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.markersTable.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                if (columnIndex == 0) {
                    return Util.getImage(((IMarker)element).getAttribute("severity", -1));
                }
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex == 0) {
                    return Util.getResourceName((IMarker)element);
                }
                int line = ((IMarker)element).getAttribute("lineNumber", -1);
                if (line < 0) {
                    return MarkerMessages.Unknown;
                }
                return NLS.bind((String)MarkerMessages.label_lineNumber, (Object)Integer.toString(line));
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.markersTable.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    MarkerResolutionDialog.this.setComplete(true);
                } else {
                    MarkerResolutionDialog.this.setComplete(MarkerResolutionDialog.this.markersTable.getCheckedElements().length > 0);
                }
            }
        });
        this.markersTable.setInput((Object)this);
        this.markersTable.setAllChecked(true);
    }

    private void createTableColumns() {
        TableLayout layout = new TableLayout();
        this.markersTable.getTable().setLayout((Layout)layout);
        this.markersTable.getTable().setLinesVisible(true);
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(200, true, true));
        TableColumn tc = new TableColumn(this.markersTable.getTable(), 0, 0);
        tc.setResizable(true);
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(50, true, true));
        tc = new TableColumn(this.markersTable.getTable(), 0, 0);
        tc.setResizable(true);
    }

    protected void setComplete(boolean complete) {
        this.getButton(0).setEnabled(complete);
    }

    public IMarkerResolution[] getResolutions() {
        return this.resolutions;
    }

    public void create() {
        super.create();
        this.setTitle(MarkerMessages.MarkerResolutionDialog_Title);
        this.resolutionsList.getList().select(0);
        this.markersTable.refresh();
        this.markersTable.setAllChecked(true);
        this.setComplete(true);
    }

    protected void okPressed() {
        IMarkerResolution resolution = this.getSelectedResolution();
        if (resolution == null) {
            return;
        }
        Object[] checked = this.markersTable.getCheckedElements();
        this.progressPart.beginTask(MarkerMessages.MarkerResolutionDialog_Fixing, checked.length + 1);
        this.progressPart.worked(1);
        this.calculatingResolutions = true;
        if (resolution instanceof WorkbenchMarkerResolution) {
            IMarker[] markers = new IMarker[checked.length];
            System.arraycopy(checked, 0, markers, 0, checked.length);
            ((WorkbenchMarkerResolution)resolution).run(markers, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)this.progressPart, checked.length));
        } else {
            this.getShell().getDisplay().readAndDispatch();
            if (!this.progressCancelled() && checked.length == 1) {
                IMarker marker = (IMarker)checked[0];
                this.progressPart.subTask(Util.getProperty("message", marker));
                resolution.run(marker);
                this.progressPart.worked(1);
            }
        }
        this.calculatingResolutions = false;
        this.progressPart.done();
        this.progressCancelled = false;
        super.okPressed();
    }

    protected void cancelPressed() {
        if (this.calculatingResolutions) {
            this.progressCancelled = true;
            this.progressPart.setCanceled(true);
            return;
        }
        super.cancelPressed();
    }
}

