/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.text.hover;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.Assert;
import org.eclipse.php.PHPUIMessages;
import org.eclipse.php.core.Logger;
import org.eclipse.php.ui.editor.hover.IPHPTextHover;
import org.eclipse.php.ui.preferences.PreferenceConstants;
import org.eclipse.php.ui.util.EditorUtility;

public class PHPEditorTextHoverDescriptor {
    private static final String PHP_EDITOR_TEXT_HOVER_EXTENSION_POINT = "org.eclipse.php.ui.phpEditorTextHovers";
    private static final String HOVER_TAG = "hover";
    private static final String ID_ATTRIBUTE = "id";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String LABEL_ATTRIBUTE = "label";
    private static final String ACTIVATE_PLUG_IN_ATTRIBUTE = "activate";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private static final String PRIORITY_ATTRIBUTE = "priority";
    public static final String NO_MODIFIER = "0";
    public static final String DISABLED_TAG = "!";
    public static final String VALUE_SEPARATOR = ";";
    private int fStateMask;
    private String fModifierString;
    private boolean fIsEnabled;
    private IConfigurationElement fElement;

    public static PHPEditorTextHoverDescriptor[] getContributedHovers() {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(PHP_EDITOR_TEXT_HOVER_EXTENSION_POINT);
        Arrays.sort(iConfigurationElementArray, new Comparator(){

            public int compare(Object object, Object object2) {
                IConfigurationElement iConfigurationElement = (IConfigurationElement)object;
                IConfigurationElement iConfigurationElement2 = (IConfigurationElement)object2;
                int n = 0;
                int n2 = 0;
                try {
                    n = Integer.valueOf(iConfigurationElement.getAttribute(PHPEditorTextHoverDescriptor.PRIORITY_ATTRIBUTE));
                }
                catch (NumberFormatException numberFormatException) {}
                try {
                    n2 = Integer.valueOf(iConfigurationElement2.getAttribute(PHPEditorTextHoverDescriptor.PRIORITY_ATTRIBUTE));
                }
                catch (NumberFormatException numberFormatException) {}
                return n2 - n;
            }
        });
        PHPEditorTextHoverDescriptor[] pHPEditorTextHoverDescriptorArray = PHPEditorTextHoverDescriptor.createDescriptors(iConfigurationElementArray);
        PHPEditorTextHoverDescriptor.initializeFromPreferences(pHPEditorTextHoverDescriptorArray);
        return pHPEditorTextHoverDescriptorArray;
    }

    public static int computeStateMask(String string) {
        if (string == null) {
            return -1;
        }
        if (string.length() == 0) {
            return 0;
        }
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",;.:+-* ");
        while (stringTokenizer.hasMoreTokens()) {
            int n2 = EditorUtility.findLocalizedModifier(stringTokenizer.nextToken());
            if (n2 == 0 || (n & n2) == n2) {
                return -1;
            }
            n |= n2;
        }
        return n;
    }

    private PHPEditorTextHoverDescriptor(IConfigurationElement iConfigurationElement) {
        Assert.isNotNull((Object)iConfigurationElement);
        this.fElement = iConfigurationElement;
    }

    public IPHPTextHover createTextHover() {
        boolean bl;
        String string = this.fElement.getNamespaceIdentifier();
        boolean bl2 = bl = Platform.getBundle((String)string).getState() == 32;
        if (bl || this.canActivatePlugIn()) {
            try {
                return (IPHPTextHover)this.fElement.createExecutableExtension(CLASS_ATTRIBUTE);
            }
            catch (CoreException coreException) {
                Logger.logException((String)PHPUIMessages.PHPTextHover_createTextHover, (Throwable)coreException);
            }
        }
        return null;
    }

    public String getId() {
        return this.fElement.getAttribute(ID_ATTRIBUTE);
    }

    public String getHoverClassName() {
        return this.fElement.getAttribute(CLASS_ATTRIBUTE);
    }

    public String getLabel() {
        String string = this.fElement.getAttribute(LABEL_ATTRIBUTE);
        if (string != null) {
            return string;
        }
        string = this.getHoverClassName();
        int n = string.lastIndexOf(46);
        if (n >= 0 && n < string.length() - 1) {
            return string.substring(n + 1);
        }
        return string;
    }

    public String getDescription() {
        return this.fElement.getAttribute(DESCRIPTION_ATTRIBUTE);
    }

    public boolean canActivatePlugIn() {
        return Boolean.valueOf(this.fElement.getAttribute(ACTIVATE_PLUG_IN_ATTRIBUTE));
    }

    public boolean equals(Object object) {
        if (object == null || !object.getClass().equals(this.getClass()) || this.getId() == null) {
            return false;
        }
        return this.getId().equals(((PHPEditorTextHoverDescriptor)object).getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    private static PHPEditorTextHoverDescriptor[] createDescriptors(IConfigurationElement[] iConfigurationElementArray) {
        ArrayList<PHPEditorTextHoverDescriptor> arrayList = new ArrayList<PHPEditorTextHoverDescriptor>(iConfigurationElementArray.length);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (HOVER_TAG.equals(iConfigurationElement.getName())) {
                PHPEditorTextHoverDescriptor pHPEditorTextHoverDescriptor = new PHPEditorTextHoverDescriptor(iConfigurationElement);
                arrayList.add(pHPEditorTextHoverDescriptor);
            }
            ++n;
        }
        return arrayList.toArray(new PHPEditorTextHoverDescriptor[arrayList.size()]);
    }

    private static void initializeFromPreferences(PHPEditorTextHoverDescriptor[] pHPEditorTextHoverDescriptorArray) {
        String string;
        String string2 = PreferenceConstants.getPreferenceStore().getString("hoverModifiers");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, VALUE_SEPARATOR);
        HashMap<String, String> hashMap = new HashMap<String, String>(stringTokenizer.countTokens() / 2);
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) continue;
            hashMap.put(string, stringTokenizer.nextToken());
        }
        string = PreferenceConstants.getPreferenceStore().getString("hoverModifierMasks");
        stringTokenizer = new StringTokenizer(string, VALUE_SEPARATOR);
        HashMap<String, String> hashMap2 = new HashMap<String, String>(stringTokenizer.countTokens() / 2);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) continue;
            hashMap2.put(string3, stringTokenizer.nextToken());
        }
        int n = 0;
        while (n < pHPEditorTextHoverDescriptorArray.length) {
            String string4 = (String)hashMap.get(pHPEditorTextHoverDescriptorArray[n].getId());
            boolean bl = true;
            if (string4 == null) {
                string4 = DISABLED_TAG;
            }
            if (string4.startsWith(DISABLED_TAG)) {
                bl = false;
                string4 = string4.substring(1);
            }
            if (string4.equals(NO_MODIFIER)) {
                string4 = "";
            }
            pHPEditorTextHoverDescriptorArray[n].fModifierString = string4;
            pHPEditorTextHoverDescriptorArray[n].fIsEnabled = bl;
            pHPEditorTextHoverDescriptorArray[n].fStateMask = PHPEditorTextHoverDescriptor.computeStateMask(string4);
            if (pHPEditorTextHoverDescriptorArray[n].fStateMask == -1) {
                try {
                    pHPEditorTextHoverDescriptorArray[n].fStateMask = Integer.parseInt((String)hashMap2.get(pHPEditorTextHoverDescriptorArray[n].getId()));
                }
                catch (NumberFormatException numberFormatException) {
                    pHPEditorTextHoverDescriptorArray[n].fStateMask = -1;
                }
                int n2 = pHPEditorTextHoverDescriptorArray[n].fStateMask;
                pHPEditorTextHoverDescriptorArray[n].fModifierString = n2 == -1 ? "" : EditorUtility.getModifierString(n2);
            }
            ++n;
        }
    }

    public int getStateMask() {
        return this.fStateMask;
    }

    public String getModifierString() {
        return this.fModifierString;
    }

    public boolean isEnabled() {
        return this.fIsEnabled;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.fElement;
    }
}

