/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.workingset;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.ui.workingset.WorkingSetModel;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetUpdater;
import org.eclipse.ui.PlatformUI;

public class OthersWorkingSetUpdater
implements IWorkingSetUpdater {
    public static final String ID = "org.eclipse.php.ui.OthersWorkingSet";
    private IWorkingSet fWorkingSet;
    private WorkingSetModel fWorkingSetModel;
    private IResourceChangeListener fResourceChangeListener;
    private IPropertyChangeListener fWorkingSetListener;
    static /* synthetic */ Class class$0;

    public void add(IWorkingSet iWorkingSet) {
        Assert.isTrue((this.fWorkingSet == null ? 1 : 0) != 0);
        this.fWorkingSet = iWorkingSet;
    }

    public boolean remove(IWorkingSet iWorkingSet) {
        Assert.isTrue((this.fWorkingSet == iWorkingSet ? 1 : 0) != 0);
        this.fWorkingSet = null;
        return true;
    }

    public boolean contains(IWorkingSet iWorkingSet) {
        return this.fWorkingSet == iWorkingSet;
    }

    public void init(WorkingSetModel workingSetModel) {
        this.fWorkingSetModel = workingSetModel;
        this.fResourceChangeListener = new ResourceChangeListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.fResourceChangeListener, 1);
        this.fWorkingSetListener = new WorkingSetListener();
        PlatformUI.getWorkbench().getWorkingSetManager().addPropertyChangeListener(this.fWorkingSetListener);
        this.updateElements(this.fWorkingSetModel.getActiveWorkingSets());
    }

    public void dispose() {
        if (this.fResourceChangeListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.fResourceChangeListener);
            this.fResourceChangeListener = null;
        }
        if (this.fWorkingSetListener != null) {
            PlatformUI.getWorkbench().getWorkingSetManager().removePropertyChangeListener(this.fWorkingSetListener);
            this.fWorkingSetListener = null;
        }
    }

    public void updateElements() {
        this.updateElements(this.fWorkingSetModel.getActiveWorkingSets());
    }

    private void updateElements(IWorkingSet[] iWorkingSetArray) {
        ArrayList<IProject> arrayList = new ArrayList<IProject>();
        HashSet<IResource> hashSet = new HashSet<IResource>();
        int n = 0;
        while (n < iWorkingSetArray.length) {
            if (iWorkingSetArray[n] != this.fWorkingSet) {
                IAdaptable[] iAdaptableArray = iWorkingSetArray[n].getElements();
                int n2 = 0;
                while (n2 < iAdaptableArray.length) {
                    IResource iResource;
                    IAdaptable iAdaptable = iAdaptableArray[n2];
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.core.resources.IResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((iResource = (IResource)iAdaptable.getAdapter((Class)clazz)) != null && iResource.getType() == 4) {
                        hashSet.add(iResource);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n3 = 0;
        while (n3 < iProjectArray.length) {
            block12: {
                block11: {
                    try {
                        if (iProjectArray[n3].hasNature("org.eclipse.php.core.PHPNature")) break block11;
                        break block12;
                    }
                    catch (CoreException coreException) {}
                }
                if (!hashSet.contains(iProjectArray[n3])) {
                    arrayList.add(iProjectArray[n3]);
                }
            }
            ++n3;
        }
        this.fWorkingSet.setElements(arrayList.toArray(new IAdaptable[arrayList.size()]));
    }

    private class ResourceChangeListener
    implements IResourceChangeListener {
        private ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
            IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
            IResourceDelta[] iResourceDeltaArray = iResourceDelta.getAffectedChildren(3, 4);
            if (iResourceDeltaArray.length > 0) {
                OthersWorkingSetUpdater.this.updateElements(OthersWorkingSetUpdater.this.fWorkingSetModel.getActiveWorkingSets());
            } else {
                iResourceDeltaArray = iResourceDelta.getAffectedChildren(4, 4);
                int n = 0;
                while (n < iResourceDeltaArray.length) {
                    IResourceDelta iResourceDelta2 = iResourceDeltaArray[n];
                    if ((iResourceDelta2.getFlags() & 0x80000) != 0) {
                        OthersWorkingSetUpdater.this.updateElements(OthersWorkingSetUpdater.this.fWorkingSetModel.getActiveWorkingSets());
                        return;
                    }
                    ++n;
                }
            }
        }
    }

    private class WorkingSetListener
    implements IPropertyChangeListener {
        private WorkingSetListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            IWorkingSet[] iWorkingSetArray;
            IWorkingSet iWorkingSet;
            if ("workingSetContentChange".equals(propertyChangeEvent.getProperty()) && (iWorkingSet = (IWorkingSet)propertyChangeEvent.getNewValue()) != OthersWorkingSetUpdater.this.fWorkingSet && this.contains(iWorkingSetArray = OthersWorkingSetUpdater.this.fWorkingSetModel.getActiveWorkingSets(), iWorkingSet) && !"org.eclipse.php.ui.HistoryWorkingSet".equals(iWorkingSet.getId())) {
                OthersWorkingSetUpdater.this.updateElements(iWorkingSetArray);
            }
        }

        private boolean contains(IWorkingSet[] iWorkingSetArray, IWorkingSet iWorkingSet) {
            int n = 0;
            while (n < iWorkingSetArray.length) {
                if (iWorkingSetArray[n] == iWorkingSet) {
                    return true;
                }
                ++n;
            }
            return false;
        }
    }
}

