/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.PageEventAction;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;

public class ActivateEditorAction
extends PageEventAction {
    private int accelerator;

    public ActivateEditorAction(IWorkbenchWindow window) {
        super(WorkbenchMessages.ActivateEditorAction_text, window);
        this.setToolTipText(WorkbenchMessages.ActivateEditorAction_toolTip);
        this.updateState();
        window.getWorkbench().getHelpSystem().setHelp(this, "org.eclipse.ui.activate_editor_action_context");
        this.setActionDefinitionId("org.eclipse.ui.window.activateEditor");
    }

    public void pageActivated(IWorkbenchPage page) {
        super.pageActivated(page);
        this.updateState();
    }

    public void pageClosed(IWorkbenchPage page) {
        super.pageClosed(page);
        this.updateState();
    }

    public void runWithEvent(Event e) {
        if (this.getWorkbenchWindow() == null) {
            return;
        }
        this.accelerator = e.detail;
        IWorkbenchPage page = this.getActivePage();
        if (page != null) {
            IEditorPart part = page.getActiveEditor();
            if (part != null) {
                page.activate(part);
                part.setFocus();
            } else {
                IWorkbenchPartReference ref = page.getActivePartReference();
                if (ref instanceof IViewReference && ((WorkbenchPage)page).isFastView((IViewReference)ref)) {
                    ((WorkbenchPage)page).toggleFastView((IViewReference)ref);
                }
            }
        }
    }

    public void updateState() {
        IWorkbenchPage page = this.getActivePage();
        this.setEnabled(page != null);
    }

    public int getAccelerator() {
        int accelerator = this.accelerator;
        accelerator &= 0xFFFBFFFF;
        accelerator &= 0xFFFDFFFF;
        return accelerator &= 0xFFFEFFFF;
    }
}

