/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.update;

import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.internal.ui.viewers.provisional.AbstractModelProxy;
import org.eclipse.debug.internal.ui.viewers.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.provisional.ModelDelta;

public class LaunchManagerProxy
extends AbstractModelProxy
implements ILaunchesListener2 {
    private ILaunchManager fLaunchManager;

    public void init(IPresentationContext context) {
        super.init(context);
        this.fLaunchManager = DebugPlugin.getDefault().getLaunchManager();
        this.fLaunchManager.addLaunchListener((ILaunchesListener)this);
    }

    public void installed() {
        ILaunch[] launches = this.fLaunchManager.getLaunches();
        if (launches.length > 0) {
            this.fireDelta(launches, 0x100000);
        }
    }

    public void dispose() {
        super.dispose();
        this.fLaunchManager.removeLaunchListener((ILaunchesListener)this);
        this.fLaunchManager = null;
    }

    public void launchesTerminated(ILaunch[] launches) {
        this.fireDelta(launches, 1024);
    }

    public void launchesRemoved(ILaunch[] launches) {
        this.fireDelta(launches, 2);
    }

    public void launchesAdded(ILaunch[] launches) {
        this.fireDelta(launches, 0x100001);
    }

    public void launchesChanged(ILaunch[] launches) {
        this.fireDelta(launches, 3072);
    }

    protected void fireDelta(ILaunch[] launches, int launchFlags) {
        ModelDelta delta = new ModelDelta(this.fLaunchManager, 0);
        int i = 0;
        while (i < launches.length) {
            delta.addNode(launches[i], launchFlags);
            ++i;
        }
        this.fireModelChanged(delta);
    }
}

