/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.PlatformUI;

public class StorageLabelProvider
extends LabelProvider {
    private IEditorRegistry fEditorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
    private Map fJarImageMap = new HashMap(10);
    private Image fDefaultImage;

    public Image getImage(Object object) {
        if (object instanceof IStorage) {
            return this.getImageForJarEntry((IStorage)object);
        }
        return super.getImage(object);
    }

    public String getText(Object object) {
        if (object instanceof IStorage) {
            return ((IStorage)object).getName();
        }
        return super.getText(object);
    }

    public void dispose() {
        if (this.fJarImageMap != null) {
            Iterator iterator = this.fJarImageMap.values().iterator();
            while (iterator.hasNext()) {
                Image image = (Image)iterator.next();
                image.dispose();
            }
            this.fJarImageMap = null;
        }
        if (this.fDefaultImage != null) {
            this.fDefaultImage.dispose();
        }
        this.fDefaultImage = null;
    }

    private Image getImageForJarEntry(IStorage iStorage) {
        IPath iPath;
        if (this.fJarImageMap == null) {
            return this.getDefaultImage();
        }
        if (iStorage == null || iStorage.getName() == null) {
            return this.getDefaultImage();
        }
        String string = iStorage.getName();
        Image image = (Image)this.fJarImageMap.get(string);
        if (image != null) {
            return image;
        }
        IFileEditorMapping[] iFileEditorMappingArray = this.fEditorRegistry.getFileEditorMappings();
        int n = 0;
        while (n < iFileEditorMappingArray.length) {
            if (iFileEditorMappingArray[n].getLabel().equals(string)) break;
            ++n;
        }
        String string2 = string;
        if (n == iFileEditorMappingArray.length) {
            iPath = iStorage.getFullPath();
            if (iPath == null) {
                return this.getDefaultImage();
            }
            string2 = iPath.getFileExtension();
            if (string2 == null) {
                return this.getDefaultImage();
            }
            image = (Image)this.fJarImageMap.get(string2);
            if (image != null) {
                return image;
            }
        }
        iPath = this.fEditorRegistry.getImageDescriptor(string);
        image = iPath.createImage();
        this.fJarImageMap.put(string2, image);
        return image;
    }

    private Image getDefaultImage() {
        if (this.fDefaultImage == null) {
            this.fDefaultImage = this.fEditorRegistry.getImageDescriptor(null).createImage();
        }
        return this.fDefaultImage;
    }
}

