/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.wizards.fields;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.php.ui.wizards.fields.ITreeListAdapter;
import org.eclipse.php.ui.wizards.fields.TreeListDialogField;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

public class CheckedTreeListDialogField
extends TreeListDialogField {
    private int fCheckAllButtonIndex = -1;
    private int fUncheckAllButtonIndex = -1;
    private List fCheckElements = new ArrayList();

    public CheckedTreeListDialogField(ITreeListAdapter iTreeListAdapter, String[] stringArray, ILabelProvider iLabelProvider) {
        super(iTreeListAdapter, stringArray, iLabelProvider);
    }

    public void setCheckAllButtonIndex(int n) {
        Assert.isTrue((n < this.fButtonLabels.length ? 1 : 0) != 0);
        this.fCheckAllButtonIndex = n;
    }

    public void setUncheckAllButtonIndex(int n) {
        Assert.isTrue((n < this.fButtonLabels.length ? 1 : 0) != 0);
        this.fUncheckAllButtonIndex = n;
    }

    protected TreeViewer createTreeViewer(Composite composite) {
        Tree tree = new Tree(composite, 32 + this.getTreeStyle());
        tree.setFont(composite.getFont());
        ContainerCheckedTreeViewer containerCheckedTreeViewer = new ContainerCheckedTreeViewer(tree);
        containerCheckedTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                CheckedTreeListDialogField.this.doCheckStateChanged(checkStateChangedEvent);
            }
        });
        return containerCheckedTreeViewer;
    }

    public Control getTreeControl(Composite composite) {
        Control control = super.getTreeControl(composite);
        if (composite != null) {
            ((ContainerCheckedTreeViewer)this.fTree).setCheckedElements(this.fCheckElements.toArray());
        }
        return control;
    }

    public void dialogFieldChanged() {
        int n = this.fCheckElements.size() - 1;
        while (n >= 0) {
            if (!this.fElements.contains(this.fCheckElements.get(n))) {
                this.fCheckElements.remove(n);
            }
            --n;
        }
        super.dialogFieldChanged();
    }

    private void checkStateChanged() {
        super.dialogFieldChanged();
    }

    public List getCheckedElements() {
        if (this.isOkToUse((Control)this.fTreeControl)) {
            Object[] objectArray = ((ContainerCheckedTreeViewer)this.fTree).getCheckedElements();
            ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
            int n = 0;
            while (n < objectArray.length) {
                arrayList.add(objectArray[n]);
                ++n;
            }
            return arrayList;
        }
        return new ArrayList(this.fCheckElements);
    }

    public int getCheckedSize() {
        return this.fCheckElements.size();
    }

    public boolean isChecked(Object object) {
        if (this.isOkToUse((Control)this.fTreeControl)) {
            return ((ContainerCheckedTreeViewer)this.fTree).getChecked(object);
        }
        return this.fCheckElements.contains(object);
    }

    public void setCheckedElements(Collection collection) {
        this.fCheckElements = new ArrayList();
        if (collection != null && collection.size() > 0) {
            this.fCheckElements.addAll(collection);
        }
        if (this.isOkToUse((Control)this.fTreeControl)) {
            ((ContainerCheckedTreeViewer)this.fTree).setCheckedElements(collection.toArray());
        }
        this.checkStateChanged();
    }

    public void setChecked(Object object, boolean bl) {
        this.setCheckedWithoutUpdate(object, bl);
        this.checkStateChanged();
    }

    public void setCheckedWithoutUpdate(Object object, boolean bl) {
        if (bl) {
            if (!this.fCheckElements.contains(object)) {
                this.fCheckElements.add(object);
            }
        } else {
            this.fCheckElements.remove(object);
        }
        if (this.isOkToUse((Control)this.fTreeControl)) {
            ((ContainerCheckedTreeViewer)this.fTree).setChecked(object, bl);
        }
    }

    public void checkAll(boolean bl) {
        if (bl) {
            this.fCheckElements = this.getElements();
        } else {
            this.fCheckElements.clear();
        }
        if (this.isOkToUse((Control)this.fTreeControl)) {
            ((ContainerCheckedTreeViewer)this.fTree).setAllChecked(bl);
        }
        this.checkStateChanged();
    }

    private void doCheckStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
        if (checkStateChangedEvent.getChecked()) {
            this.fCheckElements.add(checkStateChangedEvent.getElement());
        } else {
            this.fCheckElements.remove(checkStateChangedEvent.getElement());
        }
        this.checkStateChanged();
    }

    public void replaceElement(Object object, Object object2) throws IllegalArgumentException {
        boolean bl = this.isChecked(object);
        super.replaceElement(object, object2);
        this.setChecked(object2, bl);
    }

    protected boolean getManagedButtonState(ISelection iSelection, int n) {
        if (n == this.fCheckAllButtonIndex) {
            return !this.fElements.isEmpty();
        }
        if (n == this.fUncheckAllButtonIndex) {
            return !this.fElements.isEmpty();
        }
        return super.getManagedButtonState(iSelection, n);
    }

    protected boolean managedButtonPressed(int n) {
        if (n == this.fCheckAllButtonIndex) {
            this.checkAll(true);
        } else if (n == this.fUncheckAllButtonIndex) {
            this.checkAll(false);
        } else {
            return super.managedButtonPressed(n);
        }
        return true;
    }
}

