/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.server.core;

import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.php.core.project.options.PHPProjectOptions;
import org.eclipse.php.core.util.preferences.IXMLPreferencesStorable;
import org.eclipse.php.server.core.Logger;
import org.eclipse.php.server.core.ServerHelper;

public class Server
implements IXMLPreferencesStorable {
    public static final String SERVER_ELEMENT = "server";
    public static final String NAME = "name";
    public static final String BASE_URL = "base_url";
    public static final String DOCUMENT_ROOT = "document_root";
    public static final String PUBLISH = "publish";
    public static final String PUBLISH_TO = "publish_to";
    public static final String PORT = "port";
    public static final String HOSTNAME = "hostname";
    public static final String FILE_NAME = "file_name";
    public static final String CONTEXT_ROOT = "context_root";
    private static final int DEFAULT_HTTP_PORT = 80;
    private ServerHelper helper = new ServerHelper(this);

    public Server() {
    }

    public Server(String string, String string2, String string3, String string4, boolean bl) {
        this();
        this.setName(string);
        this.setHost(string2);
        this.setBaseURL(string3);
        this.setDocumentRoot(string4);
        this.setPublish(bl);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.helper.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.helper.removePropertyChangeListener(propertyChangeListener);
    }

    public void setAttribute(String string, String string2) {
        this.helper.setAttribute(string, string2);
    }

    public String getAttribute(String string, String string2) {
        return this.helper.getAttribute(string, string2);
    }

    public void removeAttribute(String string) {
        this.helper.removeAttribute(string);
    }

    public String getContextRoot(IProject iProject) {
        PHPProjectOptions pHPProjectOptions = PHPProjectOptions.forProject((IProject)iProject);
        String string = (String)pHPProjectOptions.getOption("org.eclipse.php.core.contextRoot");
        if (string == null || string.equals("")) {
            string = iProject.getFullPath().toString();
        }
        return string;
    }

    public String getName() {
        return this.getAttribute(NAME, "");
    }

    public void setName(String string) {
        this.setAttribute(NAME, string);
    }

    public String getBaseURL() {
        return this.getAttribute(BASE_URL, "");
    }

    public void setBaseURL(String string) {
        this.setAttribute(BASE_URL, string);
    }

    public String getHost() {
        return this.getAttribute(HOSTNAME, "localhost");
    }

    public void setHost(String string) {
        this.setAttribute(HOSTNAME, string);
    }

    public void setDocumentRoot(String string) {
        this.setAttribute(DOCUMENT_ROOT, string);
    }

    public String getDocumentRoot() {
        return this.getAttribute(DOCUMENT_ROOT, "");
    }

    public boolean canPublish() {
        return Boolean.valueOf(this.getAttribute(PUBLISH, "false"));
    }

    public void setPublish(boolean bl) {
        this.setAttribute(PUBLISH, Boolean.toString(bl));
    }

    public URL getRootURL() {
        try {
            String string = this.getPortString();
            String string2 = this.getBaseURL();
            if (string2.equals("")) {
                string2 = "http://" + this.getHost();
            }
            URL uRL = null;
            uRL = string.equals("80") ? new URL(String.valueOf(string2) + "/") : new URL(String.valueOf(string2) + ":" + string + "/");
            return uRL;
        }
        catch (Exception exception) {
            Logger.logException("Could not get root URL", exception);
            return null;
        }
    }

    protected static String renderCommandLine(String[] stringArray, String string) {
        if (stringArray == null || stringArray.length < 1) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        int n = 1;
        while (n < stringArray.length) {
            stringBuffer.append(string);
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public int getPort() {
        int n = Integer.parseInt(this.getPortString());
        if (n < 0) {
            n = 80;
        }
        return n;
    }

    public String getPortString() {
        return this.getAttribute(PORT, "80");
    }

    public void setPort(String string) {
        try {
            if (string.equals("")) {
                this.setAttribute(PORT, "80");
            } else {
                this.setAttribute(PORT, string);
            }
        }
        catch (Throwable throwable) {}
    }

    public String toString() {
        return "Server [" + this.getName() + "::" + this.getHost() + ']';
    }

    public void restoreFromMap(HashMap hashMap) {
        HashMap hashMap2 = (HashMap)hashMap.get(SERVER_ELEMENT);
        Iterator iterator = hashMap2.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.setAttribute(string, (String)hashMap2.get(string));
        }
    }

    public HashMap storeToMap() {
        HashMap hashMap = new HashMap(this.helper.map);
        HashMap hashMap2 = new HashMap(1);
        hashMap2.put(SERVER_ELEMENT, hashMap);
        return hashMap2;
    }
}

